
/**********************************************************************
 * $Id: connect.c,v 1.3 92/11/30 11:31:35 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>
#include <xerion/simulator.h>
#include "connect.h"

static void	connectFromGroup ARGS((Unit	unit, void	*data)) ;
static void	connectToUnit	 ARGS((Unit	unit, void	*data)) ;
static void	disconnectFromPostGroup ARGS((Unit  unit, void	*data)) ;
static void	disconnectFromPreUnit   ARGS((Unit  unit, void	*data)) ;

/***********************************************************************
 *	Name:		connectUnits
 *	Description:	connects together to units by creating a link
 *			and setting all the appropriate fields
 *	Parameters:	
 *		Unit	preUnit  - the unit the link is to come from
 *		Unit	postUnit - the unit the link is to go to
 *		Mask	mask     - a mask to use when creating the link
 *	Return Value:	
 *		the link created
 ***********************************************************************/
Link	connectUnits (preUnit, postUnit, mask)
  Unit	preUnit ;
  Unit	postUnit ;
  Mask	mask ;
{
  char	name[128] ;
  
  sprintf(name, "%s -> %s", preUnit->name, postUnit->name) ;
  return createLink (name, preUnit, postUnit, mask) ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		connectGroups
 *	Description:	connects two groups completely
 *	Parameters:	
 *		Group	preGroup   - the group the links are to come from
 *		Group	postGroup  - the group the links are to go to
 *		Mask	mask       - a mask to use when creating the links
 *	Return Value:	
 ***********************************************************************/
static Mask	linkMask ;
static int	status ;
int	connectGroups (preGroup, postGroup, mask)
  Group	preGroup ;
  Group	postGroup ;
  Mask	mask ;
{
  linkMask = mask ;
  status = 1 ;
  groupForAllUnits(postGroup, connectFromGroup, preGroup) ;
  return status ;
}
/**********************************************************************/
static void	connectFromGroup(unit, data)
  Unit		unit ;
  void		*data ;
{
  Group	preGroup = (Group)data ;
  
  groupForAllUnits(preGroup, connectToUnit, unit) ;
}
/**********************************************************************/
static void	connectToUnit(unit, data)
  Unit		unit ;
  void		*data ;
{
  Unit	postUnit = (Unit)data ;
  if (connectUnits(unit, postUnit, linkMask) == NULL)
    status = 0 ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		disconnectUnits
 *	Description:	disconnects two units by destroying the
 *			link between them.
 *	Parameters:	
 *		Unit	preUnit  - the unit the link is to come from
 *		Unit	postUnit - the unit the link is to go to
 *	Return Value:	
 *		NONE
 ***********************************************************************/
int	disconnectUnits (preUnit, postUnit)
  Unit	preUnit ;
  Unit	postUnit ;
{
  int	idx ;
  
  for (idx = 0 ; idx < preUnit->numOutgoing ; ++idx) {
    if (postUnit == preUnit->outgoingLink[idx]->postUnit) {
      destroyLink(preUnit->outgoingLink[idx]) ;
      break ;
    }
  }
  return 1 ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		disconnectGroups
 *	Description:	disconnects two groups completely
 *	Parameters:	
 *		Group	preGroup   - the group the links are to come from
 *		Group	postGroup  - the group the links are to go to
 *	Return Value:	
 ***********************************************************************/
int	disconnectGroups (preGroup, postGroup)
  Group	preGroup ;
  Group	postGroup ;
{
  groupForAllUnits(preGroup, disconnectFromPostGroup, postGroup) ;
  return 1 ;
}
/**********************************************************************/
static void	disconnectFromPostGroup(unit, data)
  Unit		unit ;
  void		*data ;
{
  Group		postGroup = (Group)data ;
  
  groupForAllUnits(postGroup, disconnectFromPreUnit, unit) ;
}
/**********************************************************************/
static void	disconnectFromPreUnit(unit, data)
  Unit		unit ;
  void		*data ;
{
  Unit		preUnit = (Unit)data ;
  disconnectUnits(preUnit, unit) ;
}
/**********************************************************************/
