
/**********************************************************************
 * $Id: access.h,v 1.3 92/11/30 13:12:25 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/

#ifndef SIM_ACCESS_H
#define SIM_ACCESS_H

typedef enum _SyncDirection
  { WeightsFromVector, VectorFromWeights } SyncDirection ;

extern int	getNumberOfVars	  ARGS((Net  net)) ;
extern char     *getValueName	  ARGS((Net  net, int  n)) ;
extern int	getCurrentValues  ARGS((Net  net, int  n, Real value[])) ;
extern int	setCurrentValues  ARGS((Net  net, int  n, Real value[])) ;
extern Real	evaluate	  ARGS((Net  net, int  n, Real value[])) ;
extern Real	calculateGradient ARGS((Net  net, 
					int  n, Real value[], Real grad[])) ;
extern int	setDelta	  ARGS((Net  net, int  n, Real start[],
					Real end[])) ;
extern void	syncValues	  ARGS((Net, SyncDirection)) ;

#endif				/* SIM_ACCESS_H */
