
/**********************************************************************
 * $Id: wobbly.c,v 1.2 92/11/30 11:31:03 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>

#include <xerion/useful.h>
#include "minimize.h"
#include "wobbly.h"

/**********************************************************************
 * Check if the gradients are consistent.  Look at the sorted record
 * of steps (sorted on stepsize).  For each adjecent pair of steps, if
 * the slopes are in the same direction, they should be consistent
 * with the change in function values between those points.  If a good
 * proportion of the pairs are not consistent, this is an indication
 * that the function values are not very accurate.
 *********************************************************************/

int		gradientsConsistent(mz, goodp, totalp)
  Minimize	mz ;
  int		*goodp ;
  int		*totalp ;
{
  int good, m, i, total, upper, lower;
  double delta;
  m = mz->lsnFuncEvals+1;
  /* count the number of points where the slope agrees with func values */
  good = 0;
  total = 0;
  for (i=0; i<m-1; i++) {
    upper = mz->lsOrder[i+1];
    lower = mz->lsOrder[i];
    delta = mz->lsFuncValue[upper]-mz->lsFuncValue[lower];
    if (mz->lsSlope[lower] * mz->lsSlope[upper] > 0) {
      total++;
      if (delta*mz->lsSlope[lower] > 0)
	good++;
    }
  }

  if (total>0)
    VB(2, mz->lsVerbosity,
       "Wobble test = %g (%d/%d)\n", good/(Real)total, good,total);

  if (goodp!=NULL)
    *goodp = good;
  if (totalp!=NULL)
    *totalp = total;

  if (total>0 && good<total-1)
    return 0;
  else
    return 1;
}
