
/**********************************************************************
 * $Id: newstep.c,v 1.2 92/11/30 11:30:55 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>
#include <math.h>
#include <errno.h>

#include <xerion/useful.h>
#include "minimize.h"
#include "initialstep.h"

/***********************************************************************
 *  Name:		newStep
 *  Description:
 *	This routine is here to be customized by the user.
 *	It currently prints out the information that can be
 *	used, and returns the value give by dRatioStep()
 *			
 *  Parameters:
 *I	Minimize	mz	- the minimize record
 *I	double		a	- the previous stepsize
 *I	double		f	- the current value of f
 *I	double		d	- the slope
 *I	double		d_ratio	- the slope ratio
 *I	double		delta_f	- the previous reduction in f
 *I	double		g_len	- the length of the g vector
 *I	double		s_len	- the length of the search vector
 *
 *  Return Value:
 * 	double		newStep
 *				- the size of the step
 *
 ***********************************************************************/

double		newStep(mz, a, f, d, d_ratio, delta_f, g_len, s_len)
  Minimize	mz ;
  double	a ;
  double	f ;
  double	d ;
  double	d_ratio ;
  double	delta_f ;
  double	g_len ;
  double	s_len ;
{
  fprintf(dout, "Initial step data: previous step= %.6g f= %.6g d= %.6g dratio= %.6g\n  delta_f= %.6g g_len= %.6g s_len= %.6g\n",
	  a, f, d, d_ratio, delta_f, g_len, s_len);
  fprintf(dout, "sLenStep= %g dRatioStep= %g shootStep= %g\n",
	  sLenStep(s_len), dRatioStep(a, g_len, d_ratio),
	  shootStep(mz, f, d, delta_f));
  a = dRatioStep(a, g_len, d_ratio);
  fprintf(dout, "Using dRatioStep %g\n", a);
  return a;
}
