
/**********************************************************************
 * $Id: minimize.h,v 1.4 93/01/26 11:19:49 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef MINIMIZE_H
#define MINIMIZE_H

typedef struct minimizeRec *Minimize ; /* BIND */

typedef void	(*voidFunc) ARGS((Minimize));
typedef int	(*intFunc)  ARGS((Minimize));
typedef char*	(*strFunc)  ARGS((Minimize, int));
typedef Real	(*RealVecFunc)  ARGS((Minimize, int, Real *));
typedef int	(*VecProc)      ARGS((Minimize, int, Real *));
typedef Real	(*Real2VecFunc) ARGS((Minimize, int, Real *, Real *));
typedef void  	*(*UnknownProc)	ARGS(());

typedef struct minimizeRec { /* BIND */
  struct minimizeRec	*mep1;		/* NOBIND */
					/* points to this record as a check */
  /* modifiable parameters */
  int		maxFuncEvals ;		/* miniParam: */
  int		maxIterations ;		/* miniParam: */
  int		lsFlexFuncEvals ; 	/* miniParam:
					 * extra evaluations allowed in order
					 * to complete a line search */
  int		lsMaxFuncEvals ; 	/* miniParam: */
  int		repetitionCount ;	/* miniParam: */
  
  int		directionMethod ;
  int		stepMethod ;
  int		initialStepMethod ;
  int		continueDirection ;
  int		samePosition ;
  
  Real		acceptableFuncMin ;	/* miniParam:
					   stop if error goes below this */
  Real		expectedFuncMin ; 	/* miniParam: */

  /* following are used in line search routines */
  Real		tolerance ; 		/* miniParam: */
  Real		machinePrecision ;
  Real		minFuncReduction ; 	/* miniParam: */
  Real		maxSlopeRatio ; 	/* miniParam: */
  Real		backUpFactor ;		/* miniParam: */
  Real		initialStepFactor ; 	/* miniParam: */
  Real		stepBound ;		/* miniParam: used in Ray's ls */
  Real		extrapLimits ;		/* miniParam: used in Ray's ls */
  Real		interpLimits ;		/* miniParam: used in Ray's ls */
  Real		extensor ;		/* miniParam: used in Ray's ls */
  Real		maxExtrapol ;		/* miniParam: used in Ray's ls */
  int		quasiNewton ;		/* used in Ray's ls */
  int		localMinima ;		/* used in Ray's ls */
  int		wolfeTest ;		/* used in Ray's ls */

  Real		funcValueScale ;	/* miniParam: */
  Real		funcPrecision ;		/* miniParam: */

  int		wobbleTest ;
  int		wobbleWatch ;
  Real		wobbleTolerance ;
  Real		wobbleFlex ;
  int		wobbleTestNPoints ;
  int		wobbleTestLastUsed ;

  int		doNotCheckFunctions ;
  int		checkOutVerbosity ;

  Real		epsilon ;	/* miniParam: used by fixed step rule */
  Real		alpha ;		/* miniParam: used by fixed step rule */

  Real		gainIncrement ;	/* miniParam: used by delta-bar-delta rule */
  Real		gainDecrement ;	/* miniParam: used by delta-bar-delta rule */

  Real		maxGrowthFactor ;	/* miniParam: used by quickprop */
  Real		qpEpsilon ;		/* miniParam: used by quickprop */

  double	paramChksum ;		/* nsi: */
  
  String	lsLogFile ;

  int		setSearchToLen ;

  int		lsVerbosity ;		/* miniParam: */
  int		lsDebug ;
  int		lsSummarize ;		/* miniParam: */
  int		mzVerbosity ;		/* miniParam: */
  int		mzDebug ;

  int		lsPlot ;
  int		lsPlotPoints ;
  /* end of modifiable parameters */

  int		nIterations ; /* Number of steps taken (iterations) */
  int		nFuncEvals ; /* Total number of function evaluations to make */
  int		lsnFuncEvals ;
  
  Real		E ;
  Real		lastE ;
  Real		bestE ;
  
  int		n ;		/* nosave: */
  int		nInit ;
  Real		*x ;		/* nsi: counter: n	x[i] in varmin */
  Real		*bestx ;	/* nsi: counter: n	(not in varmin) */
  Real		*gradient ;	/* nsi: counter: n 	g[i] in varmin */
  Real		*bestGradientF;	/* nsi: counter: n	(not in varmin) */
  Real		*bestGradientD;	/* nsi: counter: n	(not in varmin) */
  Real		*prevGradient ;	/* nsi: counter: n	w[ng+i] in varmin */
  Real		*update ;	/* nsi: counter: n	(not in varmin) */
  Real		*search ;	/* nsi: counter: n	w[i] in varmin */
  Real		*start ;	/* nsi: counter: n	w[nx+i] in varmin */
  		/* Following two vectors are used by conjgrad + restarts,
		   and by delta-bar-delta method */
  Real		*rsty ;		/* nsi: counter: n	w[ny+i] in varmin */
  Real		*rstd ;		/* nsi: counter: n	w[nd+i] in varmin */
  int		chksum ;

  Real		xLen ;
  int		prevDirectionMethod ;
  int		prevStepMethod ;

  int		lsnPoints ;	/* nosave:
				 * three arrays save results of lineSearch */
  double	*lsStep ;	/* nsi: counter: lsnPoints */
  double	*lsFuncValue ;	/* nsi: counter: lsnPoints */
  double	*lsSlope ;	/* nsi: counter: lsnPoints */
  int		*lsHaveSlope ;	/* nsi: counter: lsnPoints */
  int		*lsOrder ;	/* nsi: counter: lsnPoints */

  int		lsBestByF;
  int		lsBestByD;

  int		lsResultCode ;
  String	lsResult ;
  String	evalReason ;
  int		mzResultCode ;
  String	mzResult ;
  int		stopFlag ;

  int		askStep ;

  /* the following are used to save variables used in minimize0 to make
     it possible to continue a direction after exiting minimize0 */
  int		nrs;
  double	c;
  double	c1;
  double	c2;
  double	a;
  double	delta_f;
  double	d;
  double	d_prev;
  double	x_len;
  double	g_len;
  double	s_len;
  double	start_cos;
  double	end_cos;

  /* methods for evaluating functions */
  intFunc	getNVars ;
  VecProc	getValues ;
  VecProc	setValues ;
  RealVecFunc	fEval ;
  VecProc	gEval ;
  Real2VecFunc	fgEval ;
  strFunc	valueName ;
  voidFunc	incIter ;

  void		*userData ;

  struct minimizeRec	*mep2;		/* NOBIND */
					/* points to this record as a check */
} minimizeRec ;

extern struct TRACE beginMinimize ;		/* BIND */
extern struct TRACE minimizeEndIteration;	/* BIND */
extern struct TRACE minimizeEndRepetition;	/* BIND */
extern struct TRACE endMinimize ;		/* BIND */

extern void	NULL_proc       ARGS(()) ;
extern void	checkParameters ARGS((Minimize mz)) ;
extern Minimize	initMinimize    ARGS((Minimize mz, int n)) ;
extern void	minimize        ARGS((Minimize mz, int evals, int iters)) ;

extern UnknownProc setMinimizeMethod ARGS((Minimize, 
					  unsigned which, UnknownProc)) ;
extern void	  *setMinimizeUserData ARGS((Minimize, void *)) ;

extern void	VB ARGS(()) ;

/***
 *
 * Return codes:
 * -------------
 * MZCONVERGE	  algorithm has converged
 * MZOKFMIN	  function value is less than mz->acceptableFuncMin
 * MZMAXF	  exceeded maximum # of function evaluations
 * MZMAXFLINE     exceeded maximum # of function evaluations in line search
 * MZMAXFLINEFAIL exceeded maximum # of function evaluations in line search
 *		  and did not find better function value
 * MZSUCCEED	  line search succeeded
 * MZSTOPPED	  stopFlag in net was set while running
 * MZINTERRUPTED  minimize was interrupted
 * MZFAILIMPROVE  line search failed to improve function value
 * MZNOGRADIENT   gradient disappeared during line search
 * MZNOTDESCENT   search vector is not descent
 * MZWOBBLY	  function wobbliness was detected
 * MZFAIL	  line search failed
 * MZSYSTEMERROR  system error
 * MZBADMETHOD	  method not implemented
 * MZBADRETURN	  bad return value from other function
 */

/* change minimize.1 if these numbers are changed */

#define MZCONVERGE	1
#define MZOKFMIN	2
#define MZMAXF		3
#define MZMAXITER	4
#define MZMAXFLINE	5
#define MZMAXFLINEFAIL	6
#define MZSUCCEED	7
#define MZSTOPPED	8
#define MZINTERRUPTED	9
#define MZFAILIMPROVE	10
#define MZNOGRADIENT	11
#define MZNOTDESCENT	12
#define MZWOBBLY	13
#define MZFAIL		14
#define MZSYSTEMERROR	15
#define MZBADMETHOD	16
#define MZBADRETURN	17

#define MZFIXEDSTEP	1
#define MZRUDISLS	10
#define MZRAYSLS	11
#define MZSLOPESEARCH	12

#define	MZSHOOT		41
#define MZDRATIO	42
#define MZDRATIOSHOOT	43
#define	MZISSLEN	44
#define	MZISASK		45
#define	MZISNEW		46
#define MZSTEEPEST	100
#define MZMOMENTUM	101
#define MZQUICKPROP	102
#define MZDELTABARDELTA	103
#define	MZRUDICG	110
#define	MZCONJGRAD	112
#define	MZCONJGRADRST	111

#define MZMAXMETHOD	120

#define MZUSERDATA	1
#define MZGETNVARS	2
#define MZGETVALUES	3
#define MZSETVALUES	4
#define MZFEVAL		5
#define MZGEVAL		6
#define MZFGEVAL	7
#define MZVALUENAME	8
#define MZINCITER	9

#endif				/* MINIMIZE_H */
