/***
 * This update record is intended to allow the checking of gradients.
 * 
 * The command "check-gradients" does the following:
 * -- first calculate the error & derivatives
 * for each example {
 *   ForwardProp(net);
 *   BackwardProp(net);
 * }
 * store E in update.original_E
 * for each link & time step {
 *   update.link_num is set to the link number
 *   update.t is set to the time
 *   UpdateOneWeight(net) - Which just calculate an update for a link, and
 *                        - store it in new_p (i.e. don't change any links)
 *                        - The following fields are used:
 *			  - grad       - if 1 do a gradient movement, otherwise
 *                                     - try to get dE = -np.epsilon
 *                        - dp         - the actual change made
 *                        - dEdp       - the local gradient
 *                        - old_p      - store the old parameter
 *                        - new_p      - the new parameter
 *                        - link       - pointer to the link to be changed
 *
 *   ForwardProp(net)     - Which should load the new parameter at the
 *                          appropriate time, using the pointer provided
 *   the resulting E (in np->sumsq_errors) is stored in update.E_prime,
 *   and the ratio of expected change to actual change is calculated
 *   and stored
 * }
 */

#ifndef __xerion_checkgrad_h
#define __xerion_checkgrad_h

typedef struct CHECK_GRAD {	/* BIND */
  int	method;		/* default: 0 if 1 do gradient descent */
  int	verbosity;
  int	printall;
  Real	epsilon;	/* default: 0.01 */
  Real	epswarn; /* warn if relative change in x or E is < 10^epswarn*macheps*/
  Real	gwarn;	 /* warn if gradient relative change is < gwarn or > 1/gwarn*/
  Real  criterion; /* ratios can only be this different */
} *CheckGrad;

extern struct CHECK_GRAD check_grad;	/* BIND */

extern int checkGradients
  ARGS((struct CHECK_GRAD *chkg,
	int 	n,	/* size of x & ef */
	Real 	*x,	/* values to do it at */
	Real 	*ef,	/* error factors in gradient */
	Minimize	mz,	/* minimize record */
	RealVecFunc	fEval,
	VecProc		gEval,
	Real2VecFunc 	fgEval, /* evaluation function */
	strFunc	vName));	/* name of value */

int checkOutFunctions
  ARGS((Minimize	mz,
	intFunc		getNVars,
	VecProc		getValues,
	VecProc		setValues,
	RealVecFunc	fEval,
	VecProc		gEval,
	Real2VecFunc	fgEval,
	strFunc		getValueName,
	char		*me,	/* name to use on error msgs */
	int		verbosity)) ;

#endif /* __xerion_checkgrad_h */
