
/**********************************************************************
 * $Id: minor.c,v 1.5 92/11/30 11:30:14 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>

#include <xerion/useful.h>
#include <xerion/simulator.h>
#include "layoutUtils.h"
#include "minor.h"

static int	perRow ;
static Unit	forUnit ;
static Group	forGroup ;
static void	setUnitDefault ARGS((Unit	unit, void	*data)) ;
static void	setLinkDefault ARGS((Link	link, void	*data)) ;

/***********************************************************************
 *	Name:		setMinorOptions
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	setMinorOptions (net, argv, argc)
  Net	net ;
  char	**argv ;
  int	argc ;
{
  int	line = layoutInputLine ;
  Mask	mask ;

  forUnit  = NULL ;
  forGroup = NULL ;
  if (argc == 3 && strcmp(argv[1], "for-unit") == 0) {
    forUnit = unitFromName(net, argv[2]) ;
    if (forUnit == NULL)
      IErrorAbort("Line %d: unknown unit \"%s\"", line, argv[2]) ;

    if (net->linkLayoutMode == SHOW_OUTGOING)
      mask = OUTGOING ;
    else if (net->linkLayoutMode == SHOW_ALL)
      mask = INCOMING | OUTGOING ;
    else 
      mask = INCOMING ;
    
    unitForAllLinks(forUnit, mask, setLinkDefault, (void *)mask) ;

  } else if (argc == 3 && strcmp(argv[1], "for-group") == 0) {
    forGroup = groupFromName(net, argv[2]) ;
    if (forGroup == NULL)
      IErrorAbort("Line %d: unknown group \"%s\"", line, argv[2]) ;
    if (net->linkLayoutMode == SHOW_OUTGOING)
      mask = OUTGOING ;
    else if (net->linkLayoutMode == SHOW_ALL)
      mask = INCOMING | OUTGOING ;
    else 
      mask = INCOMING ;
    
    groupForAllUnits(forGroup, setUnitDefault, (void *)mask) ;

  } else {
    net->linkLayoutMode = SHOW_INCOMING ;
    for (--argc, ++argv ; argc > 0 ; --argc, ++argv) {
      char	*ptr, *option = *argv ;

      --argc, ++argv ;
      if (argc == 0) {
	IErrorAbort("Line %d: missing argument for \"%s\"", line, option) ;

      } else if (strcmp(option, "cell-size") == 0) {
	net->minorHeight = strtol(*argv, &ptr, 0) ;
	net->minorWidth  = net->minorHeight ;
	if (*ptr != '\0') 
	  IErrorAbort("Line %d: bad cell size \"%s\"", line, *argv) ;

      } else if (strcmp(option, "margin") == 0) {
	net->minorMargin = strtol(*argv, &ptr, 0) ;
	if (*ptr != '\0') 
	  IErrorAbort("Line %d: bad margin size \"%s\"", line, *argv) ;

      } else if (strcmp(option, "per-row") == 0) {
	perRow = strtol(*argv, &ptr, 0) ;
	if (*ptr != '\0') 
	  IErrorAbort("Line %d: bad units per row \"%s\"", line, *argv) ;

      } else if (strcmp(option, "show-links") == 0) {
	if (strcmp(*argv, "incoming") == 0)
	  net->linkLayoutMode = SHOW_INCOMING ;
	else if (strcmp(*argv, "outgoing") == 0)
	  net->linkLayoutMode = SHOW_OUTGOING ;
	else if (strcmp(*argv, "all") == 0)
	  net->linkLayoutMode = SHOW_ALL ;
	else
	  IErrorAbort("Line %d: bad option \"%s\"", line, *argv) ;

      } else if (strcmp(option, "for-unit") == 0
		 || strcmp(option, "for-group") == 0) {
	IErrorAbort("Line %d: \"%s\" cannot appear with other options",
		    line, option);

      } else {
	IErrorAbort("Line %d: bad option \"%s\"", line, option) ;
      }
    }

    netForAllUnits(net, ALL, setUnitDefault, (void *)INCOMING) ;
  }
  
  resetLastLaid() ;
  resetCurrentRow() ;

  return 1 ;
}
/**********************************************************************/
static void	setLinkDefault(link, data)
  Link		link ;
  void		*data ;
{
  Mask	mask = (Mask)data ;
  if (mask & INCOMING) {
    link->weightRow[1]    = -1 ;
    link->weightColumn[1] = -1 ;
  }
  if (mask & OUTGOING) {
    link->weightRow[0]    = -1 ;
    link->weightColumn[0] = -1 ;
  }
}
/**********************************************************************/
static void	setUnitDefault(unit, data)
  Unit		unit ;
  void		*data ;
{
  unitForAllLinks(unit, (Mask)data, setLinkDefault, data) ;
}
/**********************************************************************/


/**********************************************************************/
static Link	findLinkBetween(from, to)
  Unit		from ;
  Unit		to ;
{
  int	idx ;
  int	numIncoming = to->numIncoming ;
  Link	*incoming   = to->incomingLink ;

  for (idx = 0 ; idx < numIncoming ; ++idx)
    if (incoming[idx]->preUnit == from)
      break ;

  if (idx < numIncoming)
    return incoming[idx] ;
  else
    return NULL ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		setMinorLine
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	setMinorLine(net, argv, argc) 
  Net	net ;
  char	**argv ;
  int	argc ;
{
  int		unitIdx ;
  int		currentColumn ;
  Group		group ;
  Section	*section ;

  section = buildSections(argv, argc) ;
  if (section == NULL)
    return 0 ;

  section = fillSections(net, section, perRow) ;
  if (section == NULL) 
    return 0 ;

  currentColumn = 0 ;
  while (section->type != End) {
    Link	link ;
    switch (section->type) {
    case All:
    case Sect:
    case Next:
      group = groupFromName(net, section->name) ;
      for (unitIdx = section->from ; 
	   unitIdx < section->from + section->size ; ++unitIdx ) {
	if (forUnit) {
	  if ((net->linkLayoutMode == SHOW_INCOMING ||
	       net->linkLayoutMode == SHOW_ALL)
	      && (link = findLinkBetween(group->unit[unitIdx], forUnit))) {
	    link->weightRow[1]    = getCurrentRow() ;
	    link->weightColumn[1] = currentColumn ;
	  }
	  if ((net->linkLayoutMode == SHOW_OUTGOING ||
	       net->linkLayoutMode == SHOW_ALL)
	      && (link = findLinkBetween(forUnit, group->unit[unitIdx]))) {
	    link->weightRow[0]    = getCurrentRow() ;
	    link->weightColumn[0] = currentColumn ;
	  }
	} else if (forGroup) {
	  int subIdx ;
	  for (subIdx = 0 ; subIdx < forGroup->numUnits ; ++subIdx) {
	    if ((net->linkLayoutMode == SHOW_INCOMING ||
		 net->linkLayoutMode == SHOW_ALL)
		&& (link = findLinkBetween(group->unit[unitIdx], 
					  forGroup->unit[subIdx]))) {
	      link->weightRow[1]    = getCurrentRow() ;
	      link->weightColumn[1] = currentColumn ;
	    }
	    if ((net->linkLayoutMode == SHOW_OUTGOING ||
		 net->linkLayoutMode == SHOW_ALL)
		&& (link = findLinkBetween(forGroup->unit[subIdx],
					  group->unit[unitIdx]))) {
	      link->weightRow[0]    = getCurrentRow() ;
	      link->weightColumn[0] = currentColumn ;
	    }
	  }
	} else {
	  int	numLinks ;
	  Link	*link ;
	  int	idx ;

	  numLinks = group->unit[unitIdx]->numOutgoing ;
	  link	   = group->unit[unitIdx]->outgoingLink ;
	  if (net->linkLayoutMode == SHOW_INCOMING ||
	      net->linkLayoutMode == SHOW_ALL) {
	    for (idx = 0 ; idx < numLinks ; ++idx) {
	      link[idx]->weightRow[1]    = getCurrentRow() ;
	      link[idx]->weightColumn[1] = currentColumn ;
	    }
	  }

	  if (net->linkLayoutMode == SHOW_INCOMING ||
	      net->linkLayoutMode == SHOW_ALL) {
	    numLinks = group->unit[unitIdx]->numIncoming ;
	    link	   = group->unit[unitIdx]->incomingLink ;
	    for (idx = 0 ; idx < numLinks ; ++idx) {
	      link[idx]->weightRow[0]    = getCurrentRow() ;
	      link[idx]->weightColumn[0] = currentColumn ;
	    }
	  }
	}
	++currentColumn ;
      }
      break ;

    case Blank:
    case Fill:
      currentColumn += section->size ;
      break ;
    default:
      break ;
    }
    ++section ;
  }

  return 1 ;
}
/**********************************************************************/
