
/**********************************************************************
 * $Id: major.c,v 1.5 92/11/30 11:30:11 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>

#include <xerion/useful.h>
#include <xerion/simulator.h>
#include "layoutUtils.h"
#include "major.h"

#ifndef MAX
#define MAX(x,y)	((x) > (y) ? (x) : (y))
#endif

static int	perRow ;
static Boolean	widthSet, heightSet ;

static void	setDefaultLayout ARGS((Unit	unit, void	*data)) ;

/***********************************************************************
 *	Name:		setMajorOptions
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	setMajorOptions (net, argv, argc)
  Net	net ;
  char	**argv ;
  int	argc ;
{
  char	*ptr, *option ;
  int	line = layoutInputLine ;

  widthSet = heightSet = FALSE ;
  for (--argc, ++argv ; argc > 0 ; --argc, ++argv) {
    option = *argv ;
    --argc, ++argv ;

    if (argc == 0) {
      IErrorAbort("Line %d: missing argument for \"%s\"", line, option) ;

    } else if (strcmp(option, "block-height") == 0) {
      heightSet = TRUE ;
      net->majorHeight = strtol(*argv, &ptr, 0) ;
      if (*ptr != '\0') 
	IErrorAbort("Line %d: bad block height \"%s\"", line, *argv) ;

    } else if (strcmp(option, "block-width") == 0) {
      widthSet = TRUE ;
      net->majorWidth = strtol(*argv, &ptr, 0) ;
      if (*ptr != '\0') 
	IErrorAbort("Line %d: bad block width \"%s\"", line, *argv) ;

    } else if (strcmp(option, "margin") == 0) {
      net->majorMargin = strtol(*argv, &ptr, 0) ;
      if (*ptr != '\0') 
	IErrorAbort("Line %d: bad margin size \"%s\"", line, *argv) ;

    } else if (strcmp(option, "per-row") == 0) {
      perRow = strtol(*argv, &ptr, 0) ;
      if (*ptr != '\0') 
	IErrorAbort("Line %d: bad units per row \"%s\"", line, *argv) ;

    } else {
      IErrorAbort("Line %d: bad option \"%s\"", line, option) ;
    }
  }

  netForAllUnits(net, ALL, setDefaultLayout, NULL) ;
  resetLastLaid() ;
  resetCurrentRow() ;

  return 1 ;
}
/**********************************************************************/
static void	setDefaultLayout(unit, data)
  Unit		unit ;
  void		*data ;
{
  unit->weightRow    = -1 ;
  unit->weightColumn = -1 ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		setMajorLine
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	setMajorLine(net, argv, argc) 
  Net	net ;
  char	**argv ;
  int	argc ;
{
  int		unitIdx ;
  int		currentColumn ;
  Group		group ;
  Section	*section ;

  section = buildSections(argv, argc) ;
  if (section == NULL)
    return 0 ;

  section = fillSections(net, section, perRow) ;
  if (section == NULL) 
    return 0 ;

  currentColumn = 0 ;
  while (section->type != End) {
    switch (section->type) {
    case All:
    case Sect:
    case Next:
      group = groupFromName(net, section->name) ;
      for (unitIdx = section->from ; 
	   unitIdx < section->from + section->size ; ++unitIdx ) {
	group->unit[unitIdx]->weightRow    = getCurrentRow() ;
	group->unit[unitIdx]->weightColumn = currentColumn ;
	++currentColumn ;
      }
      break ;

    case Blank:
    case Fill:
      currentColumn += section->size ;
      break ;

    default:
      break ;
    }
    ++section ;
  }

  return 1 ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		touchUpMajorDimensions
 *	Description:	sets the major width and height if they aren't 
 *			specified.
 *	Parameters:	NONE
 *	Return Value:
 *	  int	touchUpMajorDimensions  - 1
 *********************************************************************/
static void	findMaxWidth(unit, data)
  Unit		unit ;
  void		*data ;
{
  Net	net	    = (Net)data ;
  int	numIncoming = unit->numIncoming ;
  Link	*incoming   = unit->incomingLink ;
  int	idx ;

  int	newMax = 2*net->minorMargin ;
  net->majorWidth = MAX(net->majorWidth, newMax) ;

  for (idx = 0 ; idx < numIncoming ; ++idx) {
    if (incoming[idx]->weightColumn[0] >= 0) {
      newMax = net->minorMargin
	+ (incoming[idx]->weightColumn[0]+1)
	  *(net->minorWidth+net->minorMargin);
      net->majorWidth = MAX(net->majorWidth, newMax) ;
    }
    if (incoming[idx]->weightColumn[1] >= 0) {
      newMax = net->minorMargin
	+ (incoming[idx]->weightColumn[1]+1)
	  *(net->minorWidth + net->minorMargin);
      net->majorWidth = MAX(net->majorWidth, newMax) ;
    }
  }
}
/**********************************************************************/
static void	findMaxHeight(unit, data)
  Unit		unit ;
  void		*data ;
{
  Net	net	    = (Net)data ;
  int	numIncoming = unit->numIncoming ;
  Link	*incoming   = unit->incomingLink ;
  int	idx ;

  int	newMax = 2*net->minorMargin ;
  net->majorHeight = MAX(net->majorHeight, newMax) ;

  for (idx = 0 ; idx < numIncoming ; ++idx) {
    if (incoming[idx]->weightRow[0] >= 0) {
      newMax = net->minorMargin
	+ (incoming[idx]->weightRow[0]+1)*(net->minorHeight+net->minorMargin) ;
      net->majorHeight = MAX(net->majorHeight, newMax) ;
    }
    if (incoming[idx]->weightRow[1] >= 0) {
      newMax = net->minorMargin
	+ (incoming[idx]->weightRow[1]+1)*(net->minorHeight+net->minorMargin) ;
      net->majorHeight = MAX(net->majorHeight, newMax) ;
    }
  }
}
/**********************************************************************/
int	touchUpMajorDimensions (net, forceWidth, forceHeight) 
  Net	net ;
  int	forceWidth ;
  int	forceHeight ;
{
  if (forceWidth == TRUE || widthSet == FALSE) {
    net->majorWidth = 0 ;
    netForAllUnits(net, ALL, findMaxWidth, net) ;
  }

  if (forceHeight == TRUE || heightSet == FALSE) {
    net->majorHeight = 0 ;
    netForAllUnits(net, ALL, findMaxHeight, net) ;
  }

  widthSet = heightSet = TRUE ;

  return 1 ;
}
/********************************************************************/
