
/**********************************************************************
 * $Id: activity.c,v 1.4 92/11/30 11:30:05 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>

#include <xerion/useful.h>
#include <xerion/simulator.h>
#include "layoutUtils.h"
#include "activity.h"

static int	perRow ;
static void	setDefaultLayout ARGS((Unit  unit, void  *data)) ;

/***********************************************************************
 *	Name:		setActivityOptions
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	setActivityOptions (net, argv, argc)
  Net	net ;
  char	**argv ;
  int	argc ;
{
  char	*ptr ;
  int	idx ;

  for (idx = 1 ; idx < argc ; ++idx) {
    if (strcmp(argv[idx], "cell-size") == 0) {
      net->activityHeight = strtol(argv[++idx], &ptr, 0) ;
      net->activityWidth  = net->activityHeight ;
      if (*ptr != '\0') 
	break ;
    } else if (strcmp(argv[idx], "margin") == 0) {
      net->activityMargin = strtol(argv[++idx], &ptr, 0) ;
      if (*ptr != '\0') 
	break ;
    } else if (strcmp(argv[idx], "per-row") == 0) {
      perRow = strtol(argv[++idx], &ptr, 0) ;
      if (*ptr != '\0') 
	break ;
    } else {
      break ;
    }
  }

  if (idx != argc) {
    char	message[128] ;
    sprintf(message,  "Bad option \"%s\"\n", argv[idx]) ;
    IErrorAbort(message) ;
  }

  netForAllUnits(net, ALL, setDefaultLayout, NULL) ;
  resetLastLaid() ;
  resetCurrentRow() ;

  return 1 ;
}
/**********************************************************************/
static void	setDefaultLayout(unit, data)
  Unit		unit ;
  void		*data ;
{
  unit->activityRow    = -1 ;
  unit->activityColumn = -1 ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		setActivityLine
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	setActivityLine(net, argv, argc) 
  Net	net ;
  char	**argv ;
  int	argc ;
{
  int		unitIdx ;
  int		currentColumn ;
  Group		group ;
  Section	*section ;

  section = buildSections(argv, argc) ;
  if (section == NULL)
    return 0 ;

  section = fillSections(net, section, perRow) ;
  if (section == NULL) 
    return 0 ;

  currentColumn = 0 ;
  while (section->type != End) {
    switch (section->type) {
    case All:
    case Sect:
    case Next:
      group = groupFromName(net, section->name) ;
      for (unitIdx = section->from ; 
	   unitIdx < section->from + section->size ; 
	   ++unitIdx ) {
	group->unit[unitIdx]->activityRow    = getCurrentRow() ;
	group->unit[unitIdx]->activityColumn = currentColumn ;
	++currentColumn ;
      }
      break ;

    case Blank:
    case Fill:
      currentColumn += section->size ;
      break ;
    default:
      break ;
    }
    ++section ;
  }

  return 1 ;
}
/**********************************************************************/
