/*
 * $Id: warn.c,v 1.3 92/11/30 11:40:25 drew Exp $
 * 
 */

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>
#include <varargs.h>
#include "warn.h"

/*
 * contains panic, warn, and logstr
 */
  
/* VARARGS0 */
void panic(va_alist)
va_dcl
{
  va_list ap;
  char *fmt,*name;
  va_start(ap);
  name = va_arg(ap,char*);
  fmt = va_arg(ap,char*);
  if (name!=NULL) fprintf(stderr,"PANIC: %s",name);
  if (fmt!=NULL) {
    fputs(": ",stderr);
    vfprintf(stderr,fmt,ap);
  }
  fprintf(stderr,"\n");
  va_end(ap);
  if (getuid()==222)	/* dump core for tap, be kinder for others */
    abort();
  else
    exit(1);
}

/* VARARGS0 */
void warn(va_alist)
va_dcl
{
  va_list ap;
  char *fmt,*name;
  va_start(ap);
  name = va_arg(ap,char*);
  fmt = va_arg(ap,char*);
  if (name!=NULL) fprintf(stderr,"Warning: %s",name);
  if (fmt!=NULL) {
    if (name!=NULL) fputs(": ",stderr);
    vfprintf(stderr,fmt,ap);
  }
  fprintf(stderr,"\n");
  va_end(ap);
}

#if 0
/* VARARGS0 */
void author_warn(va_alist)
va_dcl
{
  va_list ap;
  char *fmt,*name;
  if (getuid() != 222) return;
  va_start(ap);
  name = va_arg(ap,char*);
  fmt = va_arg(ap,char*);
  if (name!=NULL) fprintf(stderr,"Warning: %s: ",name);
  if (fmt!=NULL)
    vfprintf(stderr,fmt,ap);
  fprintf(stderr,"\n");
  va_end(ap);
}

/* VARARGS0 */
void logstr(va_alist)
va_dcl
{
  va_list ap;
  char *fmt,*name;
  va_start(ap);
  name = va_arg(ap,char*);
  fmt = va_arg(ap,char*);
  if (name!=NULL) fprintf(stderr,"Log: %s: ",name);
  if (fmt!=NULL)
    vfprintf(stderr,fmt,ap);
  fprintf(stderr,"\n");
  va_end(ap);
}
#endif
