
/**********************************************************************
 * $Id: utils.h,v 1.3 92/11/30 11:40:19 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __xerion_itf_utils_h
#define __xerion_itf_utils_h

#ifndef TRUE
#define TRUE		1
#endif
#ifndef FALSE
#define FALSE		0
#endif
#define UNDEFINED	-1
extern char *true_string;
extern char *false_string;
extern char *undefined_string;
extern char *bad_boolean_string;

extern int	IsAsciiString ARGS(( char *p )) ;
  /* returns 1 if all characters in p are ascii, 0 otherwise */

extern char	*BooleanString ARGS(( int b )) ;
  /* returns a static string for b */

extern char	*pchar ARGS(( int c )) ;
  /* returns a string showing the character c */

extern int 	substr ARGS((char *sub, char *str));
  /* return 1 is sub is a substring of str */

extern void	strncpy_null ARGS(( char *dest, char *src, int n )) ;
  /* copies n - 1 chars from src to dest and null terminates it */

extern char     *stralloc ARGS((char *str));
  /* makes a copy of the string and returns a pointer to it */

extern int 	strprefix ARGS((char *a, char *b));
  /* returns 1 if a is a non-null prefix of b */

extern char	*strcpyend ARGS(( char *dest, char *src )) ;
  /* copies src to dest and returns a pointer to the end of the string */

extern char *strcatend ARGS((char *dest, char *end));
  /* concats src to dest and returns a pointer to the end of the string */

extern int	IIsLegalVarName ARGS(( char *name )) ;
  /* returns 1 if name is a legal variable name, 0 otherwise */

extern int	IIsInteger ARGS(( char *str )) ;
  /* returns 1 if str is an ascii representation of a (signed) integer */

extern int	IIsNumber() ;
  /* returns 1 if str is an ascii representation of a real number */

#endif /* __xerion_itf_utils_h */
