
/**********************************************************************
 * $Id: utils.c,v 1.3 93/02/18 14:41:47 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include "itf.h"

char *true_string = "true";
char *false_string = "false";
char *undefined_string = "undefined";
char *bad_boolean_string = "bad_boolean";

int IsAsciiString(p)
char *p;
{
  if (*p==NULL)
    return 0;
  for (; *p; p++)
    if (!isascii(*p))
      return 0;
  return 1;
}

char *BooleanString(b)
int b;
{
  switch ((int)b) {
  case 0: return false_string;
  case -1: return undefined_string;
  case 1: return true_string;
  default: return bad_boolean_string;
  }
}

char *pchar(c)
int c;
{
  static char buf[10];
  if (isprint(c)) {
    buf[0] = buf[2] = '\'';
    buf[1] = c;
  } else if (c=='\0')
    strcpy(buf,"(nullchar)");
  else
    sprintf(buf,"(char:%d)",c);
  return buf;
}

/***
 * stralloc - makes a copy of the string and returns a pointer to it
 */
char *stralloc(str)
char *str;
{
  char *p = NULL;
  if (str!=NULL) p = malloc((unsigned) strlen(str)+1);
  if (p!=NULL) strcpy(p, str);
  return p;
}

/***
 * returns 1 if a is a non-null prefix of b
 */
int strprefix(a, b)
char *a;
char *b;
{
  int i=0;
  if (a==NULL || b==NULL) return 0;
  if (*a=='-' && *b=='-') {a++;b++;}
  if (*a=='+' && *b=='+') {a++;b++;}
  if (*a != *b) return 0;
  while (*a!=NULL && *b!=NULL && *a == *b) {i++;a++;b++;}
  if (*a==NULL) return i;
  else return 0;
}

/***
 * return 1 is sub is a substring of str
 */
int substr(sub, str)
char *sub, *str;
{
  char *p; /* current position in sub */
  char *t;
  if (sub==NULL || str==NULL) return 0;
  while (*str) {
    p = sub;
    t = str;
    while (*p && *t && *p==*t) {
      p++;
      t++;
    }
    if (!*p) return 1;
    str++;
  }
  return 0;
}

void strncpy_null(dest,src,n)
char *dest;
char *src;
int n;
{
  strncpy(dest,src,n-1);
  dest[n-1] = '\0';
}

/***
 * copies str to buf and returns a pointer to the end of the string
 */
char *strcpyend(buf,str)
char *buf;
char *str;
{
  while (*str) *(buf++) = *(str++);
  *buf = 0;
  return buf;
}

/***
 * concats str to buf and returns a pointer to the end of the string
 */
char *strcatend(buf,str)
char *buf;
char *str;
{
  while (*buf) buf++;
  while (*str) *(buf++) = *(str++);
  *buf = 0;
  return buf;
}

int IIsPositional(name)
char *name;
{
  if (!name || !*name) return 0;
  if (!(IIsInteger(name)
	|| ((*name == '#' || *name == '*') && *(name + 1) == '\0')))
    return 0;
  return 1;
}

int IIsLegalVarName(name)
char *name;
{
  if (!name || !*name) return 0;
  if (IIsPositional(name)) return 1;

  if (!(   *name >= 'a' && *name <= 'z'
	|| *name >= 'A' && *name <= 'Z'
	|| *name=='$' || *name=='@')) return 0;
  while (*name)
    if (   *name >= 'a' && *name <= 'z'
	|| *name >= 'A' && *name <= 'Z'
	|| *name >= '0' && *name <= '9'
	|| *name=='_' || *name=='-' || *name=='$' || *name=='@') name++;
    else
      return 0;
  return 1;
}

int IsLegalVarName(name)
char *name;
{
  return IIsLegalVarName(name);
}

int IIsInteger(str)
char *str;
{
  char *end;
  if (!str || !*str) return 0;
  (void) strtol(str,&end,0);
  if (end==str || *end!='\0') return 0;
  else return 1;
  /*
  if (!str || *str<'0' && *str>'9') return 0;
  for(;*str;str++) if (*str<'0' || *str>'9') return 0;
  return 1;
  */
}

/***
 * IIsNumber(str)
 * Recognizes strings of the form [-/+]n*[.n*][e/E[-/+]n*]}
 */
int IIsNumber(str)
char *str;
{
  char *end;
  if (!str || !*str) return 0;
  (void) strtod(str, &end);
  if (end==str || *end!='\0')
    return 0;
  else return 1;
#ifdef OBSELETE
  if (!str || !*str) return 0;
  /* can't start with 'e' or 'E' */
  if (*str=='e' || *str=='E') return 0;
  if (*str && (*str=='-' || *str=='+')) str++;
  while (*str && *str>='0' && *str<='9') str++;
  if (*str && *str=='.') {
    str++;
    while (*str && *str>='0' && *str<='9') str++;
  }
  if (*str && (*str=='e' || *str=='E')) {
    str++;
    if (*str && (*str=='-' || *str=='+')) str++;
    while (*str && *str>='0' && *str<='9') str++;
  }
  /***
   * should have reached the end of the string
   */
  if (!*str) return 1;
  else return 0;
#endif				/* OBSELETE */
}

