
/**********************************************************************
 * $Id: trace.h,v 1.2 92/11/30 11:40:17 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef _trace_h_
#define _trace_h_

typedef struct TRACE_RECORD TRACE_RECORD  ;
struct TRACE_RECORD {
  int	active;
  char	*command;
  int	freq;
  int	count;
  int	stream_not_open;	/* 1 if didn't exec last time due to this */
  int	mark;
} ;

typedef struct TRACE TRACE ;
struct TRACE {
  TRACE_RECORD	*trace;
  int		n_traces;
  int		active;
  TRACE 	*next;
  char 		*name;
} ;

enum SHOW_MODE {SUMMARY, BRIEF, VERBOSE, STATUS};

extern struct TRACE *first_trace;
extern struct TRACE *last_trace;

extern int      IShowTrace       ARGS((TRACE *, enum SHOW_MODE, char **tokv));
extern void     ChangeTraceFlags ARGS((TRACE *, int active, int freq, 
				       int count, int delete, char *tokv[]));
extern int      commandTrace     ARGS((int tokc, char *tokv[]));
extern int      IDoTrace         ARGS((TRACE *));

#endif				/* _trace_h_ */
