
/**********************************************************************
 * $Id: stream.h,v 1.2 92/11/30 11:40:15 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

typedef enum STREAM_STATUS {
  STREAM_STATUS_XX,
  STREAM_ERROR,
  STREAM_OPEN,
  STREAM_CLOSED
} STREAM_STATUS;

typedef enum STREAM_TYPE {
  STREAM_TYPE_XX,
  STREAM_FILE,
  STREAM_APPEND,
  STREAM_REMOTE_FILE,
  STREAM_REMOTE_APPEND,
  STREAM_SOCKET,
  STREAM_PORT,
  STREAM_COMMAND
} STREAM_TYPE;

typedef struct STREAM {
  FILE	*file;
  char	*desc;
  char	*name;
  char	*machine;	/* used for the remote file stuff */
  enum STREAM_TYPE	type;
  enum STREAM_STATUS	status;
  int	port;		/* the port we should try to open */
  int	real_port;	/* the actual port we have open */
  int	search;		/* Boolean: search for a port which will accept */
  int	permanent;	/* =1 if this should stay open across commands */
  struct STREAM *next;	/* keep streams in a linked list */
  char *mode;
} STREAM;

extern STREAM *current_instream,*current_outstream;
extern STREAM *stdin_stream,*stdout_stream;  /* permanent std streams */
extern STREAM *command_stdin,*command_stdout; /* command std streams */

extern int	IAddStream	ARGS((STREAM *));
extern int	ICloseStream	ARGS((char *name, int ignore_closed, 
				      int ignore_error));
extern int	IDoRedirection  ARGS((int *tokc, char *tokv[], 
				      STREAM **old_instream,
				      STREAM **old_outstream));
extern void	IEndRedirection ARGS(());
extern STREAM  *IGetStream 	ARGS((char *name));
extern int	IInitStream	ARGS(());
extern FILE    *IOpenNamedSocket	 ARGS((char *name, char *mode));
extern FILE    *IOpenNumberedSocket	 ARGS((int port, char *host, char *mode));
extern STREAM  *IOpenPermanentStream	 ARGS((char *name));
extern int	IRedirectToFile	ARGS((STREAM *stream, char *name, 
				      int append, int noclobber, char *mode));
extern int	IRedirectToRemoteFile ARGS((STREAM *stream, char *name, 
					    char *machine, int append, 
					    int noclobber, char *mode));
extern int	IRedirectToStream ARGS((char *name)) ;
extern STREAM  *IReopenStream	  ARGS((char *name));
extern int	IShowStream 	  ARGS((STREAM *, FILE *, int name)) ;
