
/**********************************************************************
 * $Id: range.h,v 1.2 92/11/30 11:40:09 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef _RANGE_
#define _RANGE_

typedef struct AREA_FORMAT { /* BIND */
  int rows;
  int cols;
  char code;
  short join;		/* Boolean: true=join up with previous? */
  short lowzero;	/* Boolean: true=rows ordered from bottom to top */
} AREA_FORMAT;

struct RANGE {
  int lo;
  int hi;
  int depth;
  int nothing;	/* if =1, nothing is in this range */
};

extern int      AreaToRange      ARGS((int n, struct RANGE *, 
				       struct AREA_FORMAT *));
extern int      CompareWithRangeString   ARGS((int n, char *range_string, 
					       int *range_size));
extern int      InRange		 ARGS((int n, struct RANGE *, 
				       struct AREA_FORMAT *));
extern int      InRangeString    ARGS((int n, char *range_string));
extern int      IsDefaultRange   ARGS((struct RANGE *, struct AREA_FORMAT *));
extern int      ParseAreaFormat  ARGS((char *format_str, 
				       struct AREA_FORMAT *));
extern int      ParseRange       ARGS((char *tok, struct RANGE *, 
				       struct AREA_FORMAT *));
extern char    *PrintRangeString ARGS((struct RANGE *));
extern void     RangeDimensions  ARGS((int max, struct RANGE *, 
				       struct AREA_FORMAT *, 
				       int *rows, int *cols));
extern void     RangeForControl  ARGS((int max, struct RANGE *, 
				       struct AREA_FORMAT *, 
				       int *first_row, int *top_row, 
				       int *row_inc, int *row_len));
extern int      RangePosition    ARGS((int n, struct RANGE *, 
				       struct AREA_FORMAT *, 
				       int *row, int *col));
extern int      RangeSize        ARGS((int max, struct RANGE *, 
				       struct AREA_FORMAT *));
extern int      RangeToArea      ARGS((int n, struct RANGE *, 
				       struct AREA_FORMAT *));
extern void     SetDefaultRange  ARGS((struct RANGE *, struct AREA_FORMAT *));


#endif				/* _RANGE_ */
