
/**********************************************************************
 * $Id: option.h,v 1.2 92/11/30 11:40:07 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef _OPTION_
#define _OPTION_

extern char *plus_minus_options;

/***
 * There are two different types of option
 *
 *           	Style 1		Style 2
 * presence	-read		-read
 * signed	-read +read	-read -noread		
 * usage linead	+/-read		-[no]read
 */

#define OPTSIGN 0x1
#define OPTPRES 0x2
#define OPTREALARG 0x4
#define OPTINTARG 0x8
#define OPTSTRARG 0x10
#define SOMEOPT (OPTSIGN|OPTPRES|OPTREALARG|OPTINTARG|OPTSTRARG)
#define OPTLAST 0x20

typedef struct OPTION {
  int	type;
  char	*name;
  int	min_prefix_len;
} OPTION;

extern int      IsOption         ARGS((char *token));
extern int      OptionMatch      ARGS((char *token, char *option, 
				       struct OPTION options[], int *sign));
extern int      PrefixMatch      ARGS((char *prefix, struct OPTION options[]));
extern int      OptionSign       ARGS((char *token, char *option, 
				       struct OPTION options[]));
#endif 			/* _OPTION_ */
