
/**********************************************************************
 * $Id: option.c,v 1.2 92/11/30 11:40:05 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include "itf.h"
#include "option.h"

int OptionSign(token,option,options)
char *token;
char *option;
struct OPTION options[];
{
  int sign;
  if (token==NULL || *token=='\0')
    IErrorAbort("OptionSign: null token");
  if (OptionMatch(token,option,options,&sign))
    return sign;
  else
    IErrorAbort("OptionSign: token \"%s\" doesn't match option \"%s\"",
		token,option);
  /*NOTREACHED*/
}

/***
 * returns 1 if the given prefix matches one of the option names
 */
int PrefixMatch(prefix,options)
char *prefix;
struct OPTION options[];
{
  int i,l;
  l = strlen(prefix);
  for (i=0;!(options[i].type&OPTLAST);i++)
    if (!strncmp(prefix,options[i].name,l)) return 1;
  return 0;
}

int OptionMatch(token,option,options,sign)
char *token,*option;
struct OPTION options[];
int *sign;
{
  int this_option,j,k,sign1=0;
  char *bad_prefix = NULL;
  /***
   * find the option in the list of options
   */
  if (token==NULL || *token==NULL || !IsOption(token))
    return 0;
  for (this_option=0;!(options[this_option].type&OPTLAST);this_option++)
    if (!strcmp(option,options[this_option].name)) break;
  if (options[this_option].type&OPTLAST)
    IErrorAbort("looking for option not in list?: \"%s\"",option);
  /***
   * check that the min prefix length is stored
   */
  if (options[this_option].min_prefix_len<1) {
    int len = strlen(options[this_option].name);
    for (j=0;!(options[j].type&OPTLAST);j++) {
      if (j!=this_option) {
	for (k=0;
	        options[this_option].name[k]==options[j].name[k]
	     && options[this_option].name[k]!=0;
	     k++)
	  if (options[this_option].name[k]==0)
	    IErrorAbort("two identical options: \"%s\" - %d & %d",option,j,k);
	if (k<len) k++;
	if (k>options[this_option].min_prefix_len)
	  options[this_option].min_prefix_len = k;
      }
    }
  }
  /***
   * strip the "-" "+" or "-no"
   */
  if (true(plus_minus_options)) {
    if (*token=='-' && (options[this_option].type&OPTSIGN)) {
      token++;
      sign1 = 0;
    } else if (*token=='+' && (options[this_option].type&SOMEOPT)) {
      token++;
      sign1 = 1;
    } else {
      bad_prefix = token;
    }
  } else {
    if (!strncmp(token,"-no",3) && (options[this_option].type&OPTSIGN)
	&& !PrefixMatch(token+1,options)) {
      token += 3;
      sign1 = 0;
    } else if (token[0]=='-' && (options[this_option].type&SOMEOPT)) {
      token++;
      sign1 = 1;
    } else {
      bad_prefix = token;
    }
  }
  /***
   * check the match
   */
  k = strlen(token);
  if (k<1 || strncmp(token,options[this_option].name,k)) return 0;
  if (bad_prefix)
    IErrorAbort("bad prefix '%c' on option \"%s\"",*bad_prefix,bad_prefix);
  if (k<options[this_option].min_prefix_len)
    IErrorAbort("ambiguous abbreviated option: \"%s\"",token);
  if (sign) *sign = sign1;
  return 1;
}

int IsOption(token)
char *token;
{
  if (token!=NULL && (*token=='-' || (true(plus_minus_options)&&*token=='+')))
    return 1;
  else
    return 0;
}
