
/**********************************************************************
 * $Id: mem.h,v 1.2 92/11/30 11:40:04 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef MEM_H
#define MEM_H

/***
 * pointers to record allocs during command
 * that should be freed at end of command
 */
typedef struct POINTER_LIST {
  char *p;
  struct POINTER_LIST *next;
} POINTER_LIST;

typedef struct TEMP_ALLOC {
  struct POINTER_LIST *head;
  struct POINTER_LIST *tail;
  struct TEMP_ALLOC *prev;	/* there can be a stack of these things */
} TEMP_ALLOC;


extern char *_ITempCalloc	ARGS((unsigned int size, unsigned int n)) ;
extern char *_ITempRealloc	ARGS((char *old_p, unsigned int n, 
				      unsigned int size));
extern char **_ITempMatrix	ARGS((unsigned int size, unsigned int nrl, 
				      unsigned int nrh, unsigned int ncl, 
				      unsigned int nch));
extern char *_ITempVector	ARGS((unsigned int size, unsigned int nl, 
				      unsigned int nh));
extern char **_IMatrix		ARGS((unsigned int size, unsigned int nrl, 
				      unsigned int nrh, unsigned int ncl, 
				      unsigned int nch));
extern char *_IVector		ARGS((unsigned int size, unsigned int nl, 
				      unsigned int nh));
extern void _IStealTempAlloc 	ARGS((char *));

extern void _IFreeVector     	ARGS((char *v, unsigned int size, 
				      unsigned int nl, unsigned int nh));
extern void _IFreeMatrix	ARGS((char **m, unsigned int size, 
				      unsigned int nrl, unsigned int nrh, 
				      unsigned int ncl, unsigned int nch));

extern void IFreeTempAllocs	ARGS((struct TEMP_ALLOC *rec));
extern void IBeginTempAlloc	ARGS((struct TEMP_ALLOC *rec));

extern char	*callocOrAbort	ARGS((unsigned nelem, unsigned elsize));
extern char	*reallocOrAbort	ARGS((char *old, unsigned size));

extern struct TEMP_ALLOC *temp_alloc;


#ifndef ALLOC_MACROS
#define ALLOC_MACROS

#define Malloc(TYPE, SIZE) \
  ((TYPE*)malloc((unsigned) (SIZE)))

#define Realloc(TYPE, OLD, NUMBER) \
  ((TYPE*)realloc((char*)(OLD), sizeof(TYPE)*(unsigned) (NUMBER)))

#define ReallocOrAbort(TYPE, OLD, NUMBER) \
  ((TYPE*)reallocOrAbort((char*)(OLD), sizeof(TYPE)*(unsigned) (NUMBER)))

#define Calloc(TYPE, N) \
  ((TYPE*)calloc((unsigned) (N), (unsigned)sizeof(TYPE)))

#define CallocOrAbort(TYPE, N) \
  ((TYPE*)callocOrAbort((unsigned) (N), (unsigned)sizeof(TYPE)))

#endif				/* ALLOC_MACROS */

#define ITempCalloc(TYPE, N) \
  ((TYPE*)_ITempCalloc((unsigned) (N), (unsigned)sizeof(TYPE)))

#define IStealTempAlloc(OLD) \
  _IStealTempAlloc((char*)(OLD))

#define ITempRealloc(TYPE, OLD, N) \
  ((TYPE*)_ITempRealloc((char*)(OLD), (unsigned) (N), (unsigned)sizeof(TYPE)))

#define ITempMatrix(TYPE, NRL, NRH, NCL, NCH) \
  ((TYPE**)_ITempMatrix((unsigned)sizeof(TYPE), (unsigned)(NRL), (unsigned)(NRH), (unsigned)(NCL), (unsigned)(NCH)))

#define ITempVector(TYPE, NL, NH) \
  ((TYPE*)_ITempVector((unsigned)sizeof(TYPE), (unsigned)(NL), (unsigned)(NH)))

#define IMatrix(TYPE, NRL, NRH, NCL, NCH) \
  ((TYPE**)_IMatrix((unsigned)sizeof(TYPE), (unsigned)(NRL), (unsigned)(NRH), (unsigned)(NCL), (unsigned)(NCH)))

#define IFreeMatrix(M, TYPE, NRL, NRH, NCL, NCH) \
  ((TYPE**)_IFreeMatrix((char**)(M), (unsigned)sizeof(TYPE), (unsigned)(NRL), (unsigned)(NRH), (unsigned)(NCL), (unsigned)(NCH)))

#define IVector(TYPE, NL, NH) \
  ((TYPE*)_IVector((unsigned)sizeof(TYPE), (unsigned)(NL), (unsigned)(NH)))

#define IFreeVector(V, TYPE, NL, NH) \
  ((TYPE*)_IFreeVector((char*)(V), (unsigned)sizeof(TYPE), (unsigned)(NL), (unsigned)(NH)))

#endif				/* MEM_H */
