
/**********************************************************************
 * $Id: mem.c,v 1.3 92/11/30 11:40:03 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include "itf.h"

/***
 * The matrix routines are plagarized/inspired from nrutil.c "Numerical
 * recipies in C"
 */

struct TEMP_ALLOC *temp_alloc = NULL;

char *callocOrAbort(nelem, elsize)
unsigned nelem, elsize;
{
  char *p;
  p = calloc(nelem, elsize);
  if (p==NULL && nelem*elsize>0)
    IErrorAbort("out of memory");
  return p;
}

char *reallocOrAbort(old, size)
char *old;
unsigned size;
{
  char *p;
  p = realloc(old, size);
  if (p==NULL && size>0)
    IErrorAbort("out of memory");
  return p;
}

char *_ITempVector(size, nl, nh)
unsigned int size, nl, nh;
{
  char *v;
  v = (char *)_ITempCalloc(nh-nl+1, size);
  if (!v && nh>=nl)
    IErrorAbort("_ITempVector: out of memory");
  v -= nl;
  return v;
}

char **_ITempMatrix(size, nrl, nrh, ncl, nch)
unsigned int size, nrl, nrh, ncl, nch;
{
  int i;
  char **m;
  
  m=(char **)_ITempCalloc((unsigned) (nrh-nrl+1), sizeof(char*));
  if (!m && nrh>=nrl && nch>=ncl)
    IErrorAbort("_ITempMatrix: out of memory 1");
  m -= nrl;
  
  for(i=nrl; i<=nrh; i++) {
    m[i]=_ITempCalloc((unsigned) (nch-ncl+1), size);
    if (!m[i]) IErrorAbort("_ITempMatrix: out of memory 2");
    m[i] -= ncl*size;
  }
  return m;
}

char *_IVector(size, nl, nh)
unsigned int size, nl, nh;
{
  char *v;
  v = (char *)calloc(nh-nl+1, size);
  if (!v && nh>=nl)
    IErrorAbort("_IVector: out of memory");
  v -= nl;
  return v;
}

void _IFreeVector(v, size, nl, nh)
char *v;
unsigned int size, nl, nh;
{
  free(v+(nl*size));
}

char **_IMatrix(size, nrl, nrh, ncl, nch)
unsigned int size, nrl, nrh, ncl, nch;
{
  int i;
  char **m;
  
  m=(char **)calloc((unsigned) (nrh-nrl+1), sizeof(char*));
  if (!m && nrh>=nrl)
    IErrorAbort("_IMatrix: out of memory 1");
  m -= nrl;
  
  for(i=nrl; i<=nrh; i++) {
    m[i]=calloc((unsigned) (nch-ncl+1), size);
    if (!m[i] && nch>=ncl)
      IErrorAbort("_IMatrix: out of memory 2");
    m[i] -= ncl*size;
  }
  return m;
}

void _IFreeMatrix(m, size, nrl, nrh, ncl, nch)
char **m;
unsigned int size, nrl, nrh, ncl, nch;
{
  int i;
  
  for(i=nrh; i>=nrl; i--)
    free(m[i]+(ncl*size));
  free((char*) (m+nrl));
}

char *_ITempCalloc(n, size)
unsigned int n, size;
{
  char *p;
  struct POINTER_LIST *l;
  /* assert(temp_alloc!=NULL); */
  l = Calloc(struct POINTER_LIST, 1);
  if (l==NULL)
    IErrorAbort("_ITempCalloc: out of memory for pointer list! (%d bytes)",
		sizeof (struct POINTER_LIST));
  p = calloc(n, size);
  if (p==NULL && size*n>0)
    IErrorAbort("_ITempCalloc: out of memory tried to get %d*%d bytes", n, size);
  l->next = NULL;
  l->p = p;
  if (temp_alloc->head==NULL)
    temp_alloc->head = l;
  else
    temp_alloc->tail->next = l;
  temp_alloc->tail = l;
  return p;
}

/***
 * Realloc is nasty - if we get a different address for the larger
 * block, we have to find the original pointer on the list and change it.
 */
char *_ITempRealloc(old_p, n, size)
char *old_p;
unsigned int n, size;
{
  char *new_p;
  /* assert(temp_alloc!=NULL); */
  new_p = realloc(old_p, n * size);
  if (new_p==NULL && n*size>0)
    IErrorAbort("_ITempRealloc: out of memory tried to get %d*%d bytes",
		n, size);
  if (new_p != old_p) {
    /* have to find it on the list */
    struct TEMP_ALLOC *ta = temp_alloc;
    struct POINTER_LIST *pl = ta->head; ;
    while (pl!=NULL && pl->p!=old_p) {
      pl = pl->next;
      if (pl==NULL) {
	ta = ta->prev;
	pl = ta->head;
      }
    }
    if (pl==NULL)
      warn("_ITempRealloc: cannot find mem block 0x%x on list", old_p);
    else
      pl->p = new_p;
  }
  return new_p;
}

/***
 * IStealTempAlloc - steal a block from the temp list - make it
 * permanent.
 */
void _IStealTempAlloc(old_p)
char *old_p;
{
  struct TEMP_ALLOC *ta = temp_alloc;
  struct POINTER_LIST *pl = ta->head; ;
  while (pl!=NULL && pl->p!=old_p) {
    pl = pl->next;
    if (pl==NULL) {
      ta = ta->prev;
      pl = ta->head;
    }
  }
  if (pl==NULL)
    warn("_IStealTempAlloc: cannot find mem block 0x%x on list", old_p);
  else
    pl->p = NULL;
}

void IFreeTempAllocs(rec)
struct TEMP_ALLOC *rec;
{
  struct POINTER_LIST *l, *n;
  for (l=rec->head; l!=NULL; l=n) {
    n = l->next;
    if (l->p!=NULL)
      free(l->p);
    free(l);
  }
  temp_alloc = rec->prev;	/* start using the one we had before */
}

void IBeginTempAlloc(rec)
struct TEMP_ALLOC *rec;
{
  rec->prev = temp_alloc;	/* remember the one we had before */
  rec->head = rec->tail = NULL;
  temp_alloc = rec;
}
