
/**********************************************************************
 * $Id: loop.h,v 1.7 93/03/29 14:15:48 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef __xerion__loop_h
#define __xerion__loop_h

/********************************************************************/
typedef struct _LoopCommand {
  unsigned int	mask ;
  String	line ;
} LoopCommand ;

typedef struct _Loop {
  Lex		lex ;
  LoopCommand	*command ;
  int		numCommands ;
  int		level ;
} Loop ;
/********************************************************************/

/********************************************************************/
extern Loop	*createLoop	ARGS(()) ;
extern void	destroyLoop	ARGS(()) ;
extern int	isLoop		ARGS((Loop *, String command)) ;
extern int	inLoop		ARGS((Loop *)) ;
extern int	addLoopCommand	ARGS((Loop *, char *command, int echo)) ;
extern int	_resetLoop	ARGS((Loop *, String file, int line)) ;
/********************************************************************/

#define resetLoop(loop)		_resetLoop(loop, __FILE__, __LINE__)

#endif /* __xerion_loop_h */
