
/**********************************************************************
 * $Id: lex.h,v 1.5 93/01/11 11:10:07 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef LEX_H
#define LEX_H

#define LEX_N_CHARS 128
#define LEX_CM 0x7F
#define LEX_TABLE (4 * LEX_N_CHARS + 3 * sizeof(long))


typedef struct LEX_STACK {
  char **arg_end;
  char *string_end;
  char *syntax;
} LEX_STACK;

typedef struct _LexRec {
  /*
   *  The pointer to storage for strings, and size
   */
  String	mem ;
  int		mem_size;
  String	*arg_start, *arg_end, string_end;
  int		arg_count;

  /* 
   *  Stack manipulation
   */
  LEX_STACK	*stack ;
  int		maxStackSize ;
  int		stackTop ;

  /*
   *  These arrays used to quickly look up the class of a character
   */
  String	lex_char_type;	/* one array is used to identify space, word */
				/* and operator characters */
  String	quote_chars;	/* these three arrays contain addresses */
  String	escape_chars;
  String	comm_chars;

  int		*op_type;
  int		*quote_break;
  int		*massage;
  HASH_TABLE	*lex_ht;
  int		prev_give_origins;

  /*
   *  The syntax
   */
  String	syntax ;

} LexRec, *Lex ;

extern Lex	defaultLex ;
extern Lex	createLexObj ARGS((int size, char *space, HASH_TABLE *ht)) ;
extern Lex	duplicateLexObj	ARGS((Lex original)) ;
extern void	destroyLexObj	ARGS((Lex this, int freeMemory)) ;
extern char	*LexObjMem	ARGS((Lex this, int size, char *space)) ;
extern char	*LexObjReinit	ARGS((Lex this, char *space)) ;
extern char	*LexObjMakeSyntax ARGS((Lex this,
					int o_type, int q_break, int massage,
					char *s_chars, char *w_chars,
					char *o_chars, char *q_chars,
					char *e_chars, char *c_chars,
					char *lookup));
extern String	LexObjSetSyntax ARGS((Lex this, String lookup)) ;
extern char 	**LexObjAnalyse	ARGS((Lex this, String line, int *tokc));
extern char	**LexObjAnalyseAdd  ARGS((Lex this, char *line, int *tokc));
extern char	**LexObjAnalysePush ARGS((Lex this, char *line, int *tokc));
extern void	LexObjAnalysePop    ARGS((Lex this));
extern char	*LexObjChangeArg    ARGS((Lex this, char **tokp, char *str)) ;
extern char 	*LexObjReconstruct ARGS((Lex this, 
					 String line, int maxLength,
					 int tokc, char **tokv));

extern char    *LexInit  ARGS((int size, char *space, HASH_TABLE *ht));
extern char    *LexReinit	 ARGS((char *space));
extern char    *LexMem	 ARGS((int size, char *space));
extern char    *LexSave		 ARGS((LEX_STACK *lex_stack)) ;
extern void    LexRestore	 ARGS((LEX_STACK *lex_stack, char *space)) ;
extern char    *LexMakeSyntax	 ARGS((int o_type, int q_break, char *s_chars,
				       char *w_chars, char *o_chars, 
				       char *q_chars, char *e_chars, 
				       char *c_chars, char *lookup));
extern char    *LexSetSyntax	 ARGS((char *lookup));
extern char   **LexAnalyse	 ARGS((char *syntax, char *line, int *tokc));
extern char   **LexAnalyseAdd	 ARGS((char *syntax, char *line, int *tokc));
extern char   **LexAnalysePush	 ARGS((char *syntax, char *line, int *tokc, 
				       LEX_STACK *lex_stack));
extern void	LexAnalysePop	 ARGS((LEX_STACK *lex_stack));


#define LEX_SP_BF_TOK	0x1
#define LEX_IS_OP	0x2
#define LexQuotedTok(s) ((s)[-2])
#define LexSpBefore(s) ((s)[-1] & LEX_SP_BF_TOK)
#define LexIsOperator(s)  ((s)[-1] & LEX_IS_OP)

#endif				/* LEX_H */
