
/**********************************************************************
 * $Id: itf.h,v 1.9 93/03/29 14:15:44 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef _ITF_
#define _ITF_

#ifndef _XtIntrinsic_h
#ifndef SIMULATOR_H
typedef char	Boolean;
#endif
#endif

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <varargs.h>
#include <xerion/config.h>
#include <xerion/assert.h>
#include <xerion/utils.h>
#include <xerion/hash-table.h>
#include <xerion/bind.h>
#include <xerion/warn.h>
#include <xerion/enum.h>
#include <xerion/trace.h>
#include <xerion/stream.h>
#include <xerion/mem.h>
#include <xerion/range.h>
#include <xerion/argf.h>
#include <xerion/stack.h>


#define COMMAND_ERROR	1
#define SYNTAX_ERROR	3
#define LEX_ERROR	2
#define UNKNOWN_COMMAND	4
#define UNKNOWN_ERROR	5
#define UNKNOWN_VAR	6
#define UNKNOWN_STRUCT	7
#define UNKNOWN_FIELD	8
#define NULL_VARNAME	9
#define ILLEGAL_VARNAME	10
#define ILLEGAL_OBJECT	11
#define OBJECT_SYNTAX	12
#define ARRAY_BOUNDS	13
#define NEED_ARRAY_INDEX	14
#define NEED_STRUCT_FIELD	15
#define NEED_FIELD_OR_INDEX	16
#define READONLY_VAR	17
#define BAD_VARTYPE	18
#define INTERNAL_NULL	19
#define OBJECT_EXCESS	20
#define NULL_POINTER	21
#define EMPTY_OBJECT	22
#define OUT_OF_MEMORY	23
#define INTERRUPT	24
#define ERROR_SIGNAL	25
#define VARNAME_IS_USED	26
#define REDIRECTION_ERROR 27
#define STREAM_NOT_OPEN 28
#define UNKNOWN_ALIAS	29
#define NULL_ALIASNAME	30
#define ILLEGAL_ALIASNAME	31
#define RECURSIVE_ALIAS	32
#define ERROR_REPORTED	33
#define TOP_ITF_ERRNO	34

#define truth(x) ((x)==TRUE ? true_string : (x)==FALSE ? false_string : (x)==UNDEF ? undefined_string : bad_boolean_string)

#ifndef _PFI_
#define _PFI_
typedef int (*PFI)(); /* pointer to function returning int */
#endif

enum QUIT_TYPE {NORMAL, EXIT, QUIT} ;
typedef enum ITimeType { ITimeUser, ITimeSystem, ITimeBoth } ITimeType ;

/* argc is set to one of these values when the command should provide info */
#define SHORT_HELP -1
#define LONG_HELP -2
#define IDoHelp(C) 	if (tokc==SHORT_HELP || tokc==LONG_HELP)\
                           { C return; }
#define GiveHelp(tokc)	(tokc==SHORT_HELP || tokc==LONG_HELP)
#define IUsage(S)	static char *usage = S
#define ISynopsis(S)	static char *synopsis = S
#define IHelpArgs 	tokc, tokv[0], usage, synopsis


extern void     Abort            ARGS(());
extern int      BuildSynopsisArray ARGS(());
extern int      ErrorV           ARGS(());
extern void     Error            ARGS(());
extern void     ErrorAbort       ARGS(());
extern void     IAbort           ARGS(());
extern char *   IArgError        ARGS((char *arg, char *error));
extern char *   IBaseName        ARGS((char *str));
extern int      IBusErrorRescue  ARGS(());
extern int      ICatchInterrupt  ARGS(());
extern int	ICloseFile	 ARGS((FILE *file, int *wasPipe)) ;
extern int      ICommandLoop     ARGS((FILE *in, FILE *out, char *prompt));
extern char *   IComposeTokvLine ARGS((char *tokv[], int use_quotes));
extern int      IDoArgvCommands  ARGS((char *argv[]));
extern int      IDoCommand       ARGS((int tokc, char *tokv[]));
extern int      IDoCommandLine   ARGS((char *line));
extern int      IDoCommandList   ARGS(());
extern int      IDoSingleCommand ARGS((FILE *in, FILE *out));
extern int      IEnterCommand    ARGS((char *name, PFI function));
extern int      IEnterFunction   ARGS((char *name, PFI function));
extern int      IEnterHelpStrings ARGS((char *commandName, char **string));
extern void     IError           ARGS(());
extern void     IErrorAbort      ARGS(());
extern void     IErrorV          ARGS(());
extern int      IExpectInteger   ARGS((char *this, char *after));
extern int      IExpectNumber    ARGS((char *this, char *after));
extern int      IExpectString    ARGS((char *this, char *after));
extern int      IExpectVarName   ARGS((char *this, char *after));
extern void     IExpected        ARGS((char *s));
extern void     IExpectedToken   ARGS((char *what, char *this, char *after));
extern int      IFPErrorRescue   ARGS(());
extern char *   IFindArg         ARGS((int tokc, char *tokv[], 
				       char *arg, int n));
extern int      IFindArgPos      ARGS((int tokc, char *tokv[], char *arg, 
				       int n));
extern TBL_ITEM *IFindCommand    ARGS((char *name, int *id));
extern char *   IFindFileInPath  ARGS((char *name, char *path, int Z_suffix));
extern char *   IFormatUsage     ARGS((char *intro, char *name, char *usage));
extern void     IFunctionEnter   ARGS((char *name));
extern void     IFunctionExit    ARGS((char *name));
extern PFI      IGetFunction     ARGS((char *name));
extern char **  IGetHelpStrings  ARGS((char *commandName));
extern int      IHaveCulprit     ARGS(());
extern void     IHelp            ARGS(());
extern char *   IInvalidNumber   ARGS((char *name));
extern int      IMuckUpLineNumbers ARGS(());
extern char *   INumberth        ARGS((int n));
extern FILE *   IOpenFileOrAbort ARGS((char *name, char *mode, char **pathp));
extern char *   IOutOfMemory     ARGS(());
extern int      IPipeErrorRescue ARGS(());
extern char *   IPrintUsage      ARGS((char *command, char *usage));
extern double	IRandReal	 ARGS(()) ;
extern int      IReportError     ARGS((FILE *s));
extern int      IResetError      ARGS(());
extern void	ISeed		 ARGS((int seed)) ;
extern int      ISegVioRescue    ARGS(());
extern void	*ISetAbortEnv    ARGS((void *));
extern int      IStandardInit    ARGS((int *argc, char *argv[]));
extern char *   ISwapWords       ARGS((char *p));
extern double	ITime		 ARGS((ITimeType type, int includeChildren)) ;
extern char *   ITooManyArgs     ARGS((char *command, char *n));
extern int      IWindowChange    ARGS(());
extern char *   IWrongNargs      ARGS((char *command, char *n));
extern int      InputMatches     ARGS((FILE *file, char *str));
extern char *   SysError         ARGS((int n));
extern int      true             ARGS((char *s));

extern int	mypid;
extern int	caught_signal;	/* the most recently caught signal */

extern int	itf_errno;
extern char	itf_error[];
extern char    *itf_error_str[];
extern char	itf_tmp_buf[];
extern enum QUIT_TYPE quit_flag;

extern PFI	pre_command_function;
extern PFI	post_command_function;

/* should be set by a command when it is called with argc == SHORT_HELP */
extern char    *help_string;

extern double	nan_double;

extern int	auto_more_enabled;
extern char	*automore;

extern HASH_TABLE *itf_func_table;
extern int	itf_com_context;
extern char	command_syntax[];
extern char	object_syntax[];

extern FILE	*dout;
extern FILE	*din;

extern char	*noclobber;
extern char	*unset_error;
extern char	*plus_minus_options;

#define plural(w) (w==1 ? "" : "s")
#define pluralchoice(w,sing,plur) (w==1 ? sing : plur)


#endif
