
/**********************************************************************
 * $Id: itf-argf.c,v 1.2 92/11/30 11:39:52 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include <xerion/useful.h>
#include "arg-desc.h"
#include "arg-actual.h"

/***
 * functions for using args stuff within the itf environment
 */

HASH_TABLE *arg_table = NULL;
int arg_table_context;
int stand_alone = 0;

struct ARG_DESC *FindOldArgDesc(name)
char *name;
{
  struct ARG_DESC *argd;
  TBL_ITEM *item;
  extern int n_commands;

  use_plus_minus_options = true(plus_minus_options);
  if (arg_table==NULL) {
    arg_table = INewTable(arg_table, n_commands+1, n_commands+1, ID_INDEX);
    arg_table_context = INewTableContext(arg_table);
  }
  item = ITableLookup(arg_table, name, arg_table_context);
  if (item==NULL)
    return NULL;
  else {
    argd = (struct ARG_DESC*) item->data.ptr;
    /***
     * see if we can find the function with the same name - if we
     * can, and the address is different to what is stored in argd,
     * then the function must have been dynamically reloaded, so
     * we should rebuild argd, and delete the old one.  memory is
     * thrown away.
     */
    item = ITableLookup(itf_func_table, name, itf_com_context);
    if (item!=NULL && item->data.pfi!=argd->func_ptr) {
      (void) ITableDelete(arg_table, name, arg_table_context);
      return NULL;
    } else
      return argd;
  }
}

void StoreArgDesc(argd)
struct ARG_DESC *argd;
{
  TBL_ITEM *item;
  item = ITableLookup(itf_func_table, argd->name, itf_com_context);
  argd->func_ptr = (item==NULL ? NULL : item->data.pfi);
  item = ITableLookup(arg_table, argd->name, arg_table_context);
  if (item==NULL) {
    item = ITableInsert(arg_table,  argd->name, arg_table_context, argd);
    if (item==NULL)
      warn("StoreArgDesc","failed to insert arg desc for \"%s\"", argd->name);
  }
}

int GetPlusMinusOptionSwitch()
{
  return true(plus_minus_options);
}
