
/**********************************************************************
 * $Id: hash-table.h,v 1.2 92/11/30 11:39:50 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef _HASH_TABLE_
#define _HASH_TABLE_

#ifndef _PFI_
#define _PFI_
typedef int (*PFI)(); /* pointer to function returning int */
#endif

struct BINDING;	/* `forward' declaration of BINDING */

typedef struct TBL_ITEM {
  int			context;
  int			id;	/* begins numbering at 1 */
  union {
    char		*ptr;	/* to an arbitrary structure or function */
    long		token;  /* or a token identifier */
    int			count;
    PFI			pfi;
    struct BINDING	*binding;
  } data;
  char			*name;
  struct TBL_ITEM	*next;	/* in this hash slot */
} TBL_ITEM;

typedef TBL_ITEM *(*ht_item_alloc)();

typedef struct HASH_TABLE {
  TBL_ITEM	**hash_vec;
  TBL_ITEM	**id_vec;
  TBL_ITEM	**alpha_vec; /* unimplemented */
  int		hash_bins;
  int		max_items;
  int		free_id;
  int		free_context;
  ht_item_alloc	free_item;
  ht_item_alloc	new_item;
} HASH_TABLE;

#define HT_NOT_FOUND	1
#define HT_AMBIGUOUS	2
#define HT_DUPLICATE	3
#define HT_BAD_ID	4
#define HT_NO_MEMORY	5
#define HT_BAD_NAME	6
#define HT_OVERFLOW	7
#define HT_CANT_DO	8

/* index_types can be one of the following: */
#define ID_INDEX	1
#define ALPHA_INDEX	2

extern int hash_errno;
extern char *hash_error[];

extern HASH_TABLE *INewTable 	    ARGS((HASH_TABLE *ht, int max_items, 
					  int hash_bins, int index_types));
extern int         INewTableContext ARGS((HASH_TABLE *ht));

extern int         ITableDelete		 ARGS((HASH_TABLE *ht, 
					       const char *name, int context));
extern int         ITableDeleteByContext ARGS((HASH_TABLE *ht, int context));

extern TBL_ITEM   *ITableInsert_ 	ARGS((HASH_TABLE *ht, 
					      const char *name, int context, 
					      long info));
extern TBL_ITEM   *ITableLookup		ARGS((HASH_TABLE *ht, 
					      const char *name, int context));
extern TBL_ITEM   *ITableLookupById	ARGS((HASH_TABLE *ht, int id));
extern TBL_ITEM   *ITableNext    	ARGS((HASH_TABLE *ht, int *id));
extern TBL_ITEM   *ITableNextByContext	ARGS((HASH_TABLE *ht, int *id, 
					      int context));
extern int         ITablePrint   	ARGS((HASH_TABLE *ht));
extern int         ht_lookup_id  	ARGS((HASH_TABLE *ht, char *name, 
					      int context));

#define ITableInsert(TABLE, NAME, CONTEXT, INFO) \
    ITableInsert_(TABLE, NAME, CONTEXT, (long)INFO)

#define ITableFirstByContext(ht, id, context) 	\
    (*(id)=0, ITableNextByContext(ht, id, context))

#endif				/* _HASH_TABLE_ */
