
/**********************************************************************
 * $Id: field-access.h,v 1.2 92/11/30 11:39:47 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef FIELD_ACCESS_H
#define FIELD_ACCESS_H

typedef struct FIELD_ACCESS {
  struct BINDING	access_binding;
  struct ADDRESS_ENV	access_env;
  struct BINDING	*field_binding;
  struct BINDING	*struct_binding;
  int			field_offset;
  int			field_id;
  char			*field_name;	/* the name of the field we are
					   accessing, e.g. "dEdt" */
  char			*access_name;	/* the name of the whole thing we are
					   accessing, e.g. ".dEdt[3]" */
  char			*struct_name;
  int			access_vector;	/* true if we should access an
					   element of the field vector */
  int			vector_elt;	/* the # of the elt */
  char			**extra;	/* extra tokens specifying the field */
};

extern int	IParseField	   ARGS((ADDRESS_ENV *parent, int *field_id, 
					 char ***tokvp));
extern int	IInitFieldAccess   ARGS((struct FIELD_ACCESS *access, 
					 char *struct_name, char *field_name));
extern int	IInitFieldIdAccess ARGS((struct FIELD_ACCESS *access, 
					 char *struct_name, int field_id));
extern int	ISetField	   ARGS((struct FIELD_ACCESS *access, 
					 char *struct_ptr, char *value));
extern char	IIGetField	   ARGS((struct FIELD_ACCESS *access, 
					 char *struct_ptr, char *format));

#endif				/* FIELD_ACCESS_H */
