/*
 * $Id: field-access.c,v 1.2 92/11/30 11:39:46 drew Exp $
 * 
 */

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/

#include <itf.h>

/***
 * These functions are intended to provide quick and easy access
 * to fields in structures by ascii name.
 * E.g. to access the "weight" field in a set of "LINK" structures
 * we could do the following:
 *
 * struct LINK *link;
 * struct FIELD_ACCESS access;
 * char *value;
 *
 * if (!IInitFieldAccess(&access,"LINK","weight")) IError("failed");
 * while (...) {
 *   ... get the link ptr and value ...
 *   ISetField(&access,link,value);
 *   ... or retrieve the value of the field as an ascii string
 *   value = IGetField(&access,link,format);
 * }
 *
 * This will also work with complex fields - e.g. accessing
 * an element of a field that is a vector.
 *
 * The way this works is that the field_id is stored in the
 * access record, along with the offset for that field.
 *
 * Also have to work out how to run through all the fields of a
 * structure.
 * Maybe have two versions of IInitFieldAccess() - one takes a
 * field name and the other takes a field number.
 * Look in show-ul.c for examples of what to do? - no these all
 * use IContParseObject - do we want to use that here? - it would
 * allow the field name to be a complex object, and possibly
 * follow pointers, but would cut down on efficiency.  Do we want
 * to be able to save array values in units & links? - how could
 * we do that? - as arrays or as array elements?
 */

/***
 * returns the id of the field (it's id in the hash table - 0 for error
 */
int IParseField(parent,field_id,tokvp)
ADDRESS_ENV *parent;
int *field_id;
char ***tokvp;
{
  TBL_ITEM *item;
  if (!**tokvp || strcmp(**tokvp,".")) {
    itf_errno = OBJECT_SYNTAX;
    IExpectedToken(".",**tokvp,NULL);
    return 0;
  }
  (*tokvp)++;
  if (!**tokvp) {
    itf_errno = OBJECT_SYNTAX;
    IExpectedToken("<field-name>",**tokvp,".");
    return 0;
  }
  item = ITableLookup(itf_table,**tokvp,parent->binding->var_type);
  if (item==NULL) {
    itf_errno = UNKNOWN_FIELD;
    IError("\"%s\"",**tokvp);
    return 0;
  }
  (*tokvp)++;
  *field_id = item->id;
  return 1;
}

int IInitFieldAccess(access,struct_name,field_name)
struct FIELD_ACCESS *access;
char *struct_name;
char *field_name;
{
}

int IInitFieldIdAccess(access,struct_name,field_id)
struct FIELD_ACCESS *access;
char *struct_name;
int field_id;
{
}

int ISetField(access,struct_ptr,value)
struct FIELD_ACCESS *access;
char *struct_ptr;
char *value;
{
}

char IIGetField(access,struct_ptr,format)
struct FIELD_ACCESS *access;
char *struct_ptr;
char *format;
{
}


