%{

/**********************************************************************
 * $Id: calc.y,v 1.3 93/03/29 14:15:41 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include <xerion/config.h>
#include <math.h>
#include "itf.h"

/***********************************************************************
 * We need all of these because they're GLOBALS, so we get name 
 * conflicts with anything else that uses yacc. A stupid irritating hack,
 * but I can't see any other way around it. The only problem is that I'm
 * not sure that every version of yacc uses the same variable names.
 ***********************************************************************/
#define yyparse() 	yyparseCalc()
#define yychar	 	yycharCalc
#define yyerrflag	yyerrflagCalc
#define yyval		yyvalCalc
#define yyexca		yyexcaCalc
#define yyact		yyactCalc
#define yypact		yypactCalc
#define yypgo		yypgoCalc
#define yyr1		yyr1Calc
#define yyr2		yyr2Calc
#define yychk		yychkCalc
#define yydef		yydefCalc
#define yydebug		yydebugCalc
#define yyv		yyvCalc
#define yys		yysCalc
#define yypv		yypvCalc
#define yyps		yypsCalc
#define yystate		yystateCalc
#define yytmp		yytmpCalc
#define yynerrs		yynerrsCalc
#define yymaxdepth	yymaxdepthCalc
/***********************************************************************/
#define YYSTYPE double		/* data typ of yacc stack */
/***********************************************************************/
%}
%token	NUMBER
%token	ABS
%token	SQRT
%token	LOG
%token	EXP
%token	SIN
%token	COS
%token	TAN
%token	SINH
%token	COSH
%token	TANH
%token	SIGMOID
%left	':'
%left	'?'
%left	OR
%left	AND 
%left	EQ NE GT GE LT LE 
%left	'+' '-'			/* left associative, same precedence */
%left	'*' '/'	'%'		/* left assoc., higer precedence */
%left	UNARYMINUS		/* obvious */
%right	'^'			/* exponentiation, even higher */
%%
list:				/* nothing */
  | list expr { fprintf(dout, "%.8g\n", $2) ; }
  ;

expr:	NUMBER			{ $$ = $1 ; }
  | '-' expr %prec UNARYMINUS	{ $$ = -$2 ; }
  | expr '+' expr		{ $$ = $1 + $3 ; }
  | expr '-' expr		{ $$ = $1 - $3 ; }
  | expr '*' expr		{ $$ = $1 * $3 ; }
  | expr '/' expr		{ $$ = $1 / $3 ; }
  | expr '%' expr		{ $$ = (int)$1 % (int)$3 ; }
  | expr '^' expr		{ $$ = pow($1, $3) ; }
  | '(' expr ')'		{ $$ = $2 ; }
  | expr EQ expr		{ $$ = ($1 == $3) ; }
  | expr NE expr		{ $$ = ($1 != $3) ; }
  | expr GT expr		{ $$ = ($1 > $3) ; }
  | expr GE expr		{ $$ = ($1 >= $3) ; }
  | expr LT expr		{ $$ = ($1 < $3) ; }
  | expr LE expr		{ $$ = ($1 <= $3) ; }
  | expr OR expr		{ $$ = $1 || $3 ; }
  | expr AND expr		{ $$ = $1 && $3 ; }
  | expr '?' expr ':' expr	{ $$ = $1 ? $3 : $5 ; }
  | ABS  '(' expr ')'		{ $$ = fabs( $3 ) ; }
  | SQRT '(' expr ')'		{ $$ = sqrt( $3 ) ; }
  | LOG  '(' expr ')'		{ $$ = log( $3 ) ; }
  | EXP  '(' expr ')'		{ $$ = exp( $3 ) ; }
  | SIN  '(' expr ')'		{ $$ = sin( $3 ) ; }
  | COS  '(' expr ')'		{ $$ = cos( $3 ) ; }
  | TAN  '(' expr ')'		{ $$ = tan( $3 ) ; }
  | SINH '(' expr ')'		{ $$ = sinh( $3 ) ; }
  | COSH '(' expr ')'		{ $$ = cosh( $3 ) ; }
  | TANH '(' expr ')'		{ $$ = tanh( $3 ) ; }
  | SIGMOID '(' expr ')'	{ $$ = 1.0 / ( 1.0 + exp( -$3 ) ) ; }
  ;
%%
/* end of grammar */
/*********************************************************************/
static char	*parseString ;
/*********************************************************************/
typedef struct BuiltinPair {
  int	token ;
  char	*name ;
  int	length ;
} BuiltinPair ;
typedef struct OperatorPair {
  int	token ;
  char	*name ;
  int	length ;
} OperatorPair ;
/*********************************************************************/
static BuiltinPair builtin[] = { /* sizeof returns 3 for sizeof("ab") */
  { ABS,	"abs",		sizeof("abs") },
  { SQRT,	"sqrt",		sizeof("sqrt") },
  { LOG,	"log",		sizeof("log") },
  { EXP,	"exp",		sizeof("exp") },
  { TAN,	"tan",		sizeof("tan") },
  { COS,	"cos",		sizeof("cos") },
  { SIN,	"sin",		sizeof("sin") },
  { TANH,	"tanh",		sizeof("tanh") },
  { COSH,	"cosh",		sizeof("cosh") },
  { SINH,	"sinh",		sizeof("sinh") },
  { SIGMOID,	"sigmoid",	sizeof("sigmoid") }
} ;
/*********************************************************************/
static OperatorPair operator[] = { /* must be longest name first */
  { OR,		"||",		sizeof("||") },
  { AND,	"&&",		sizeof("&&") },
  { EQ,		"==",		sizeof("==") },
  { NE,		"!=",		sizeof("!=") },
  { LE,		"<=",		sizeof("<=") },
  { GE,		">=",		sizeof(">=") },
  { LT,		"<",		sizeof("<")  },
  { GT,		">",		sizeof(">")  }
} ;
/*********************************************************************
 *	Name:		yylex
 *	Description:	
 *	Parameters:
 *	Return Value:
 *	  int	yylex - 
 *********************************************************************/
int	yylex() 
{
  int	c, idx ;
  char	*ptr, buffer[112] ;

  /* make parseString point to first non-white-space character */
  for (c = *parseString ; isspace(c) ; c = *(++parseString))
    ;

  /* if end of string, bug out */
  if (c == '\0')
    return 0 ;

  /* check for a number */
  yylval = strtod(parseString, &ptr) ;
  if (ptr != parseString) {
    parseString = ptr ;
    return NUMBER ;
  }

#if 0
  /* check for operators */
  for (idx = 0 ; idx < sizeof(operator)/sizeof(*operator) ; ++idx) {
    if (strncmp(parseString, 
		operator[idx].name, strlen(operator[idx].name)) == 0) {
      parseString += strlen(operator[idx].name) ;
      return operator[idx].token ;
    }
  }

  /* check for builtin functions (must be alphabetics) */
  if (sscanf(parseString, "%[a-z]", buffer)) {
    for (idx = 0 ; idx < sizeof(builtin)/sizeof(*builtin) ; ++idx) {
      if (strcmp(buffer, builtin[idx].name) == 0) {
	parseString += strlen(builtin[idx].name) ;
	return builtin[idx].token ;
      }
    }
  }
#else
  /* check for operators */
  for (idx = 0 ; idx < sizeof(operator)/sizeof(*operator) ; ++idx) {
    if (strncmp(parseString, 
		operator[idx].name, operator[idx].length-1) == 0) {
      parseString += operator[idx].length - 1 ;
      return operator[idx].token ;
    }
  }

  /* check for builtin functions (must be alphabetics) */
  if (sscanf(parseString, "%[a-z]", buffer)) {
    for (idx = 0 ; idx < sizeof(builtin)/sizeof(*builtin) ; ++idx) {
      if (strcmp(buffer, builtin[idx].name) == 0) {
	parseString += builtin[idx].length - 1 ;
	return builtin[idx].token ;
      }
    }
  }
#endif
  
  /* just increment parseString and return the character otherwise */
  ++parseString ;
  return c ;
}
/********************************************************************/

/*********************************************************************
 *	Name:		yyerror
 *	Description:	
 *	Parameters:
 *	  va_dcl
 *	Return Value:
 *	  int	yyerror - 
 *********************************************************************/
int	yyerror(va_alist)
  va_dcl
{
  va_list	 ap;

#ifndef hpux
  yyerrok ;
#endif

  va_start(ap);
  IErrorV(&ap) ;
  IAbort() ;
  return 1 ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		calc
 *	Description:	
 *	Parameters:
 *	  int	tokc - 
 *	  char	*tokvReturn Value:
 *	  int	command_calc - 
 *********************************************************************/
int	command_calc(tokc, tokv)
  int	tokc ;
  char	*tokv[] ;
{
  char	buffer[BUFSIZ] ;
  int	idx ;

  IUsage("<expr>");
  if (GiveHelp(tokc)) {
    ISynopsis("evaluate a floating point expression");
    IHelp
      (IHelpArgs,
       "The calc command  can  be used  to do evaluate simple floating point",
       "arithmetic expressions. The  result of the evaluation is  printed to",
       "the standard output. Expression syntax is very similar to C. Builtin",
       "operators include (in order of precedence):",
       "",
       "	-		unary minus",
       "	^		exponentiation",
       "	*, /, %		multiplication, division, modulo",
       "	+, -		addition, subtraction",
       "	<, <=, >, >=	less than, less than or equal, greater",
       "			than, greater than or equal",
       "	==, !=		equal, not equal",
       "	&&		logical AND",
       "	||		logical OR",
       "	? :		conditional expression",
       "",
       "As well, there are builtin functions for: abs,  sqrt, log, exp, tan,",
       "sin, cos, tanh, sinh, cosh, and sigmoid.",
       "EXAMPLES",
       "To cast a (0, 1) sigmoid onto (-1, 1), and print it:",
       "",
       "xerion-> calc '2.0 * sigmoid(1.0) - 1.0'",
       "0.46211716",
       "",
       "To print the maximum of the network cost and error:",
       "",
       "xerion-> calc \"${currentNet.error} > ${currentNet.cost} ? \\",
       "		${currentNet.error} : ${currentNet.cost}\"",
       "0.46211716",
       "To find the absolute value between a  unit's  target and output, you",
       "could use the following:",
       "",
       "xerion-> var Real output",
       "xerion-> var Real target",
       "xerion-> var Real diff",
       "xerion-> set output = ${currentNet.group[3].unit[0].output}",
       "xerion-> set target = ${currentNet.group[3].unit[0].target}",
       "xerion-> set diff   = `calc abs($output - $target)`",
       "xerion-> show diff",
       "	diff = 0.000139296",
       "",
       "SEE ALSO",
       "print, show, var, set",
       NULL);

    return 1;
  }
  
  buffer[0] = '\0' ;
  for (idx = 1 ; idx < tokc ; ++idx) {
    strcat(buffer, tokv[idx]) ;
    strcat(buffer, " ") ;
  }
  parseString = buffer ;

  yyparse() ;
  return 1 ;
}
/********************************************************************/

