
/**********************************************************************
 * $Id: bind.h,v 1.7 93/03/09 11:54:36 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef BIND_H
#define BIND_H

#include <values.h>
#define VALUE_BUFFER 1024 /* max size of values --- exceed this & DIE */

/* reserved features */
#define ITF_SYSTEM	0x00800000L
#define ITF_MARK	0x01000000L
#define ITF_VISIBLE	0x02000000L
#define ITF_READONLY	0x04000000L
#define ITF_SAVE	0x08000000L
#define ITF_RESETABLE	0x10000000L
#define ITF_ORPHANABLE	0x20000000L
#define ITF_VARLEN	0x40000000L
#define ITF_EXPORT	0x80000000L
#define ITF_RESERVED_FEATURES 0xFFFF0000L

#define ITF_STRING		1
#define ITF_REAL		2
#define ITF_FLOAT		3
#define ITF_DOUBLE		4
#define ITF_LONG		5
#define ITF_INT			6
#define ITF_SHORT		7
#define ITF_CHAR		8
#define ITF_BOOLEAN		9
#define ITF_PSUEDO_FIELD	10
#define ITF_STRUCT		11
#define ITF_VAR_TYPES		12

/* max number of characters in a var name: */
#define MAX_VAR_NAME	1024
#define MASSAGE_VAR_NAME(name,buf) \
  {if (name!=buf){int _ii;for(_ii=0;name[_ii];_ii++)if(name[_ii]=='_')buf[_ii]='-';else buf[_ii]=name[_ii];buf[_ii]=0;}}

/* work out what the type Real is */
#ifdef DOUBLE
typedef double	Real;
#define MAXREAL	MAXDOUBLE
#define REAL_DEFINED
#endif
#ifdef SINGLE
typedef float Real;
#define MAXREAL	MAXFLOAT
#define REAL_DEFINED
#endif
#ifndef REAL_DEFINED
typedef float Real;
#define MAXREAL	MAXFLOAT
#define SINGLE
#define REAL_DEFINED
#endif

/* PFPC - pointer to a function returning pointer to a char */
typedef char	*(*PFPC)();

/* String is already typedefed in Intrinsic.h so don't do it again  */
#ifndef _XtIntrinsic_h
typedef char	*String;
#endif
#define STRING_DEFINED

/* typedef int	boolean; */
/* typedef char	generic; */ /* the generic type of pointers to structures */

/* Union Pointer Or Int (POI) */

typedef union POI {
  struct {
    short	offset;
    short	type;
  }		field;
  long		longint;
  PFPC		pfpc;
  String	string;
  Real		*real_ptr;
  float		*float_ptr;
  double	*double_ptr;
  char		*char_ptr;
  String	*string_ptr;
  long		*long_ptr;
  int		*int_ptr;
  short		*short_ptr;
  Boolean	*boolean_ptr;
  generic	*ptr;
  generic	**pptr;
  generic	**ppptr;
} POI;

#define MAX_INDIRECTION	3

/*
 * These are used in itype[i]
 */
#define FIXED_ARRAY	0x1
#define COUNTED_ARRAY	0x2
#define POINTER		0x4
#define AUTO_POINTER	0x8
#define ENV_IS_ARRAY	(FIXED_ARRAY|COUNTED_ARRAY)
#define ENV_IS_POINTER	(POINTER|AUTO_POINTER)

/*
 * These are bits that object_prop (in BINDING) can take
 */
#define IS_FIELD	0x01	/* a field descriptor */
#define IS_STRUCT	0x02	/* a struct */
#define IS_SIMPLE	0x04	/* long, float, String, etc. */
#define IS_COUNTER	0x08
#define IS_ARRAY	0x10
#define	IS_UNION	0x20
#define IS_TAG		0x40
#define HAS_DEFAULT	0x80
#define OBJECT_IS_PROP	0xFF

/*
 * The following are just used for convenient input to Ibind_*
 */

#define OBJECT		0x0020
#define P_OBJECT	0x0040	/* the POI is a ptr to a C object */
#define PP_OBJECT	0x0080	/* the POI is a ptr to a C object ptr */
#define PPP_OBJECT	0x0100	/* the POI is a ptr to a C object ptr ptr */
#define P_COUNT		0x0200
#define PP_COUNT	0x0400
#define PPP_COUNT	0x0800
#define P_FIXED		0x1000
#define PP_FIXED	0x2000
#define PPP_FIXED	0x4000

#define FIXED_PS	(P_FIXED|PP_FIXED|PPP_FIXED)
#define COUNT_PS	(P_COUNT|PP_COUNT|PPP_COUNT)
#define ARRAY_PS	(P_COUNT|PP_COUNT|PPP_COUNT|P_FIXED|PP_FIXED|PPP_FIXED)

#define TEST(X)		((X)!=0)

/***
 * Following are used as flags to the MoveTo functions
 */
#define SWAP	1
#define NO_SWAP	0

typedef struct BINDING {
  union {
    Real	real;
    POI		poi;
  } value;
  short		itype[MAX_INDIRECTION+1];
  short		array_count[MAX_INDIRECTION+1];
  short		ilevel;
  short		reference_count;
  short		object_prop;
  short		element_size;
  short		var_type;	/* takes values ITF_STRING, etc. */
  long		features;
  TBL_ITEM	*tbl_entry;
  PFPC		func_to_call;
  char		*default_val;
  /* the following are for the printing format, e.g. %9.5g would be: */
  char		format_code;	/* 'g' */
  char		format_width;	/* 9 (as an integer) */
  char		format_prec;	/* 5 (as an integer) */
} BINDING;

typedef struct ADDRESS_ENV {
  BINDING	*binding;
  BINDING	*parent_binding;	/* for fields */
  POI		poi;
  POI		parent_poi;
  char		*name;
  short		ilevel;
  short		have_index[MAX_INDIRECTION+1];
} ADDRESS_ENV;

typedef enum ITF_FEATURE_ACTION {
  SET_FEATURE,
  UNSET_FEATURE,
  ENQUIRE
} ITF_FEATURE_ACTION;

typedef enum SHOW_STYLE {
  SHOW_DISPLAY,
  SHOW_SAVE,
  SHOW_BRIEF
} SHOW_STYLE;

#define RESET_ENV(X) {(X)->binding=NULL;(X)->poi.ptr=NULL;(X)->have_index=0;(X)->is_complex=0;(X)->index=0;}

/* The following are in bind-enter.c */
extern int      IEnterField      ARGS((char *struct_type_name, 
				       char *field_type_name, 
				       char *name, int offset, 
				       int mode, int prop, 
				       char *counter_name));
extern char *   IBindChar        ARGS((char *name, char *char_ptr, 
				       int mode, int prop, char *count));
extern char *   IBindDouble      ARGS((char *name, double *double_ptr,
				       int mode, int prop, char *count));
extern char *   IBindFloat       ARGS((char *name, float *float_ptr, 
				       int mode, int prop, char *count));
extern char *   IBindInt         ARGS((char *name, int *int_ptr, 
				       int mode, int prop, char *count));
extern char *   IBindLong        ARGS((char *name, long *long_ptr, 
				       int mode, int prop, char *count));
extern BINDING *IBindPoi         ARGS((char *in_name, int type, 
                                       POI poi, int mode, int prop, 
                                       int elt_size, int context, int count));
extern char *   IBindReal        ARGS((char *name, Real *real_ptr, 
				       int mode, int prop, char *count));
extern char *   IBindShort       ARGS((char *name, short *short_ptr, 
				       int mode, int prop, char *count));
extern char *   IBindString      ARGS((char *name, String *string_ptr, 
				       int mode, int prop, char *count));
extern char *   IBindStruct      ARGS((char *name, char *typename, 
				       generic *struct_ptr, int mode, 
				       char *count));

extern int      IAddMinimizeParam	ARGS((char *name));
extern int      IAddNetParam     	ARGS((char *name));
extern char *   IArrayCounter    	ARGS((BINDING *binding));
extern int      IArrayObjectBound    	ARGS((char *in_name));
extern int      IAssignString    	ARGS((char **strp, char *value));
extern void     IBindInit        	ARGS((int max_vars));
extern int      ICheckExistSvar  	ARGS((char *in_name));
extern int      IEnterType       	ARGS((char *name,int size,int prop));
extern int      IEnvIsSimple     	ARGS((struct ADDRESS_ENV *env));
extern int      IEnvIsSimpleArray       ARGS((struct ADDRESS_ENV *env));
extern int      IEnvIsSimpleSetError    ARGS((struct ADDRESS_ENV *env));
extern int      IExport          	ARGS((char *name, char *value));
extern long     IGetFeatures     	ARGS((char *name));
extern char *   IGetName         	ARGS((char *in_name));
extern char *	IGetObjectTypeName	ARGS((char *in_name));
extern int      IGetType         	ARGS((char *in_name, int *size));
extern char *   IGetTypeName     	ARGS((int type));
extern int      IIsArray         	ARGS((BINDING *binding));
extern int      IIsArrayObject         	ARGS((char *in_name));
extern int      IIsCounter       	ARGS((BINDING *binding));
extern int      IIsExport        	ARGS((char *name));
extern int      IIsField         	ARGS((BINDING *binding));
extern int      IIsMarked        	ARGS((char *name));
extern int      IIsNULL    		ARGS((char *in_name));
extern int      IIsObjectName    	ARGS((char *in_name));
extern int      IIsReadonly      	ARGS((char *name));
extern int      IIsSave          	ARGS((char *name));
extern int      IIsSimple       	ARGS((char *name));
extern int      IIsStruct        	ARGS((BINDING *binding));
extern int      IIsStructure        	ARGS((char *name));
extern int      IIsStructType    	ARGS((int type));
extern int      IIsVisible       	ARGS((char *name));
extern char **  IListMinimizeParams     ARGS((void));
extern char **  IListNetParams   	ARGS((void));
extern char **	IListStructFields   	ARGS((char *,int));
extern int      ISetExport       	ARGS((char *name, int on));
extern long     ISetFeatureMask  	ARGS((long m));
extern int      ISetFeatures     	ARGS((char *name, long feat, int on));
extern PFPC     ISetFunction     	ARGS((char *in_name, PFPC function));
extern int      ISetMark         	ARGS((char *name, int on));
extern int      ISetReadonly     	ARGS((char *name, int on));
extern int      ISetSave         	ARGS((char *name, int on));
extern int      ISetSimpleValue  	ARGS((struct ADDRESS_ENV *, char *));
extern int      ISetSystem       	ARGS((char *name, int on));
extern int      ISetValue        	ARGS((char *in_name, char *value));
extern int      ISetVisible      	ARGS((char *name, int on));
extern void     IShowVarValues   	ARGS((FILE *f, long mask, int all));
extern char *   itoa             	ARGS((int i));

extern int 	itf_obj_context;
extern int 	itf_type_context;
extern int 	itf_top_struct_type;
extern char 	itf_value_buffer[1024 ];
extern char 	itf_name_buffer[MAX_VAR_NAME+10];
extern HASH_TABLE *itf_table;


/* The following are in bind-print.c */
extern int	IAddDefault	 ARGS((char *in_name, char *value));
extern int	IAutoCreateVar	 ARGS((char *in_name));
extern int	IContParseObject ARGS((char *name, struct ADDRESS_ENV *env, 
				       int *take_address));
extern int	IContParseObjectTokv ARGS((ADDRESS_ENV *this, char ***tokvp));
extern int	ICreateEnv	 ARGS((ADDRESS_ENV *env, char *type_name, 
				       generic *ptr));
extern generic *IDeleteObject	 ARGS((char *in_name));
extern int	IEnvIsArray	 ARGS((ADDRESS_ENV *env));
extern int	IEnvIsNull	 ARGS((ADDRESS_ENV *this));
extern int	IEnvIsPointer	 ARGS((ADDRESS_ENV *env));
extern int	IEnvIsStruct	 ARGS((ADDRESS_ENV *env));
extern char    *IGetDefault	 ARGS((char *in_name));
extern char    *IGetFormat	 ARGS((char *in_name));
extern generic *IGetObjectPtr	 ARGS((char *object_type_name, char *in_name));
extern char    *IGetSimpleValue	 ARGS((struct ADDRESS_ENV *env, 
				       int take_address, char *format, 
				       int quote));
extern char    *IGetValue	 ARGS((char *in_name, char *format));
extern char    *IGetValueCompositeName ARGS(());
extern int	IGetArrayBound	 ARGS((ADDRESS_ENV *this));
extern int	IIncIndirection	 ARGS((ADDRESS_ENV *this));
extern char    *IMakeFormatStr	 ARGS((int var_type, int width, 
				       int precision, int code));
extern int	IMoveToElement	 ARGS((ADDRESS_ENV *this, int index_value));
extern int	IMoveToField	 ARGS((ADDRESS_ENV *parent, ADDRESS_ENV *field,
				       int field_id, int swap));
extern int	IMoveToPointer	 ARGS((ADDRESS_ENV *this));
extern int	INPercent	 ARGS((char *str));
extern int	INewExport	 ARGS((char *name));
extern int	IParseField	 ARGS((ADDRESS_ENV *parent, int *field_id, 
				       char ***tokvp));
extern TBL_ITEM *IParseFieldOrObject ARGS((char *name));
extern int	IParseFormat	 ARGS((char *formatIn, int *width, 
				       int *precision, int *code));
extern int	IParseIndex	 ARGS((int *index_valuep, char ***tokvp));
extern int	IParseObject	 ARGS((char *name, struct ADDRESS_ENV *env, 
				       int *take_address));
extern int	IParseObjectTokv ARGS((ADDRESS_ENV *result, char ***tokvp));
extern char    *IPrintRealFormatted	 ARGS((double r, char *format));
extern char    *IPrintStringFormatted	 ARGS((char *s, char *format));
extern int	IPrintPoi	 ARGS((char *buffer, int len, POI *poi, 
				       int var_type, int format_width, 
				       int format_prec, int format_code));
extern int	IPrintWhatis	 ARGS((char *in_name, int verbose));
extern int	IPutQuotedString ARGS((char *str, int quote, FILE *out));
extern int	IRecalcFieldEnv	 ARGS((ADDRESS_ENV *env, 
				       generic *struct_addr));
extern int	IResetObject	 ARGS((char *in_name));
extern int	ISetDefault	 ARGS((char *in_name, char *value));
extern int	ISetEnvFromItem	 ARGS((ADDRESS_ENV *env, TBL_ITEM *item));
extern int	ISetupStructFieldEnv ARGS((ADDRESS_ENV *env, 
					   int struct_type, TBL_ITEM *item));
extern void	ISetBindingDefaults	 ARGS((BINDING *binding));
extern void	ISetDefaults	 ARGS((char *object_type_name, 
				       char *struct_p));
extern void	ISetEnvDefaults	 ARGS((ADDRESS_ENV *env));
extern void	ISetFormat	 ARGS((char *in_name, int format_width, 
				       int format_prec, int format_code));
extern void	ISetVectorDefaults ARGS((char *object_type_name, 
					 char *struct_p, int n));
extern int	IShowArrayObject ARGS((char *name, ADDRESS_ENV *, 
				       enum SHOW_STYLE, int indent, int));
extern int	IShowObjectEnv	 ARGS((char *name, ADDRESS_ENV *env, 
				       enum SHOW_STYLE style, int indent));
extern int	IShowSimpleObject ARGS((char *name, ADDRESS_ENV *env, 
					enum SHOW_STYLE style, int indent));
extern int	IShowStructObject ARGS((char *name, ADDRESS_ENV *env, 
					enum SHOW_STYLE style, int indent));
extern void	IShowObject	 ARGS((char *in_name, enum SHOW_STYLE style));
extern int	IWithinBounds	 ARGS((ADDRESS_ENV *this, int index_value));


extern char	default_format_code[];
extern char	default_format_prec[];
extern char	default_format_width[];
extern char    *itf_type_names[];
extern char    *legal_format_codes[];
extern int	name_width;
extern char    *show_array_on_line;
extern int	show_indent_inc;
extern char	use_format_prec[];

/* The following are from bind-var.c */
extern char    *IGetScalarAddr	   ARGS((int type, char *in_name));
extern int     *IGetScalarIntAddr  ARGS((char *name));
extern Real    *IGetScalarRealAddr ARGS((char *name));
extern char    *IGetVectorAddr	   ARGS((int type, char *in_name, int *n));
extern int     *IGetVectorIntAddr  ARGS((char *name, int *n));
extern Real    *IGetVectorRealAddr ARGS((char *name, int *n));
extern char    *IMakeScalar	   ARGS((char *type, char *in_name));
extern char    *IMakeVector	   ARGS((char *type, char *in_name, int len));

#define COPY_STRUCT(source,dest) 	\
    memcpy((void*)(dest), (void*)(source), sizeof(*source))

#endif				/* BIND_H */
