
/**********************************************************************
 * $Id: bind-var.c,v 1.4 93/03/03 12:26:17 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include "itf.h"
#include "lex.h"

/***
 * IMakeVector - creates a vector of the given type and length
 * If a vector of the correct type and name already exists, its
 * length is adjusted.
 */
char *IMakeVector(type,in_name,len)
char *type,*in_name;
int len;
{
  POI poi;
  BINDING *binding;
  int size,type_id;
  struct ADDRESS_ENV env;
  int take_address;
  int cur_len;
  char *name=itf_name_buffer;
  /***
   * Find the type id
   */
  type_id = IGetType(type,&size);
  if (type_id==0) {
    IError("\"%s\" is not a type",type);
    return NULL;
  }
  /***
   * Look for an existing vector
   */
  if (!in_name || !*in_name) {
    itf_value_buffer[0]=0;
    itf_errno = NULL_VARNAME;
    return 0;
  }
  MASSAGE_VAR_NAME(in_name,name);
  if (   IParseObject(name,&env,&take_address)
      && IEnvIsArray(&env)
      && env.binding->ilevel==1
      && env.binding->var_type == type_id
      && env.binding->itype[1] & FIXED_ARRAY) {
    cur_len = IGetArrayBound(&env);
    if (cur_len != len) {
      env.binding->value.poi.ptr = Realloc(char,env.binding->value.poi.ptr,
					   len * env.binding->element_size);
      if (env.binding->value.poi.ptr==NULL) {
	IOutOfMemory("IMakeVector","reallocating vector");
	return NULL;
      }
      if (len > cur_len)
	memset(env.binding->value.poi.ptr + cur_len*size,
	       0, (len - cur_len)*size) ;
      env.binding->array_count[1] = len;
    }
    return env.name;
  }
  IResetError();

  /***
   * If all that failed, try creating a new vector
   */
  if (!IIsLegalVarName(name)) {
    itf_errno = ILLEGAL_VARNAME;
    IError("%s",name);
    return NULL;
  }
  poi.ptr = Calloc(char,len * size);
  if (poi.real_ptr==NULL) {
    IOutOfMemory("IMakeVector","allocating vector");
    return NULL;
  }
  binding = IBindPoi(name,type_id,poi,P_OBJECT|P_FIXED,0,
			 size,itf_obj_context,len);
  if (binding) return binding->tbl_entry->name;
  else return NULL;
}

char *IMakeScalar(type,in_name)
char *type,*in_name;
{
  POI poi;
  BINDING *binding;
  ADDRESS_ENV env;
  int take_address;
  int size,type_id;
  char *name=itf_name_buffer;
  type_id = IGetType(type,&size);
  if (type_id==NULL) {
    IError("\"%s\" is not a type",type);
    return NULL;
  }
  /***
   * Look for an existing scalar
   */
  if (!in_name || !*in_name) {
    itf_value_buffer[0]=0;
    itf_errno = NULL_VARNAME;
    return 0;
  }
  MASSAGE_VAR_NAME(in_name,name);
  if (   IParseObject(name,&env,&take_address)
      && !IEnvIsArray(&env)
      && env.binding->ilevel==1
      && env.binding->var_type == type_id) {
    env.binding->value.poi.ptr = Calloc(char,env.binding->element_size);
    if (env.binding->value.poi.ptr==NULL) {
      IOutOfMemory("IMakeScalar","allocating scalar");
      return NULL;
    }
    return env.name;
  }
  IResetError();

  poi.ptr = Calloc(char,size);
  if (poi.real_ptr==NULL) {
    IOutOfMemory("IMakeScalar","allocating scalar");
    return NULL;
  }
  if (!IIsLegalVarName(name)) {
    itf_errno = ILLEGAL_VARNAME;
    IError("%s",name);
    return NULL;
  }
  binding = IBindPoi(name,type_id,poi,P_OBJECT,0,
			 size,itf_obj_context,0);
  if (binding) return binding->tbl_entry->name;
  else return NULL;
}

char *IGetScalarAddr(type,in_name)
int type;
char *in_name;
{
  struct ADDRESS_ENV env;
  int take_address;
  char *name=itf_name_buffer;
  if (!in_name || !*in_name) {
    itf_value_buffer[0]=0;
    itf_errno = NULL_VARNAME;
    return 0;
  }
  MASSAGE_VAR_NAME(in_name,name);
  if (   IParseObject(name,&env,&take_address)
      && IEnvIsSimpleSetError(&env))
    if (env.binding->var_type == type)
      return env.poi.ptr;
    else {
      itf_errno = BAD_VARTYPE;
      IError("var \"%s\" is not of type \"%s\"",name,IGetTypeName(type));
      return NULL;
    }
  if (!IHaveCulprit()) IError("%s",name);
  itf_value_buffer[0]=0;
  return 0;
}

int *IGetScalarIntAddr(name)
char *name;
{
  return (int*)IGetScalarAddr(ITF_INT,name);
}

Real *IGetScalarRealAddr(name)
char *name;
{
  return (Real*)IGetScalarAddr(ITF_REAL,name);
}

char *IGetVectorAddr(type,in_name,n)
int type;
char *in_name;
int *n;
{
  struct ADDRESS_ENV env;
  int take_address;
  char *name=itf_name_buffer;
  *n = 0;
  if (!in_name || !*in_name) {
    itf_value_buffer[0]=0;
    itf_errno = NULL_VARNAME;
    return NULL;
  }
  MASSAGE_VAR_NAME(in_name,name);
  if (IParseObject(name,&env,&take_address)) {
    if (IEnvIsArray(&env) && env.ilevel==1) {
      if (env.binding->var_type == type) {
	*n = IGetArrayBound(&env);
	return env.poi.ptr;
      } else {
	itf_errno = BAD_VARTYPE;
	IError("vector \"%s\" is not of type \"%s\"",name,IGetTypeName(type));
	return NULL;
      }
    } else {
      itf_errno = BAD_VARTYPE;
      IError("\"%s\" is not a vector",name);
      return NULL;
    }
  }
  return NULL;
}

Real *IGetVectorRealAddr(name,n)
char *name;
int *n;
{
  return (Real*)IGetVectorAddr(ITF_REAL,name,n);
}

int *IGetVectorIntAddr(name,n)
char *name;
int *n;
{
  return (int*)IGetVectorAddr(ITF_INT,name,n);
}

int command_var(tokc,tokv)
int tokc;
char *tokv[];
{
  LEX_STACK stack;
  /* int is_vector; */
  /* int len; */
  /* int return_code; */
  char **tokv1;
  int tokc1,length;
  IUsage("<type> <name>|<type> <name>[<length>]");
  if (GiveHelp(tokc)) {
    ISynopsis("create a variable or vector of the given type");
    IHelp
      (IHelpArgs,
       "A variable or vector of  the given type  is created.  Type should be",
       "one of the following: int, Real, float, double, String",
       "EXAMPLES",
       "To create a string variable called \"foo\":",
       "",
       "\txerion-> var String foo",
       "",
       "To create an array of Real variables called \"array\":",
       "",
       "\txerion-> var Real array[8]",
       "SEE ALSO",
       "set, export, show, print",
       NULL);
    return 1;
  }
  
  if (tokc!=3 || IIsInteger(tokv[1]) || IIsInteger(tokv[2])) {
    IError(IPrintUsage(tokv[0],usage));
    return 0;
  }
  tokv1 = LexAnalysePush(object_syntax,tokv[2],&tokc1,&stack);
  if (tokc1==1) {		/* a scalar */
    if (IMakeScalar(tokv[1],tokv[2])==NULL)
      IErrorAbort("couldn't make scalar object");
  } else if (tokc1==4) {	/* a vector */
    if (IIsLegalVarName(tokv1[2]) && !IIsInteger(tokv1[2]))
      length = atoi(IGetValue(tokv1[2],NULL));
    else length = atoi(tokv1[2]);
    if (itf_errno || strcmp(tokv1[1],"[") || strcmp(tokv1[3],"]") || length<0){
      IError(IPrintUsage(tokv[0],usage));
      return 0;
    } else
      if (IMakeVector(tokv[1],tokv1[0],length)==NULL)
	IErrorAbort("couldn't make vector object");
  } else {
    IError(IPrintUsage(tokv[0],usage));
    return 0;
  }
  LexAnalysePop(&stack);
  return 1;
}

