/*
 * $Id: assert.h,v 1.2 92/11/30 11:39:36 drew Exp $
 * 
 */

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/

/*	@(#)assert.h 1.7 88/02/07 SMI; from UCB 4.2 85/01/21	*/
/*
 * Tap's version of assert has two forms of assertion - assert()
 * can be knocked out, but really_assert() can't.  The latter is
 * useful for checking returns from mallocs & the suchlike.
 * Each form can also take a message - assertm(ex,m), and
 * really_assertm(ex,m).
 */

#ifndef __ASSERT_H__
#ifndef DISPLAY_INCLUDED
#ifndef _ASSERT_
#define _ASSERT_

# define implies(A, B) (!(A) || (B))
# define ASSERT_EXIT abort()

# ifndef NDEBUG
# define _assert(ex)	{if (!(ex)){(void)fprintf(stderr,"Assertion failed: file \"%s\", line %d\n", __FILE__, __LINE__);ASSERT_EXIT;}}
# define assert(ex)	_assert(ex)
# define _assertm(ex,m)	{if (!(ex)){(void)fprintf(stderr,"Assertion failed: (%s) file \"%s\", line %d\n", m, __FILE__, __LINE__);ASSERT_EXIT;}}
# define assertm(ex,m)	_assertm(ex,m)
# else
# define _assert(ex)
# define assert(ex)
# define _assertm(ex,m)
# define assertm(ex,m)
# endif

# define _really_assert(ex)	{if (!(ex)){(void)fprintf(stderr,"Assertion failed: file \"%s\", line %d\n", __FILE__, __LINE__);ASSERT_EXIT;}}
# define really_assert(ex)	_really_assert(ex)
# define _really_assertm(ex,m)	{if (!(ex)){(void)fprintf(stderr,"Assertion failed: (%s) file \"%s\", line %d\n", m, __FILE__, __LINE__);ASSERT_EXIT;}}
# define really_assertm(ex,m)	_really_assertm(ex,m)

#endif

#endif				/* DISPLAY_INCLUDED */
#endif				/* __ASSERT_H__ */

