
/**********************************************************************
 * $Id: arg-desc.h,v 1.2 92/11/30 11:39:27 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#ifndef ARG_DESC_H
#define ARG_DESC_H

typedef (*verifyfunc) ARGS((char*, char*, int));

enum ARG_JOIN {ARG_NOJOIN,ARG_OR,ARG_AND,ARG_SEQ,ARG_XOR};
enum ARG_TYPE {
  ARG_BAD_TYPE,
  ARG_LITERAL,
  ARG_INTEGER,
  ARG_FLOAT,
  ARG_REAL,
  ARG_DOUBLE,
  ARG_STRING,
  ARG_CHAR,
  ARG_BOOLEAN,
  ARG_NATURAL,
  ARG_SHORT,
  ARG_LONG,
  ARG_FORMAT,
  ARG_AREA_FORMAT,
  ARG_RANGE_STRING,
  ARG_VAR_NAME,
  ARG_MEMBER_NAME,
  ARG_FILE_IN,
  ARG_FILE_OUT
};

#define FOUND_ACTUAL		0x1
#define NO_ACTUAL		0x2
#define OPTION_ON		0x4
#define OPTION_OFF		0x8
#define OPTION_PRESENT		0x10
#define SATISFIED_ARGS		0x20
#define PARTIALLY_FILLED	0x40
#define FILLED_AND_CLOSED	0x80
#define ACTUAL_CLEARED		0x1000
#define ACTUAL_FLAGS (FOUND_ACTUAL|NO_ACTUAL|OPTION_ON|OPTION_OFF|OPTION_PRESENT|SATISFIED_ARGS|PARTIALLY_FILLED|FILLED_AND_CLOSED)
#define ALL_ACTUAL_FLAGS	0xFFFF

#define ARG_DESC_MAGIC_START	0x5c6b7a89
#define ARG_DESC_MAGIC_END	0xc5d4e3f2

struct ARG_DESC {
  int			magic_number;	/* ARG_MAGIC_START or ARG_MAGIC_END */
  struct ARG_LIST	**arg_list;
  int			n_lists;
  char			*name;
  int			filling_aps;	/* 1 if we are just filling aps, not
					   building the whole thing */
  int			fill_list;	/* next list to fill */
  int			complete;
  char			**option_names;	/* to check for ambiguities */
  int			(*func_ptr)();
};

struct ARG_LIST {
  struct ARG_GROUP	*group;
  enum ARG_JOIN		join;
  struct ARG_LIST	*next;
  struct ARG_LIST	*parent;
  int			id;		/* just to uniquely identify */
  generic		***ap_loc;
  int			*ap_should_point_to_null;
  int			n_aps;
  int			actual;
};

struct ARG_GROUP {
  enum {ARG_GROUP_SIMPLE, ARG_GROUP_OPTION}
  				tag;
  union {
    struct {
      struct ARG_OPTION		*option;
      struct ARG_LIST		*arg_list;
      int			optional;
    }			option;
    struct {
      struct ARG_SIMPLE		*arg_simple;
    }			simple;
  }				u;
  int				*presence;
  int				*neg_presence;
  char				*help;
  int				actual;
};

struct ARG_SIMPLE {
  char			*prompt;
  int			vector;		/* argument is a vector */
  enum ARG_TYPE		type;
  verifyfunc		verify;
  generic		*store;		/* where to store data */
  int			*store_len;	/* where to store vector length */
  int			vector_len;	/* where to store vector length */
  int			actual;		/* store info about actual arg */
  int			id;
};

struct ARG_OPTION {
  char			*name;
  int			no_prefix;
  int			is_signed;
  int			*sign;		/* store sign here */
  int			*neg_sign;	/* store !sign here */
  int			*presence;	/* store 1 here if present */
  int			*neg_presence;	/* store 0 here if present */
  char			*help;
  int			actual;		/* store info about actual arg */
};

extern struct ARG_DESC *StartArgs ARGS((char *name));
extern void     	Args      ARGS(());
extern void     	EndArgs   ARGS((struct ARG_DESC *arg_desc));

#endif				/* ARG_DESC_H */
