
/***********************************************************************
 * $Id: simulator.h,v 1.9 93/01/26 11:19:02 drew Exp $
 ***********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef SIMULATOR_H
#define SIMULATOR_H

#include <xerion/config.h>
#include <string.h>
#include <values.h>

/***********************************************************************
 * Useful typedefs
 ***********************************************************************/
#ifndef REAL_DEFINED
#define REAL_DEFINED
#ifdef DOUBLE
typedef double	Real ;
#define MAXREAL	MAXDOUBLE
#else
typedef float	Real;
#define MAXREAL	MAXFLOAT
#endif
#endif

#ifndef _XtIntrinsic_h
#ifndef _ITF_
typedef char	Boolean	;
#endif
#ifndef STRING_DEFINED
typedef char	*String ;
#endif
#endif				/* _XtIntrinsic_h */

typedef int	Action,   (*ActionPtr)() ;
typedef void	Proc,     (*ProcPtr) ARGS(()) ;
typedef int	IntFunc,  (*IntFuncPtr)() ;
typedef Real	RealFunc, (*RealFuncPtr)() ;

#ifndef FALSE
#define FALSE	(Boolean)0
#endif
#ifndef TRUE
#define TRUE	(Boolean)1
#endif

/***********************************************************************
 * Predefinitions of external functions
 * itf.h predefines malloc etc. as char *, so don't redo them here
 ***********************************************************************/

/***********************************************************************
 * Predefinitions of Object types
 ***********************************************************************/
typedef struct UnitRec		*Unit ;		/* BIND */
typedef struct LinkRec		*Link ;		/* BIND */
typedef struct GroupRec		*Group ;	/* BIND */
typedef struct ExampleSetRec	*ExampleSet ;	/* BIND */
typedef struct NetRec		*Net ;		/* BIND */
typedef struct LinkRec		*Variable ; 	/* BIND */

/***********************************************************************
 * Now include the Object header files
 ***********************************************************************/
#include <xerion/minimize.h>
#include <xerion/mask.h>
#include <xerion/methods.h>

#include <xerion/qArray.h>
#include <xerion/gaussian.h>
#include <xerion/costModel.h>
#include <xerion/sigmoid.h>

#include <xerion/link.h>
#include <xerion/unit.h>
#include <xerion/group.h>
#include <xerion/example.h>
#include <xerion/net.h>
#include <xerion/connect.h>
#include <xerion/traverse.h>
#include <xerion/access.h>

#endif				/* SIMULATOR_H */
