/**********************************************************************
 * $Id: config.sgi.h,v 1.3 92/11/30 11:29:23 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/***
 * Configuration file - try to put all machine dependent stuff in here
 */

#define OPERATING_SYSTEM_NAME "IRIX System V Release 4.0.1"

/***
 * Type declaration for signal handler (the type of the object that
 * signal() returns).
 * This should conform with the definition in the standard include
 * file <signal.h>.
 * We want this definition because we want to be able to do things like:
 *   SignalHandler old_handler = signal(SIGINT,new_handler);
 *   ...
 *   (void) signal(old_handler);
 * which installs a new signal handler, then when finished restores
 * the old one.
 */

typedef int (*SignalHandler) ARGS((int, ...)) ;

/* regular expression pattern matching */
extern char	*regex ARGS((char *, ...)) ;
extern char	*regcmp ARGS((char *, char *, ...)) ;

#ifndef isNaN
extern double		nan_double ;
#define isNaN(x)	(nan_double=x, IsNANorINF(nan_double))
#endif

#ifndef _JBLEN
_JBLEN is not defined! (this should cause a syntax error)
#endif




