/**********************************************************************
 * $Id: config.hp.h,v 1.5 93/03/03 12:44:28 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/***
 * Type declaration for signal handler (the type of the object that
 * signal() returns).
 * This should conform with the definition in the standard include
 * file <signal.h>.
 * We want this definition because we want to be able to do things like:
 *   SignalHandler old_handler = signal(SIGINT,new_handler);
 *   ...
 *   (void) signal(old_handler);
 * which installs a new signal handler, then when finished restores
 * the old one.
 */

typedef void (*SignalHandler)();
/* compiler will barf on next line if conflict with <signal.h> */
extern SignalHandler signal();
#ifdef _BSD_COMPAT
#define BSD_SIGNALS
#endif

#ifndef isNaN
extern double		nan_double ;
#define isNaN(x)	(nan_double=x, isnan(nan_double))
#endif

/* 
 * HPUX doesn't seem to have the math library functions for 
 * rint, tanh, or atanh, so lets do macros for them here.
 */
#define rint(x)		floor((x)+ 0.5)
#define tanh(x)		(2.0/(1.0 + exp(-2.0*(x))) - 1.0)
#define atanh(y)	(-log((1.0 - (y))/(1.0 + (y)))/2.0)


#define getpriority(which, who) syscall(SYS_GETPRIORITY, which, who)
#define setpriority(which, who, niceval) syscall(SYS_SETPRIORITY, which, who,\
		    niceval) 
