
/**********************************************************************
 * $Id: config.h,v 1.7 93/02/26 12:03:34 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/

#ifndef __config_h__
#define __config_h__

/***
 * Configuration file - try to put all machine dependent stuff in here
 */

#include <setjmp.h>

#ifndef NOSTDHDRS
#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#endif

#if defined(__STDC__) || defined(sgi) || defined (DEC)
/* this gets used with gcc - allows function argument checking */
#define ARGS(x)		x
#define NOARGS		(void)
#define COMPILER __STDC__
#else
/* and this gets used with cc */
#define ARGS(x)		()
#define NOARGS		()
#define COMPILER __NOT__STDC__
#define const
#endif

typedef char generic;

/***
 * This is a multi-system version of the config.h file, it includes the
 * appropriate one:
 */

#if defined(sgi) || defined(__sgi)
#include "config.sgi.h"
#endif

#if defined(sun)
#include "config.sun.h"
#endif

#if defined(hpux)
#include "config.hp.h"
#endif

#if defined (__osf__)
#include "config.osf.h"
#endif

#if defined (ultrix)
#include "config.ultrix.h"
#endif

#endif				/* __config_h__ */

