
/**********************************************************************
 * $Id: xshow.c,v 1.5 92/11/30 11:29:06 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include <xerion/MenuPane.h>

#include <xerion/display.h>
#include <xerion/displayUtils.h>
#include <xerion/display2Itf.h>
#include <xerion/display2Sim.h>

#include <xerion/useful.h>

#include "objectDisplay.h"
#include "xshow.h"

/********************************************************************/
typedef struct XShowRec {
  Widget	shell ;
  String	titleFormat ;
  ObjectDisplay	xshow ;
} XShowRec, *XShow ;
/********************************************************************/
static void	createXshow	ARGS((Widget, String)) ;
static void	destroyXShowCB	ARGS((Widget, XtPointer, XtPointer)) ;
static void	destroyCB	ARGS((Widget, XtPointer, XtPointer)) ;
static void	resetCB		ARGS((Widget, XtPointer, XtPointer)) ;
static void	reset		ARGS((XShow)) ;
/********************************************************************/

/*******************************************************************
 *	Name:		command_xshow
 *	Description:	xshow an object
 *	Parameters:
 *	  int	tokc - As usual
 *	  char	*tokv -
 *	Return Value:
 *	  int	command_xshow - as usual
 *******************************************************************/
export int	command_xshow(tokc, tokv)
  int		tokc ;
  char		*tokv[] ;
{
  IUsage("<name> ...");
  if (GiveHelp(tokc)) {
    ISynopsis("show a structure object using a separate window.");
    IHelp
      (IHelpArgs,
       NULL);
    return 0;
  }

  if (tokc == 1) {
    setSignalHandler() ;
    xshow(NULL) ;
    resetSignalHandler() ;
  }

  for (++tokv, --tokc ; tokc > 0 ; ++tokv, --tokc) {
    if (!IGetObjectTypeName(*tokv)) {
      itf_errno = UNKNOWN_VAR;
      IErrorAbort("\"%s\"", *tokv);
    }
    setSignalHandler() ;
    xshow(*tokv) ;
    resetSignalHandler() ;
  }
  return 1 ;
}

/*********************************************************************
 *	Name:		xshow
 *	Description:	pops up an xshow window (destroyed on popdown) ;
 *	Parameters:
 *	  String	name - the name of the struct to xshow
 *	Return Value:
 *	  export void	xshow - NONE
 *********************************************************************/
export void	xshow(name)
  String	name ;
{
  Widget	shell ;

  if (topLevel == NULL)
    return ;

  shell = XtVaCreatePopupShell("xshow", topLevelShellWidgetClass, topLevel,
			       NULL) ;
  createXshow(shell, name) ;
  
  XtAddCallback(shell, XtNpopdownCallback, destroyCB, NULL) ;
  XtPopup(shell, XtGrabNone);
}
/********************************************************************/


/*********************************************************************
 *	Name:		createXshowNet
 *	Description:	xshows the currentNet
 *	Parameters:
 *	  Widget	shell - the popup shell 
 *	Return Value:
 *	  export void	createXshowNet - NONE
 *********************************************************************/
export void	createXshowDisplay(shell)
  Widget	shell ;
{
  createXshow(shell, NULL) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		createXshow
 *	Description:	
 *	Parameters:
 *	  Widget	shell - 
 *	Return Value:
 *	  export void	createXshow - 
 *********************************************************************/
static void	createXshow(shell, name)
  Widget	shell ;
  String	name ;
{
  XShow		this ;
  Widget	form, menuPane, menu, menuButton, widget ;
  String	netName ;

  if (topLevel == NULL)
    return ;
  
  this = XtNew(XShowRec) ;
  
  this->shell = shell ;
  this->titleFormat = getTitle(this->shell) ;
  getNetValue(NAME, &netName) ;
  widgetPrintf(this->shell, this->titleFormat, netName) ;
  
  /**********************
   * Form to hold everything
   */
  form = XtVaCreateManagedWidget("xshow", formWidgetClass, this->shell, 
				 NULL) ;

  /**********************
   * Pulldown menu pane 
   */
  menuPane = XtVaCreateManagedWidget("menuPane", menuPaneWidgetClass, form,
				     NULL) ;

  /**********************
   * ObjectDisplay
   */
  this->xshow = createObjectDisplay(name, form) ;

  /**********************
   * Options pulldown menu 
   */
  menuButton = XtVaCreateManagedWidget("options",
				       menuButtonWidgetClass, menuPane,
				       XtNmenuName,	"optionsMenu",
				       NULL) ;
  
  menu = XtVaCreatePopupShell("optionsMenu", simpleMenuWidgetClass, menuButton,
			      NULL) ;
  
  widget = XtVaCreateManagedWidget("reset", smeBSBObjectClass, menu, NULL) ;
  XtAddCallback(widget, XtNcallback, resetCB, (XtPointer)this);

  widget = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL) ;

  widget = XtVaCreateManagedWidget("close", smeBSBObjectClass, menu, NULL) ;
  XtAddCallback(widget, XtNcallback, popdownWidgetCB, (XtPointer)this->shell);

  /**********************
   * Final stuff for the shell
   */
  XtVaSetValues(this->shell, XtNcreatePopupChildProc, NULL, NULL) ;
  XtAddCallback(this->shell, XtNdestroyCallback, 
		destroyXShowCB, (XtPointer)this) ;

  XtAddCallback(shell, XtNpopupCallback, resetCB, (XtPointer)this) ;
  reset(this) ;
}
/********************************************************************/
static void	destroyXShow(this)
  XShow		this ;
{
  if (this->titleFormat)
    XtFree((void *)this->titleFormat) ;
}
/********************************************************************/


/********************************************************************/
static void	destroyCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  XtDestroyWidget(widget) ;
}
/********************************************************************/
static void	destroyXShowCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  destroyXShow((XShow)clientData) ;
}
/********************************************************************/
static void	resetCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  reset((XShow)clientData) ;
}
/********************************************************************/
static void	reset(this)
  XShow		this ;
{
  MODreset(this->xshow) ;
}
/********************************************************************/
