
/**********************************************************************
 * $Id: weightDisplay.c,v 1.12 93/03/03 12:48:14 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>
#include <math.h>
#include <varargs.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>

#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include <xerion/Network.h>
#include <xerion/MenuPane.h>
#include <xerion/RowColumn.h>
#include <xerion/Controller.h>
#include <xerion/display.h>

#include "display2Itf.h"
#include "display2Sim.h"
#include "displayUtils.h"
#include "Trace.h"
#include "check.h"

typedef struct {
  Widget	shell ;
  Widget	fixedMax ;
  Widget	maxValue ;
  Widget	size ;
  Widget	border ;
  Widget	margin ;
  Widget	blockHeight ;
  Widget	fixedBlockHeight ;
  Widget	blockWidth ;
  Widget	fixedBlockWidth ;
  Widget	blockMargin ;
} *MiscNetworkDialog ;


typedef struct {
  Widget	shell ;		/* the popup shell for the display */
  Widget	rowCol ;	/* the row column widget to put the nets in */
  Widget	*network ;	/* the network widgets */
  Cardinal	numNets ;	/* the number of them */
  Cardinal	maxNets ;	/* the real size of the array */
  Widget	scaleWidget ;	/* the label widget showing scale etc. */
  String	titleFormat ;	/* the label for the widget */
  String	scaleFormat ;	/* the label for the widget */
  Widget	*back ;		/* the widget backgrounds available	*/
  XtStyle	*style ;	/* the widget backgrounds available	*/
  int		styleIdx ;	/* which style to use 			*/
  Widget	*field ;	/* the widget backgrounds available	*/
  int		fieldIdx ;	/* the index of the link field to display */
  float		maxValue ;
  Dimension	border ;
  Boolean	fixedMax ;
  DisplayNotification	state ;
  MiscNetworkDialog	dialog ;
} WeightDisplayRec, *WeightDisplay ;

typedef struct {
  String	showField ;
  Boolean	hideLabel ;
} OptionsRec ;

static OptionsRec	options ;

static XtResource	resources[] = {
  {"showField", "ShowField", XtRString, sizeof(String),
     XtOffsetOf(OptionsRec, showField), XtRImmediate, (XtPointer)"weight" },
  {"hideLabel", "HideLabel", XtRBoolean, sizeof(Boolean),
     XtOffsetOf(OptionsRec, hideLabel), XtRImmediate, (XtPointer)FALSE }
} ;


/* private functions */
static void 	destroyCB	ARGS((Widget, XtPointer, XtPointer)) ;
static void 	destroyMiscCB	ARGS((Widget, XtPointer, XtPointer)) ;

static void	reset		  ARGS((WeightDisplay)) ;
static void 	resetCB	  	  ARGS((Widget,	XtPointer, XtPointer)) ;
static void 	stateResetCB	  ARGS((Widget,	XtPointer, XtPointer)) ;
static void 	displayResetCB	  ARGS((Widget,	XtPointer, XtPointer)) ;
static void 	structureResetCB  ARGS((Widget,	XtPointer, XtPointer)) ;

static void 	toggleShowLabelCB  ARGS((Widget, XtPointer, XtPointer)) ;
static void 	checkFieldCB	   ARGS((Widget, XtPointer, XtPointer)) ;
static void	changeFieldCB	   ARGS((Widget, XtPointer, XtPointer)) ;
static void 	checkBackgroundCB  ARGS((Widget, XtPointer, XtPointer)) ;
static void 	changeBackgroundCB ARGS((Widget, XtPointer, XtPointer)) ;

static void 	printValueCB	ARGS((Widget,	XtPointer, XtPointer)) ;
static void 	changeValueCB	ARGS((Widget,	XtPointer, XtPointer)) ;
static void 	miscellaneousCB ARGS((Widget, XtPointer, XtPointer)) ;

static void	displayFanIn ARGS((int unitIidx, void *data)) ;

static void	setSensitive	ARGS((WeightDisplay)) ;
static void	rebuildNet	ARGS((WeightDisplay, Widget, 
				      UnitDisplayRec  *, int)) ;

static Cardinal	numDisplays = 0 ;

static XtStyle	styleOption[] = { XtShadow, XtLines, XtLines2, XtWeave,
				    XtPlain, XtSolid } ;
static String	styleName[] = { "shadow", "lines", "lines2", "weave",
				  "plain", "solid" } ;

/***********************************************************************
 *	Name:		createWeightDisplay
 *	Description:	creates the window for the network display
 *			and all of the sub windows and necessary methods
 *	Parameters:	
 *	  Widget	popup - the popup shell that is the parent
 *	Return Value:	
 *			NONE
 ***********************************************************************/
export void	createWeightDisplay(popup)
  Widget	popup ;
{
  WeightDisplay	this ;
  Widget	menuPane, menuButton, menu ;
  Widget	form, trace, widget ;
  String	*list, name ;
  char		buffer[BUFSIZ] ;
  int		idx ;

  this = (WeightDisplay)malloc(sizeof(WeightDisplayRec)) ;

  this->shell = popup ;
  XtAddCallback(this->shell, XtNdestroyCallback, destroyCB, (XtPointer)this) ;
  XtGetApplicationResources(this->shell, (XtPointer)&options,
			    resources, XtNumber(resources), NULL, 0) ;

  this->fixedMax = FALSE ;
  this->border   = -1 ;
  this->maxValue = 0.0 ;

  /********************************************
   * Network Name label 
   */
  this->titleFormat = getTitle(this->shell) ;
  getNetValue(NAME, &name) ;
  widgetPrintf(this->shell, this->titleFormat, name) ;

  form = XtVaCreateManagedWidget("form", formWidgetClass, popup, NULL) ;
  redirectKeyboardInput(form) ;

  /********************************************
   * Pulldown menu pane 
   */
  menuPane = XtVaCreateManagedWidget("menuPane", menuPaneWidgetClass, form,
				     NULL) ;

  /********************************************
   * Display Updates 
   */
  sprintf(buffer, "weightDisplay %d", numDisplays++) ;
  trace = XtVaCreatePopupShell(buffer, traceWidgetClass, popup, 
			       NULL) ;
  XtAddCallback(trace, XtNcallback, stateResetCB, (XtPointer)this) ;

  /**********************
   * Options menu 
   */
  menuButton = XtVaCreateManagedWidget("options",
				       menuButtonWidgetClass, menuPane,
				       XtNmenuName, "optionsMenu",
				       NULL) ;

  menu = XtVaCreatePopupShell("optionsMenu", simpleMenuWidgetClass, menuButton,
			      NULL) ;
  
  widget = XtVaCreateManagedWidget("updates", smeBSBObjectClass,  menu, NULL);
  XtAddCallback(widget, XtNcallback, popupCenteredCB,  (XtPointer)trace) ;

  widget = XtVaCreateManagedWidget("reset",   smeBSBObjectClass,  menu, NULL);
  XtAddCallback(widget, XtNcallback, structureResetCB, (XtPointer)this) ;

  widget = XtVaCreateManagedWidget("line",    smeLineObjectClass, menu, NULL);
  widget = XtVaCreateManagedWidget("close",   smeBSBObjectClass,  menu, NULL);
  XtAddCallback(widget, XtNcallback, popdownWidgetCB,  (XtPointer)popup) ;

  /**********************
   * "Field" menu 
   */
  menuButton = XtVaCreateManagedWidget("field",
				       menuButtonWidgetClass, menuPane,
				       XtNmenuName, "fieldMenu",
				       NULL) ;

  menu = XtVaCreatePopupShell("fieldMenu", simpleMenuWidgetClass, menuButton, 
			      NULL) ;
  XtAddCallback(menu, XtNpopupCallback, checkFieldCB, (XtPointer)this) ;
  
  list = listLinkFields() ;
  for (idx = 0 ; list && list[idx] ; ++idx)
    ;
  this->field = (Widget *)XtCalloc(idx + 1, sizeof(Widget)) ;

  this->fieldIdx = 0 ;
  for (idx = 0 ; list && list[idx] != NULL ; ++idx) {
    widget = XtVaCreateManagedWidget(list[idx], smeBSBObjectClass, menu,
				     XtNleftMargin, check_width, 
				     NULL) ;
    XtAddCallback(widget, XtNcallback, changeFieldCB, (XtPointer)this) ;
    this->field[idx] = widget ;
    if (strcmp(list[idx], options.showField) == 0)
      this->fieldIdx = idx ;
  }
  this->field[idx] = NULL ;

  /**********************
   * Network menu 
   */
  menuButton = XtVaCreateManagedWidget("network",
				       menuButtonWidgetClass, menuPane,
				       XtNmenuName, "networkMenu",
				       NULL) ;
  menu = XtVaCreatePopupShell("networkMenu", simpleMenuWidgetClass, menuButton,
			      NULL);
  XtAddCallback(menu,   XtNpopupCallback, checkBackgroundCB, (XtPointer)this) ;

  this->back  = (Widget  *)XtCalloc(XtNumber(styleOption)+1, sizeof(Widget)) ;
  this->style = (XtStyle *)XtCalloc(XtNumber(styleOption)+1, sizeof(XtStyle)) ;
  for (idx = 0 ; idx < XtNumber(styleOption) ; ++idx) {
    widget = XtVaCreateManagedWidget(styleName[idx], smeBSBObjectClass, menu,
				     XtNleftMargin, check_width,
				     NULL) ;
    XtAddCallback(widget, XtNcallback, changeBackgroundCB, (XtPointer)this) ;
    this->back[idx]  = widget ;
    this->style[idx] = styleOption[idx] ;
  }
  this->back[idx]  = NULL ;
  this->style[idx] = (XtStyle)-1 ;
  this->styleIdx   = -1 ;

  widget = XtVaCreateManagedWidget("line", smeLineObjectClass, menu, NULL) ;
  widget = XtVaCreateManagedWidget("showLabel", smeBSBObjectClass, menu,
				   XtNlabel, (options.hideLabel ? 
					      "Show Label" : "Hide Label"), 
				   NULL) ;
  XtAddCallback(widget, XtNcallback, toggleShowLabelCB, (XtPointer)this) ;

  widget = XtVaCreateManagedWidget("misc", smeBSBObjectClass, menu, NULL) ;
  XtAddCallback(widget, XtNcallback, miscellaneousCB, (XtPointer)this) ;

  /********************************************
   * Scale label
   */
  widget = XtVaCreateManagedWidget("scaleLabel", labelWidgetClass, form, 
				   XtNmappedWhenManaged, 
				   options.hideLabel ? FALSE : TRUE,
				   NULL) ;
  this->scaleFormat = getLabel(widget) ;
  widgetPrintf(widget, this->scaleFormat, 0.0, 0.0, 0.0) ;
  this->scaleWidget = widget ;

  /********************************************
   * Network 
   */
  widget = XtVaCreateManagedWidget("viewport", viewportWidgetClass, form, 
				   NULL) ;
  widget = XtVaCreateManagedWidget("rowColumn", rowColumnWidgetClass, widget,
				   NULL) ;
  this->rowCol = widget ;
  this->network = NULL ;
  this->numNets = 0 ;
  this->maxNets = 0 ;
  
  /********************************************
   * Add all the callbacks 
   */
  XtAddCallback(controller, XtNcallback, resetCB,	   (XtPointer)this) ;
  XtAddCallback(popup, XtNpopupCallback, structureResetCB, (XtPointer)this) ;

  XtInstallAllAccelerators(form, form) ;

  /********************************************
   * Do the reset for the first time
   */
  this->dialog   = NULL ;
  this->state    = DNStructureChange ;
  reset(this) ;

  XtVaSetValues(popup,XtNcreatePopupChildProc, NULL, NULL) ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		destroyCB
 *	Description:	destroys the WeightDisplay
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - the WeightDisplay
 *	  XtPointer	callData - 
 *	Return Value:
 *	  static void	destroyCB - 
 *********************************************************************/
static void	destroyCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  if (this == NULL)
    return ;

  if (this->titleFormat)
    XtFree((void *)this->titleFormat) ;
  if (this->scaleFormat)
    XtFree((void *)this->scaleFormat) ;
  if (this->network)
    XtFree((void *)this->network) ;
  if (this->field)
    XtFree((void *)this->field) ;
  if (this->back)
    XtFree((void *)this->back) ;
  if (this->style)
    XtFree((void *)this->style) ;

  XtRemoveCallback(controller, XtNcallback, resetCB, (XtPointer)this) ;

  XtFree((void *)this) ;
}
/********************************************************************/


static void 	toggleShowLabelCB (widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  Widget	label = ((WeightDisplay)clientData)->scaleWidget ;
  String	toggleLabel ;
  
  toggleLabel = getLabel(widget) ;
  if (strcmp(toggleLabel, "Hide Label") == 0) {
    XtUnmapWidget(label) ;
    widgetPrintf(widget, "Show Label") ;
  } else {
    XtMapWidget(label) ;
    XRaiseWindow(XtDisplay(label), XtWindow(label)) ;
    widgetPrintf(widget, "Hide Label") ;
  }
  XtFree(toggleLabel) ;
}


/**********************************************************************
 *	Name:		changeFieldCB
 *	Description:	sets the mask of what connection field to
 *			display
 *	Parameters:
 *	  Widget	widget 	   - the widget the callback is attached to
 *	  XtPointer	clientData - the index to set it to
 *	  XtPointer	callData   - the call data (XtListReturnStruct *)
 *	Return Value:
 *		NONE
 **********************************************************************/
static void	changeFieldCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  int		idx ;

  if (this == NULL || this->field == NULL)
    return ;

  for (idx = 0 ; this->field[idx] && this->field[idx] != widget ; ++idx)
    ;

  if (this->field[idx]) {
    this->fieldIdx = idx ;
    this->state = DNDisplayChange ;
    reset(this) ;
  }
}
/**********************************************************************/


/*********************************************************************
 *	Name:		checkFieldCB
 *	Description:	
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - 
 *	  XtPointer	callData - 
 *	Return Value:
 *	  static void	checkFieldCB - 
 *********************************************************************/
static void	checkFieldCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  int		idx ;

  for (idx = 0 ; this->field[idx] ; ++idx)
    checkMenuItem(this->field[idx], idx == this->fieldIdx ? TRUE : FALSE) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		changeBackgroundCB
 *	Description:	changes the unit background used in the networks
 *	Parameters:
 *	  Widget	widget     - the menu option
 *	  XtPointer	clientData - the weightDisplay
 *	  XtPointer	callData   - UNUSED
 *	Return Value:
 *	  static void	changeBackgroundCB - 
 *********************************************************************/
static void	changeBackgroundCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  int		idx ;

  if (this == NULL || this->back == NULL)
    return ;

  for (idx = 0 ; this->back[idx] && this->back[idx] != widget ; ++idx)
    ;

  if (this->back[idx]) {
    this->styleIdx = idx ;
    this->state    = DNDisplayChange ;
    reset(this) ;
  }
}
/********************************************************************/


/*********************************************************************
 *	Name:		checkBackgroundCB
 *	Description:	
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - 
 *	  XtPointer	callData - 
 *	Return Background:
 *	  static void	checkBackgroundCB - 
 *********************************************************************/
static void	checkBackgroundCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  int		idx ;

  for (idx = 0 ; this->back[idx] ; ++idx)
    checkMenuItem(this->back[idx], idx == this->styleIdx ? TRUE : FALSE) ;
}
/********************************************************************/


/***********************************************************************
 *	Name:		reset
 *	Description:	rebuilds a network Widget showing the current
 *			networks weight levels
 *		WeightDisplay	display - the weightDisplay
 *	Return Value:
 *		NONE
 ***********************************************************************/
static void	reset(this)
  WeightDisplay	this ;
{
  double	scale, mean, var ;
  int		idx ;

  if (this->state == DNStructureChange) {
    String	name ;
    getNetValue(NAME, &name) ;
    widgetPrintf(this->shell, this->titleFormat, name) ;
    setSensitive(this) ;
  }

  if (this->state == DNStructureChange || this->state == DNDisplayChange) {
    if (netExists()) {
      int		height, width, margin ;

      getNetValue(MAJOR_HEIGHT, &height) ;
      getNetValue(MAJOR_WIDTH,  &width) ;
      getNetValue(MAJOR_MARGIN, &margin) ;

      /* reinitialize the row and column sizes */
      XtVaSetValues(this->rowCol,
		    XtNcolumnWidth,   width,
		    XtNrowHeight,     height,
		    XtNvertDistance,  margin,
		    XtNhorizDistance, margin,
		    NULL) ;
    }
    XtUnmanageChild(this->rowCol) ;
  }

  /* We got a network, so calculate the necessary stuff */
  this->numNets = getNumberOfUnits() ;
  if (this->numNets) {
    if (this->numNets > this->maxNets) {
      this->network = (Widget *)XtRealloc((char *)this->network, 
					  this->numNets*sizeof(Widget)) ;
      memset(this->network + this->maxNets, 0,
	     (this->numNets - this->maxNets)*sizeof(Widget)) ;
      this->maxNets = this->numNets ;
    }

    getWeightParams(this->fieldIdx, &mean, &var, &scale) ;
  } else {
    mean = var = scale = 0.0 ;
  }

  if (this->fixedMax != TRUE) 
    this->maxValue = scale ;

  if (this->numNets)
    displayForAllUnits(displayFanIn, this) ; 

  for (idx = this->numNets ; idx < this->maxNets ; ++idx)
    if (this->network[idx] && XtIsManaged(this->network[idx]))
      XtUnmanageChild(this->network[idx]) ;

  widgetPrintf(this->scaleWidget,
	       this->scaleFormat, this->maxValue, mean, var) ;

  XtManageChild(this->rowCol) ;
  this->state = DNNoChange ;
}
/**********************************************************************/
static void resetCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;

  this->state = (DisplayNotification)callData ;
  reset(this) ;
}
/********************************************************************/
static void structureResetCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;

  this->state = DNStructureChange ;
  reset(this) ;
}
/********************************************************************/
static void stateResetCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;

  this->state = DNStateChange ;
  reset(this) ;
}
/********************************************************************/
static void displayResetCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;

  this->state = DNDisplayChange ;
  reset(this) ;
}
/********************************************************************/


/***********************************************************************
 *	Name:		displayFanIn 
 *	Description:	I'm really sorry about this bit of code.
 *			Please accept my apologies, but I had to
 *			hack it together really quick and I know
 *			it totally sucks.
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
static void	displayFanIn (unitIdx, data)
  int		unitIdx ;
  void		*data ;
{
  WeightDisplay		this    = (WeightDisplay)data ;
  Widget		network = this->network[unitIdx] ;
  UnitDisplayRec	*unitArray ;
  int			idx, numUnits ;

  if (getUnitMajorRow() < 0 || getUnitMajorColumn() < 0) {
    if (network && XtIsManaged(network))
      XtUnmanageChild(network) ;
    return ;

  } else if (network == NULL) {
    network = XtVaCreateManagedWidget("weightNet", 
				      networkWidgetClass, this->rowCol,
				      NULL) ;
    XtAddCallback(network,
		  XtNchangeValueCallback, changeValueCB, (XtPointer)this) ;
    XtAddCallback(network, 
		  XtNqueryCallback,	  printValueCB,  (XtPointer)this) ;
    this->network[unitIdx] = network ;
  }

  unitArray = getFanIn(this->fieldIdx, &unitArray, &numUnits) ;
  if (numUnits) {
    for (idx = 0 ; idx < numUnits ; ++idx)
      unitArray[idx].value /= this->maxValue ;

    if (this->state == DNStructureChange || this->state == DNDisplayChange) {
      XtVaSetValues(network,
		    XtNrow,    getUnitMajorRow(),
		    XtNcolumn, getUnitMajorColumn(),
		    NULL) ;
      rebuildNet(this, network, unitArray, numUnits) ;
    } else {
      XtNetworkSetUnits(network, unitArray) ;
    }

    if (!XtIsManaged(network))
      XtManageChild(network) ;

  } else if (XtIsManaged(network)) { /* no network, blank out the widget */
    XtUnmanageChild(network) ;
  }
}
/**********************************************************************/


/***********************************************************************
 *	Name:		rebuildNet
 *	Description:	rebuilds the units and size of a network widget
 *	  Widget		network    - the network widget to update
 *	  UnitDisplayRec	*unitArray - the array of units to  update with
 *	  int		numUnits   - the number of units
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static void	rebuildNet(this, network, unitArray, numUnits)
  WeightDisplay		this ;
  Widget		network ;
  UnitDisplayRec	*unitArray ;
  int			numUnits ;
{
  int		height, width, margin ;
  int		majorHeight, majorWidth ;
  Boolean	changeManaged = FALSE ;

  getNetValue(MAJOR_HEIGHT, &majorHeight) ;
  getNetValue(MAJOR_WIDTH,  &majorWidth) ;
  getNetValue(MINOR_HEIGHT, &height) ;
  getNetValue(MINOR_WIDTH,  &width) ;
  getNetValue(MINOR_MARGIN, &margin) ;

  if (XtIsManaged(network)) {
    XtUnmanageChild(network) ;
    changeManaged = TRUE ;
  }

  if ((short)this->border < 0)
    XtVaGetValues(network, XtNunitBorderWidth, &this->border, NULL) ;

  if (this->styleIdx < 0) {
    XtStyle	style ;
    int		idx ;

    XtVaGetValues(network, XtNunitBackgroundStyle, &style, NULL) ;
    for (idx = 0 ; this->style[idx] >= 0 && style != this->style[idx] ; ++idx)
      ;
    this->styleIdx = this->style[idx] >= 0 ? idx : 0 ;
  }

  XtVaSetValues(network,
		XtNunitBackgroundStyle, this->style[this->styleIdx],
		XtNunitBorderWidth,	this->border,
		XtNheight,		majorHeight,
		XtNwidth,		majorWidth,
		XtNunitHeight,		height,
		XtNunitWidth, 		width,
		XtNunitSep,		margin,
		XtNnumUnits,		numUnits,
		XtNunitArray,		unitArray,
		NULL) ;
  if (changeManaged)
    XtManageChild(network) ;
  
  XtVaGetValues(network, XtNunitBorderWidth, &this->border, NULL) ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		setSensitive
 *	Description:	sets the sensitive field to true or false for
 *			all of the widgets that care.
 *	Parameters:
 *	  WeightDisplay	this - the weightDisplay 
 *	Return Value:
 *	  static void	setSensitive - NONE
 *********************************************************************/
static void	setSensitive(this)
  WeightDisplay	this ;
{
  Widget	menuPane ;
  Boolean	sensitive ;

  menuPane = XtNameToWidget(this->shell, "form.menuPane") ;

  if (netExists())
    sensitive = TRUE ;
  else
    sensitive = FALSE ;

  /* if no network, can't set the background of units */
  XtSetSensitive(XtNameToWidget(menuPane, "network"), sensitive) ;

  /* don't forget the label saying what we're showing */
  XtSetSensitive(this->scaleWidget, sensitive) ;
  
  /* If no network, can't change the field being displayed either  */
  XtSetSensitive(XtNameToWidget(menuPane, "field"), sensitive) ;
}
/********************************************************************/


/***********************************************************************
 *	Name:		printValueCB
 *	Description:	prints out the weight level of a unit
 *	Parameters:	
 *	  Widget	widget 	   - the widget the callback is attached to
 *	  XtPointer	clientData - the network widget
 *	  XtPointer	callData   - NetworkReturnStruct *
 *	Return Value:	
 *		NONE
 ***********************************************************************/
static void printValueCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay		this	      = (WeightDisplay)clientData ;
  NetworkReturnStruct	*returnStruct = (NetworkReturnStruct *)callData ;
  UnitDisplayRec	*unitPtr ;

  if (!XtIsSubclass(widget, networkWidgetClass))
    return ;

  unitPtr = XtNetworkGetUnit(widget, returnStruct->index) ;
  if (unitPtr) {
    String	fieldName = getLabel(this->field[this->fieldIdx]) ;
    
    fprintf(stdout, "\n%s = %.4g for link \"%s\"\n",
	    fieldName, unitPtr->value*this->maxValue, 
	    (char *)unitPtr->userData) ;
    XtFree((char *)unitPtr) ;
    XtFree((char *)fieldName) ;
  }
}
/**********************************************************************/
static void changeValueCB(network, clientData, callData)
  Widget	network ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay		this	      = (WeightDisplay)clientData ;
  NetworkReturnStruct	*returnStruct = (NetworkReturnStruct *)callData ;
  UnitDisplayRec	*unitPtr ;

  unitPtr = XtNetworkGetUnit(network, returnStruct->index) ;
  unitPtr->value *= this->maxValue ;
  changeLinkField(unitPtr, this->fieldIdx) ;
  updateNetActivities() ;
  notifyChange(DNStateChange) ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		setMiscellaneousCB
 *	Description:	
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - 
 *	  XtPointer	callData -
 *	Return Value:
 *	  static void	setMiscellaneousCB - 
 *********************************************************************/
static void	setMiscellaneousCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay		this   = (WeightDisplay)clientData ;
  MiscNetworkDialog	dialog = this->dialog ;
  Boolean		fixed ;
  int			size, margin ;
  float			maxValue ;
  String		string ;

  string = getText(dialog->maxValue) ;
  if (string != NULL) {
    maxValue = atof(string) ;
    this->maxValue = maxValue ;
  }

  XtVaGetValues(dialog->fixedMax, XtNstate, &fixed, NULL) ;
  if (this->fixedMax != fixed) {
    this->fixedMax = fixed ;
  }

  string = getText(dialog->size) ;
  if (string != NULL) {
    size = atol(string) ;
    setNetValue(MINOR_WIDTH,  &size) ;
    setNetValue(MINOR_HEIGHT, &size) ;
  }

  string = getText(dialog->border) ;
  if (string != NULL)
    this->border = atol(string) ;
  else
    this->border = -1 ;

  string = getText(dialog->margin) ;
  if (string != NULL) {
    margin = atol(string) ;
    setNetValue(MINOR_MARGIN,  &margin) ;
  }

  XtVaGetValues(dialog->fixedBlockHeight, XtNstate, &fixed, NULL) ;
  if (fixed) {
    string = getText(dialog->blockHeight) ;
    if (string != NULL) {
      size = atol(string) ;
      setNetValue(MAJOR_HEIGHT,  &size) ;
    }
  } else {
    displayFiddleLayout(FALSE, TRUE) ;
  }

  XtVaGetValues(dialog->fixedBlockWidth, XtNstate, &fixed, NULL) ;
  if (fixed) {
    string = getText(dialog->blockWidth) ;
    if (string != NULL) {
      size = atol(string) ;
      setNetValue(MAJOR_WIDTH,  &size) ;
    }
  } else {
    displayFiddleLayout(TRUE, FALSE) ;
  }

  string = getText(dialog->blockMargin) ;
  if (string != NULL) {
    size = atol(string) ;
    setNetValue(MAJOR_MARGIN,  &size) ;
  }

  this->state = DNDisplayChange ;
  reset(this) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		miscellaneousCB
 *	Description:	
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - 
 *	  XtPointer	callData - 
 *	Return Value:
 *	  static void	miscellaneousCB - 
 *********************************************************************/
static void	miscellaneousCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  int		size ;
  Boolean	fixedMax ;
  
  if (this->dialog == NULL) {
    MiscNetworkDialog	dialog ;
    Widget		form, button, table ;

    dialog = (MiscNetworkDialog)XtMalloc(sizeof(*dialog)) ;

    dialog->shell = XtVaCreatePopupShell("miscShell", 
				     transientShellWidgetClass, 
				     this->shell, NULL) ;
    XtAddCallback(dialog->shell, 
		  XtNdestroyCallback, destroyMiscCB, (XtPointer)this) ;

    form = XtVaCreateManagedWidget("form", 
				   formWidgetClass, dialog->shell, NULL) ;

    table = startTable(form) ;
    dialog->maxValue	= addTableItem("maxValue",    &table, TRUE) ;
    dialog->size	= addTableItem("size", 	      &table, FALSE) ;
    dialog->border	= addTableItem("border",      &table, FALSE) ;
    dialog->margin	= addTableItem("margin",      &table, FALSE) ;
    dialog->blockHeight	= addTableItem("blockHeight", &table, TRUE) ;
    dialog->blockWidth	= addTableItem("blockWidth",  &table, TRUE) ;
    dialog->blockMargin	= addTableItem("blockMargin", &table, FALSE) ;

    dialog->fixedMax    = XtNameToWidget(form, "maxValueToggle") ;
    dialog->fixedBlockWidth  = XtNameToWidget(form, "blockWidthToggle") ;
    dialog->fixedBlockHeight = XtNameToWidget(form, "blockHeightToggle") ;

    button = XtVaCreateManagedWidget("ok", commandWidgetClass, form,
				     XtNfromVert, dialog->blockMargin,
				     NULL) ;
    XtAddCallback(button, XtNcallback, setMiscellaneousCB, (XtPointer)this) ;
    XtAddCallback(button, XtNcallback, popdownWidgetCB,    (XtPointer)button) ;

    button = XtVaCreateManagedWidget("cancel", commandWidgetClass, form,
				     XtNfromVert,	dialog->blockMargin,
				     XtNfromHoriz,	button,
				     NULL) ;
    XtAddCallback(button, XtNcallback,
		  popdownWidgetCB, (XtPointer)dialog->shell) ;
    
    XtInstallAllAccelerators(form, form) ;
    this->dialog = dialog ;
  }

  if (netExists()) {
    fixedMax = this->fixedMax ;
    XtVaSetValues(this->dialog->fixedMax, XtNstate, fixedMax, NULL) ;
    
    widgetPrintf(this->dialog->maxValue, "%g", this->maxValue) ;

    getNetValue(MINOR_WIDTH, &size) ;
    widgetPrintf(this->dialog->size, "%d", size) ;

    widgetPrintf(this->dialog->border, "%d", this->border) ;

    getNetValue(MINOR_MARGIN, &size) ;
    widgetPrintf(this->dialog->margin, "%d", size) ;

    getNetValue(MAJOR_WIDTH, &size) ;
    widgetPrintf(this->dialog->blockWidth, "%d", size) ;

    getNetValue(MAJOR_HEIGHT, &size) ;
    widgetPrintf(this->dialog->blockHeight, "%d", size) ;

    getNetValue(MAJOR_MARGIN, &size) ;
    widgetPrintf(this->dialog->blockMargin, "%d", size) ;
  }

  popupCentered(this->dialog->shell, XtGrabExclusive) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		destroyMiscCB
 *	Description:	destroys the WeightDisplay
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - the WeightDisplay
 *	  XtPointer	callData - 
 *	Return Value:
 *	  static void	destroyMiscCB - 
 *********************************************************************/
static void	destroyMiscCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  WeightDisplay	this = (WeightDisplay)clientData ;
  if (this == NULL)
    return ;

  if (this->dialog)
    XtFree((void *)this->dialog) ;
}
/********************************************************************/
