
/**********************************************************************
 * $Id: outputCommand.h,v 1.2 92/11/30 11:29:02 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __xerion_outputCommand_h
#define __xerion_outputCommand_h

/***********************************************************************
 * Useful (and necessary) typedefs, enums, etc.
 */
typedef struct OutputCommandRec  *OutputCommand ; 
typedef String	(*SuffixProc)	ARGS((OutputCommand, void *)) ;

/***********************************************************************
 * The OutputCommand object
 */
typedef struct OutputCommandRec {
  String	commandString ;
  String	fileNameString ;
  String	trace ;
  int		interval ;
  String	commandFormat ;
  String	fileBaseName ;
  SuffixProc	suffix ;
  void		*suffixData ;

  void		(*destroy)	 ARGS((OutputCommand)) ;
  int		(*output)	 ARGS((OutputCommand)) ;
  String	(*command)	 ARGS((OutputCommand)) ;
  String	(*fileName)	 ARGS((OutputCommand)) ;
  String	(*setCommand)	 ARGS((OutputCommand, String)) ;
  String	(*setFile)	 ARGS((OutputCommand, String)) ;
  String	(*setTrace)	 ARGS((OutputCommand, String)) ;
  int		(*setInterval)	 ARGS((OutputCommand, int)) ;
  String	(*setSuffixProc) ARGS((OutputCommand, SuffixProc, void *)) ;

} OutputCommandRec ;

/**********************************************************************
 * Creation functions for the OutputCommand object
 */
extern OutputCommand	createOutputCommand ARGS((String, String, String)) ;

/***********************************************************************
 * Methods for the OutputCommand object
 */
#define MOCdestroy(o)		((o)->destroy(o))
#define MOCoutput(o)		((o)->output(o))
/**********************************************************************/
#define MOCcommand(o)		((o)->command(o))
#define MOCfileName(o)		((o)->fileName(o))
#define MOCtrace(o)		((o)->trace)
#define MOCinterval(o)		((o)->interval)
#define MOCcommandString(o)	((o)->commandFormat)
#define MOCfileBaseName(o)	((o)->fileBaseName)
#define MOCsuffix(o)		((o)->suffix ? \
				 (o)->suffix(o, (o)->suffixData) : NULL)
/**********************************************************************/
#define MOCsetCommand(o,f)	((o)->setCommand(o,f))
#define MOCsetFile(o,f)		((o)->setFile(o,f))
#define MOCsetTrace(o,f)	((o)->setTrace(o,f))
#define MOCsetInterval(o,f)	((o)->setInterval(o,f))
#define MOCsetSuffixProc(o,p,d)	((o)->setSuffixProc(o,p,d))
/**********************************************************************/
#endif				/* __xerion_outputCommand_h */
