
/**********************************************************************
 * $Id: objectDisplay.h,v 1.2 92/11/30 11:29:00 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __bp_objectdisplay_h
#define __bp_objectdisplay_h

typedef struct ObjectDisplayRec	*ObjectDisplay ;
typedef struct ObjectDisplayRec {
  String	objectName ;
  String	objectType ;
  String	*fieldList ;
  Widget	label ;
  Widget	form ;
  Widget	save ;
  Widget	*value ;

  void		(*changeName) ARGS((ObjectDisplay, String name)) ;
  void		(*reset)      ARGS((ObjectDisplay)) ;
  void		(*saveAll)    ARGS((ObjectDisplay)) ;
  void		(*saveValue)  ARGS((ObjectDisplay, String name)) ;
} ObjectDisplayRec ;

/***********************************************************************
 * Methods
 */
#define MODchangeName(o,s)	((o)->changeName(o,s))
#define MODreset(o)		((o)->reset(o))
#define MODsaveAll(o)		((o)->saveAll(o))

/***********************************************************************
 * Utilities
 */
extern ObjectDisplay createObjectDisplay ARGS((String name, Widget parent)) ;

/**********************************************************************/
#endif				/* __bp_objectdisplay_h */

