
/**********************************************************************
 * $Id: objectDisplay.c,v 1.3 92/11/30 11:28:58 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Viewport.h>

#include <xerion/display.h>
#include <xerion/displayUtils.h>
#include <xerion/display2Itf.h>
#include <xerion/display2Sim.h>

#include <xerion/useful.h>
#include "objectDisplay.h"

typedef struct ODCBDataRec {
  ObjectDisplay	objectDisplay ;
  int		fieldIdx ;
} ODCBDataRec, *ODCBData ;

static void	destroy		ARGS((ObjectDisplay)) ;
static void	changeName	ARGS((ObjectDisplay, String)) ;
static void	reset		ARGS((ObjectDisplay)) ;
static void	saveAll		ARGS((ObjectDisplay)) ;

static void	destroyCB	ARGS((Widget, XtPointer, XtPointer)) ;
static void	saveAllCB	ARGS((Widget, XtPointer, XtPointer)) ;
static void	followCB	ARGS((Widget, XtPointer, XtPointer)) ;
static void	backCB		ARGS((Widget, XtPointer, XtPointer)) ;
static void	helpCB		ARGS((Widget, XtPointer, XtPointer)) ;
static void	followArrayCB   ARGS((Widget, XtPointer, XtPointer)) ;
static void	freeDataCB	ARGS((Widget, XtPointer, XtPointer)) ;

static int	compare		ARGS((const void *, const void *)) ;
static void	buildWidgets	ARGS((ObjectDisplay)) ;
static void	buildMenu	ARGS((ObjectDisplay, int, Widget)) ;
static void	createFieldList	ARGS((ObjectDisplay)) ;
static String	getFieldName	ARGS((ObjectDisplay, int)) ;
static String	getFieldTypeName ARGS((ObjectDisplay, int)) ;
  
static void 	helpAction ARGS((Widget, XEvent *, String *, Cardinal *)) ;
static void	showHelp   ARGS((String name)) ;

static Boolean		actionsAdded = FALSE ;
static XtActionsRec	actions[] = {
  {"Help", 		helpAction}
} ;

/********************************************************************/
export ObjectDisplay	createObjectDisplay(name, parent)
  String	name ;
  Widget	parent ;
{
  ObjectDisplay	this ;
  Widget	form, viewport, button  ;

  if (parent == NULL)
    return NULL ;

  this = (ObjectDisplay)XtCalloc(1, sizeof(ObjectDisplayRec)) ;
  if (this == NULL)
    return NULL ;

  if (!actionsAdded) {
    XtAppContext	appContext = XtWidgetToApplicationContext(parent) ;
    XtAppAddActions(appContext, actions, XtNumber(actions)) ;
    actionsAdded = TRUE ;
  }

  form = XtVaCreateManagedWidget("objectDisplayForm", formWidgetClass, parent,
				 NULL) ;
  XtAddCallback(form, XtNdestroyCallback, destroyCB, (XtPointer)this) ;

  this->label = XtVaCreateManagedWidget("fieldLabel", 
					asciiTextWidgetClass, form,
					XtNtype,	XawAsciiString,
					XtNeditType,	XawtextEdit,
					NULL) ; 
  viewport    = XtVaCreateManagedWidget("viewport", viewportWidgetClass, form,
					NULL) ;
  this->form  = XtVaCreateManagedWidget("form", formWidgetClass, viewport,
					NULL) ;

  button = XtVaCreateManagedWidget("save", commandWidgetClass, form, NULL) ;
  XtAddCallback(button, XtNcallback, saveAllCB, (XtPointer)this) ;
  this->save = button ;

  button = XtVaCreateManagedWidget("back", commandWidgetClass, form, NULL) ;
  XtAddCallback(button, XtNcallback, backCB,   (XtPointer)this) ;

  button = XtVaCreateManagedWidget("help", commandWidgetClass, form, NULL) ;
  XtAddCallback(button, XtNcallback, helpCB,   (XtPointer)this) ;

  this->fieldList  = NULL ;
  this->value	   = NULL ;
  this->changeName = changeName ;
  this->reset	   = reset ;
  this->saveAll	   = saveAll ;
  this->objectType = NULL ;
  if (name == NULL)
    this->objectName = XtNewString("junk") ;
  else
    this->objectName = NULL ; 

  MODchangeName(this, name) ;

  return this ;
}
/********************************************************************/
static void	buildWidgets(this)
  ObjectDisplay	this ;
{
  Widget	parent, lastLabel, label, value ;
  int		idx ;

  parent = XtParent(this->form) ;
  XtDestroyWidget(this->form) ;

  if (this->fieldList) {
    for (idx = 0 ; this->fieldList[idx] ; ++idx)
      XtFree((void *)this->fieldList[idx]) ;
    XtFree((void *)this->fieldList) ;
  }

  if (this->value)
    XtFree((void *)this->value) ;

  /* list the fields and allocate lists */
  createFieldList(this) ;

  for (idx = 0 ; this->fieldList && this->fieldList[idx] ; ++idx)
    ;
  if (idx) {
    qsort(this->fieldList, idx, sizeof(String), compare) ;
    this->value = (Widget *)XtCalloc(idx, sizeof(Widget)) ;
  }

  /* make items: 	command for struct
   *			menuButton for array
   *			label for readonly
   *			text for everything else
   */
  this->form = XtVaCreateWidget("form", formWidgetClass, parent, NULL) ;

  lastLabel = NULL ;
  for (idx = 0 ; this->fieldList && this->fieldList[idx] ; ++idx) {
    String	name = getFieldTypeName(this, idx) ;
#if 0
    if (!IIsVisible(name))
      continue ;
#endif
    label = XtVaCreateManagedWidget(this->fieldList[idx],
				    labelWidgetClass, this->form,
				    NULL) ;
    if (IIsArrayObject(name)) {
      value = XtVaCreateManagedWidget("value",
				      menuButtonWidgetClass, this->form,
				      XtNmenuName,	"arrayMenu",
				      NULL) ;
      buildMenu(this, idx, value) ;
    } else if (IIsStructure(name)) {
      ODCBData	data = XtNew(ODCBDataRec) ;
      data->objectDisplay = this ;
      data->fieldIdx      = idx ;
      value = XtVaCreateManagedWidget("value", commandWidgetClass, this->form,
				      NULL) ;
      XtAddCallback(value, XtNcallback,        followCB,   (XtPointer)data) ;
      XtAddCallback(value, XtNdestroyCallback, freeDataCB, (XtPointer)data) ;
    } else if (IIsReadonly(name)) {
      value = XtVaCreateManagedWidget("value", labelWidgetClass, this->form,
				      NULL) ;
    } else {
      value = XtVaCreateManagedWidget("value",
				      asciiTextWidgetClass, this->form,
				      XtNtype,		XawAsciiString,
				      XtNeditType,	XawtextEdit,
				      NULL) ;
    }

    XtVaSetValues(value, XtNfromHoriz, label, NULL) ;
    if (lastLabel) {
      XtVaSetValues(label, XtNfromVert, lastLabel, NULL) ;
      XtVaSetValues(value, XtNfromVert, lastLabel, NULL) ;
    } 
    this->value[idx] = value ;
    lastLabel	     = label ;
  }

  if (lastLabel == NULL) {
    label = XtVaCreateManagedWidget("empty", labelWidgetClass, this->form,
				    NULL) ;
    value = XtVaCreateManagedWidget("emptyValue", labelWidgetClass, this->form,
				    NULL) ;
    XtVaSetValues(value, XtNfromHoriz, label, NULL) ;
  }

  XtInstallAccelerators(this->form, this->save) ;
  if (this->fieldList && this->value) {
    for (idx = 0 ; this->fieldList[idx] ; ++idx)
      if (this->value[idx])
	XtInstallAccelerators(this->value[idx], this->save) ;
  }

  XtManageChild(this->form) ;
}
/********************************************************************/
static void	buildMenu(this, fieldIdx, parent)
  ObjectDisplay	this ;
  int		fieldIdx ;
  Widget	parent ;
{
  Widget	menu, item ;
  int		bound, idx ; ;

  if (!XtIsSubclass(parent, menuButtonWidgetClass))
    return ;

  menu = XtVaCreatePopupShell("arrayMenu", simpleMenuWidgetClass, parent,
			      NULL) ;
  bound = IArrayObjectBound(getFieldName(this, fieldIdx)) ;

  if (bound <= 0) {
    item = XtVaCreateManagedWidget("empty", smeBSBObjectClass, menu, 
				   NULL) ;
  } else {
    ODCBData	data = XtNew(ODCBDataRec) ;
    char	string[128] ;

    data->objectDisplay = this ;
    data->fieldIdx      = fieldIdx ;
    for (idx = 0 ; idx < bound ; ++idx) {
      sprintf(string, "Number %d", idx) ;
      item = XtVaCreateManagedWidget(string, smeBSBObjectClass, menu, 
				     NULL) ;
      XtAddCallback(item, XtNcallback, followArrayCB, (XtPointer)data) ;
    }
    XtAddCallback(menu, XtNdestroyCallback, freeDataCB, (XtPointer)data) ;
  }
}
/********************************************************************/
static int	compare(ptr1, ptr2)
  const	void	*ptr1 ;
  const	void	*ptr2 ;
{
  return strcmp(*(String *)ptr1, *(String *)ptr2) ;
}
/********************************************************************/


/********************************************************************/
static void	destroyCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  destroy((ObjectDisplay)clientData) ;
}
/********************************************************************/
static void	destroy(this)
  ObjectDisplay	this ;
{
  if (this == NULL)
    return ;

  if (this->objectName)
    XtFree((void *)this->objectName) ;
  if (this->objectType)
    XtFree((void *)this->objectType) ;
  if (this->value)
    XtFree((void *)this->value) ;

  if (this->fieldList) {
    int	idx ;
    for (idx = 0 ; this->fieldList[idx] ; ++idx)
      XtFree((void *)this->fieldList[idx]) ;
    XtFree((void *)this->fieldList) ;
  }

  XtFree((void *)this) ;
}
/********************************************************************/


/********************************************************************/
static void	changeName(this, name)
  ObjectDisplay	this ;
  String	name ;
{
  String	type ;

  if ((name == NULL && this->objectName == NULL)
      || (name && this->objectName && strcmp(name, this->objectName) == 0))
    return ;

  type = name ? IGetObjectTypeName(name) : NULL ;

  if (this->objectName)
    XtFree((void *)this->objectName) ;
  this->objectName = name ? strdup(name) : NULL ;

  if (this->objectType)
    XtFree((void *)this->objectType) ;
  this->objectType = type ? strdup(type) : NULL ;

  MODreset(this) ;
}
/********************************************************************/


/********************************************************************/
static void	reset(this)
  ObjectDisplay	this ;
{
  String	name ;
  int		idx ;

  buildWidgets(this) ;

  if (this->objectName == NULL)
    widgetPrintf(this->label, "All") ;
  else
    widgetPrintf(this->label, this->objectName) ;

  if (this->objectName && IIsNULL(this->objectName))
    XtSetSensitive(this->form, FALSE) ;
  else
    XtSetSensitive(this->form, TRUE) ;

  for (idx = 0 ; this->fieldList[idx] ; ++idx) {
    if (this->value[idx] == NULL)
      continue ;

    name = getFieldName(this, idx) ;

    if (XtIsSubclass(this->value[idx], menuButtonWidgetClass))
      widgetPrintf(this->value[idx], "array %s", IGetObjectTypeName(name)) ;
    else if (XtIsSubclass(this->value[idx], commandWidgetClass))
      widgetPrintf(this->value[idx], "struct %s", IGetObjectTypeName(name)) ;
    else if (XtIsSubclass(this->value[idx], labelWidgetClass))
      widgetPrintf(this->value[idx], "%s", getSimpleObjectValue(name, NULL)) ;
    else
      widgetPrintf(this->value[idx], "%s", getSimpleObjectValue(name, NULL)) ;
  }
}
/********************************************************************/
static void	followCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  ODCBData	data = (ODCBData)clientData ;
  ObjectDisplay	this = data->objectDisplay ;

  MODchangeName(this, getFieldName(this, data->fieldIdx)) ;
}
/********************************************************************/
static void	followArrayCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  ODCBData	data = (ODCBData)clientData ;
  ObjectDisplay	this = data->objectDisplay ;
  char		*fieldName, name[256] ;
  int		arrayIdx ;

  sscanf(XtName(widget), "Number %d", &arrayIdx) ;

  fieldName = getFieldName(this, data->fieldIdx) ;
  sprintf(name, "%s[%d]", fieldName, arrayIdx) ;

  MODchangeName(this, name) ;
}
/********************************************************************/
static void	backCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  ObjectDisplay	this = (ObjectDisplay)clientData ;
  char		name[256], *ptr ;
  int		length ;

  if (this->objectName == NULL)
    return ;

  ptr = strrchr(this->objectName, '.') ;
  if (ptr) {
    length = ptr - this->objectName ;
    strncpy(name, this->objectName, length) ;
    name[length] = '\0' ;
    ptr = name ;
  } 
  MODchangeName(this, ptr) ;
}
/********************************************************************/


/********************************************************************/
static void	saveAll(this)
  ObjectDisplay	this ;
{
  String	value, oldValue, name ;
  int		idx ;

  for (idx = 0 ; this->fieldList[idx] ; ++idx) {
    if (this->value[idx] == NULL
	|| XtIsSubclass(this->value[idx], commandWidgetClass))
      continue ;

    name     = getFieldName(this, idx) ;
    oldValue = getSimpleObjectValue(name, NULL) ;

    if (XtIsSubclass(this->value[idx], labelWidgetClass))
      value = getLabel(this->value[idx]) ;
    else
      value = getText(this->value[idx]) ;

    if (strcmp(oldValue, value))
      saveSimpleObjectValue(name, value) ;

    if (XtIsSubclass(this->value[idx], labelWidgetClass))
      XtFree((void *)value) ;

    value = getSimpleObjectValue(name, NULL) ;
    if (XtIsSubclass(this->value[idx], labelWidgetClass))
      widgetPrintf(this->value[idx], value) ;
    else
      widgetPrintf(this->value[idx], value) ;
  }
}
/********************************************************************/
static void	saveAllCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  MODsaveAll((ObjectDisplay)clientData) ;
}
/********************************************************************/
static void	freeDataCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  XtFree(clientData) ;
}
/********************************************************************/

/********************************************************************/
static String	getFieldName(this, idx)
  ObjectDisplay this ;
  int		idx ;
{
  static char	name[BUFSIZ] ;

  if (this->fieldList == NULL || this->fieldList[idx] == NULL)
    return NULL ;

  if (this->objectType == NULL)
    sprintf(name, "%s", this->fieldList[idx]) ;
  else if (this->objectType && IIsStructure(this->objectType))
    sprintf(name, "%s.%s", this->objectName, this->fieldList[idx]) ;
  else 
    sprintf(name, "%s", this->objectName) ;

  return name ;
}
/********************************************************************/

/********************************************************************/
static String	getFieldTypeName(this, idx)
  ObjectDisplay this ;
  int		idx ;
{
  static char	name[BUFSIZ] ;

  if (this->fieldList == NULL || this->fieldList[idx] == NULL)
    return NULL ;

  if (this->objectType == NULL)
    sprintf(name, "%s", this->fieldList[idx]) ;
  else if (this->objectType && IIsStructure(this->objectType))
    sprintf(name, "%s.%s", this->objectType, this->fieldList[idx]) ;
  else 
    sprintf(name, "%s", this->objectName) ;

  return name ;
}
/********************************************************************/

/********************************************************************/
static void	createFieldList(this)
  ObjectDisplay	this ;
{
  if (this->objectType == NULL) {
    String	*fieldList = listAllObjectNames() ;
    int		idx ;
    for (idx = 0 ; fieldList && fieldList[idx] ; ++idx)
      ;
    this->fieldList = (String *)XtCalloc(idx + 1, sizeof(String)) ;
    for (idx = 0 ; fieldList && fieldList[idx] ; ++idx)
      this->fieldList[idx] = strdup(fieldList[idx]) ;
  } else if (IIsStructure(this->objectType)) {
    this->fieldList  = IListStructFields(this->objectType,FALSE) ;
  } else {
    this->fieldList = (String *)XtCalloc(2, sizeof(String)) ;
    this->fieldList[0] = strdup("") ;
  }
}
/********************************************************************/
static void 	helpAction(w, event, params, numParams)
  Widget	w ;
  XEvent	*event ;
  String	*params ;
  Cardinal	*numParams ;
{
  if (*numParams > 0) {
    int	idx ;
    for (idx = 0 ; idx < *numParams ; ++idx)
      showHelp(params[idx]) ;
  } else {
    String	name ;
    if (XtIsSubclass(w, labelWidgetClass) && (name = getLabel(w))) {
      showHelp(name) ;
      XtFree(name) ;
    } else if (XtIsSubclass(w, textWidgetClass) && (name = getText(w))) {
      showHelp(name) ;
    } else {
      fprintf(dout, "Place pointer on name of object you want help on.\n") ;
    }
  }
}
/********************************************************************/
static void	showHelp(name)
  String	name ;
{
  char			**helpStrings = getHelpStrings(name) ;

  fprintf(dout, "\n%s:\n", name) ;
  if (helpStrings != NULL) {
    while (*helpStrings != NULL)
      fprintf(dout, "%s\n", *helpStrings++);
  } else {
    fprintf(dout, "Sorry, no help available\n") ;
  }
}
/********************************************************************/
static void	helpCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  fprintf(dout, 
	  "Press \"F1\" on the label of the object for which you want help.\n") ;
}
/********************************************************************/
