
/**********************************************************************
 * $Id: groupDisplay.h,v 1.2 92/11/30 11:28:49 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __bp_groupdisplay_h
#define __bp_groupdisplay_h

/* if we haven't included the widget stuff, we won't understand what a
 * widget is */
#ifndef _XtIntrinsic_h
typedef void 		*Widget ;
#endif

/***********************************************************************
 * Useful (and necessary) typedefs, enums, etc.
 */
typedef struct GroupDisplay  *GroupDisplay ; 
typedef struct GroupMaskSet  *GroupMaskSet ; 

typedef struct GroupMaskSetP *GroupMaskSetP ; 

typedef void	(*GMSCallback) ARGS((GroupMaskSet, Mask,  void *)) ;
typedef void	(*GDCallback)  ARGS((GroupDisplay, Group, void *)) ;

typedef enum GMSSetType { 
  GMSOneOfMany, GMSNOfMany, GMSReadOnly 
} GMSSetType ;

typedef enum GMSCallbackType { 
  GMSSelect, GMSUnselect
} GMSCallbackType ;

typedef enum GDCMType { 
  GDNone, GDSumSquare, GDMixture, GDUnknown /* GDUnknown *MUST* be last */
} GDCMType ;

typedef enum GDCallbackType { 
  GDSelect
} GDCallbackType ;

/**********************************************************************
 * Cost model sub display structure
 */
typedef struct CostModelDisplayRec {
  Widget	label ;		/* label showing highlighted cost model */
  Widget	option[3] ;	/* popup menu items */
  GDCMType	highlighted ;	/* which one is highlighted */
  int		numGaussians ;	/* number of gaussians (if mixture model) */
  Widget	query ;		/* query to get the number of gaussians */
} CostModelDisplayRec, *CostModelDisplay ; 

/***********************
 * and methods
 */
#define MGDCMlabel(c)			((c)->label)
#define MGDCMoptionArray(c)		((c)->option)
#define MGDCMoption(c,i)		(*(MGDCMoptionArray(c) + i))
#define MGDCMnumOptions(c)		(XtNumber(MGDCMoptionArray(c)))
#define MGDCMhighlighted(c)		((c)->highlighted)
#define MGDCMnumGaussians(c)		((c)->numGaussians)
#define MGDCMquery(c)			((c)->query)

#define MGDCMsetLabel(c,w)		(MGDCMlabel(c) = (w))
#define MGDCMsetOptionArray(c,a)	(MGDCMoptionArray(c) = (a))
#define MGDCMsetOption(c,i,w)		(MGDCMoption(c,i) = (w))
#define MGDCMsetHighlighted(c,t)	(MGDCMhighlighted(c) = (t))
#define MGDCMsetNumGaussians(c,n)	(MGDCMnumGaussians(c) = (n))
#define MGDCMsetQuery(c,w)		(MGDCMquery(c) = (w))

/***********************************************************************
 * The GroupMaskSet object
 */
typedef struct GroupMaskSet {
  String	name ;
  GroupDisplay	parent ;
  GMSSetType	type ;	

  Mask		mask ;
  Mask		highlightedMask ;
  Mask		sensitiveMask ;

  GMSCallback	callback[2] ;
  void		*callbackData[2] ;

  /* Widget stuff */
  Widget	 menuButton ;	/* menu button for options */
  Widget	 label ;	/* label listing highlighted masks */
  Widget	 *toggle ;	/* widget for each mask, NULL terminated */
  Mask		 *toggleMask ;	/* corresponding masks */

  /* Methods */
  void		(*destroy)	ARGS((GroupMaskSet)) ;      
  Mask		(*highlight)	ARGS((GroupMaskSet, Mask)) ;
  Mask		(*unhighlight)	ARGS((GroupMaskSet, Mask)) ;
  Mask		(*sensitize)	ARGS((GroupMaskSet, Mask)) ;
  Mask		(*insensitize)	ARGS((GroupMaskSet, Mask)) ;
  void		(*setCallback)	ARGS((GroupMaskSet, GMSCallbackType,
				      GMSCallback, void *)) ; 
} GroupMaskSetRec ;

/***********************************************************************
 * The GroupDisplay object
 */
typedef struct GroupDisplay {
  String	name ;		/* name of the object */
  Group		group ;		/* selected group to (changes frequently) */
  GroupMaskSet	*maskSet ;	/* mask sets, NULL terminated */

  GDCallback	callback[1] ;	   /* callback for selecting a group */
  void		*callbackData[1] ; /* data passed to callback */

  /* Widget stuff */
  Widget	shell ;		/* shell holding everything */
  String	titleFormat ; 	/* title format string */
  Widget	selection ;	/* selection holding the list */
  String	*list ;		/* list of all available groups */

  CostModelDisplayRec groupCostModel ;	/* cost model stuff */
  CostModelDisplayRec netCostModel ; 	/* cost model stuff */

  /* Methods */
  void		(*destroy)	ARGS((GroupDisplay)) ;	
  void		(*addMaskSet)	ARGS((GroupDisplay, GroupMaskSet)) ;
  void		(*setCallback)	ARGS((GroupDisplay, GDCallbackType,
				      GDCallback, void *)) ; 
} GroupDisplayRec ;


/**********************************************************************
 * Creation functions for the GroupDisplay and the GroupMaskSet
 */
extern GroupDisplay	createGroupDisplay ARGS((String)) ;
extern GroupMaskSet	createGroupMaskSet ARGS((String, GroupDisplay, 
						 Mask, GMSSetType)) ;

/***********************************************************************
 * Methods for both the GroupDisplay and the GroupMaskSet
 */
#define MGDname(g)		((g)->name)
#define MGDdestroy(g)		((g)->destroy(g))
#define MGDsetCallback(g,t,c,d)	((g)->setCallback(g,t,c,d))

/***********************************************************************
 * Public methods for the GroupDisplay
 */
#define MGDgroup(g)		((g)->group)
#define MGDaddMaskSet(g,m)	((g)->addMaskSet(g,m))
#define MGDmaskSet(g,i)		((g)->maskSet[i])

/***********************************************************************
 * Public for the GroupMaskSet
 */
#define MGDparent(g)		((g)->parent)
#define MGDmask(g)		((g)->mask)
#define MGDtype(g)		((g)->type)
#define MGDhighlighted(g)	((g)->highlightedMask)
#define MGDunhighlighted(g)	(MGDmask(g) & ~MGDhighlighted(g))
#define MGDsensitive(g)		((g)->sensitiveMask)
#define MGDinsensitive(g)	(MGDmask(g) & ~MGDsensitive(g))
#define MGDhighlight(g,m)	((g)->highlight(g,m))
#define MGDunhighlight(g,m)	((g)->unhighlight(g,m))
#define MGDsensitize(g,m)	((g)->sensitize(g,m))
#define MGDinsensitize(g,m)	((g)->insensitize(g,m))

/***********************************************************************
 * Private methods for the GroupMaskSet
 */
#define MGDlabel(g)			((g)->label)
#define MGDmenuButton(g)		((g)->menuButton)
#define MGDtoggleArray(g)		((g)->toggle)
#define MGDtoggleMaskArray(g)		((g)->toggleMask)
#define MGDnumToggles(g)		((g)->numToggles)
#define MGDtoggle(g,i)			(*(MGDtoggleArray(g) + (i)))
#define MGDtoggleMask(g,i)		(*(MGDtoggleMaskArray(g) + (i)))

#define MGDsetLabel(g, w)		(MGDlabel(g) = (w))
#define MGDsetMenuButton(g, w)		(MGDmenuButton(g) = (w))
#define MGDsetNumToggles(g,n)		(MGDnumToggles(g) = (n))
#define MGDsetToggle(g,i,w)		(MGDtoggle(g,i) = (w))
#define MGDsetToggleMask(g,i,m)		(MGDtoggleMask(g,i) = (m))
#define MGDsetToggleArray(g,p)		(MGDtoggleArray(g) = (p))
#define MGDsetToggleMaskArray(g,p)	(MGDtoggleMaskArray(g) = (p))

/***********************************************************************
 * Private methods for the GroupDisplay
 */
#define MGDgroupCostModel(g)		(&((g)->groupCostModel))
#define MGDnetCostModel(g)		(&((g)->netCostModel))
#define MGDshell(g)			((g)->shell)
#define MGDtitleFormat(g)		((g)->titleFormat)
#define MGDgroupSelection(g)		((g)->selection)
#define MGDgroupList(g)			((g)->list)
#define MGDsetShell(g,w)		(MGDshell(g) = (w)) 
#define MGDsetTitleFormat(g,s)		(MGDtitleFormat(g) = (s))
#define MGDsetGroupSelection(g,w)	(MGDgroupSelection(g) = (w))
#define MGDsetGroupList(g,l)		(MGDgroupList(g) = (l))

/***********************************************************************
 * Utilities
 */
extern GroupDisplay	groupDisplayFromName ARGS((String name)) ;

/**********************************************************************/
#endif				/* __bp_groupdisplay_h */

