
/**********************************************************************
 * $Id: displayUtils.h,v 1.8 93/01/15 11:02:27 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef DISPLAY_UTILS_INCLUDED
#define DISPLAY_UTILS_INCLUDED

#define labelPrintf	widgetPrintf
#define textPrintf	widgetPrintf
#define titlePrintf	widgetPrintf

#ifndef __displayUtils_c_
extern int	widgetPrintf  ARGS((Widget, char *format, ...)) ;
#endif

extern String	widgetGetText ARGS((Widget, char *buffer, int size)) ;

extern char	*getTitle ARGS((Widget widget)) ;
extern char	*getLabel ARGS((Widget widget)) ;
extern char	*getText  ARGS((Widget widget)) ;

extern Widget	addTableItem() ;
extern Widget	startTable() ;

extern int	popupInterruptDialog   ARGS((Widget widget)) ;
extern void	popdownInterruptDialog ARGS((int id)) ;

extern void	popupCenteredCB	 ARGS((Widget, XtPointer, XtPointer)) ;
extern void	popupCentered    ARGS((Widget, XtGrabKind)) ;
extern void	popdownWidgetCB  ARGS((Widget, XtPointer, XtPointer)) ;

extern void	redirectKeyboardInput ARGS((Widget widget)) ;

extern void	checkMenuItem	ARGS((Widget, int state)) ;

extern void	 storeData	ARGS((Widget widget, XtPointer data)) ;
extern XtPointer retrieveData	ARGS((Widget widget)) ;

#endif				/* DISPLAY_UTILS_INCLUDED */
