
/**********************************************************************
 * $Id: display2Sim.h,v 1.6 92/11/30 11:28:41 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef DISPLAY2SIM_H
#define DISPLAY2SIM_H

/**********************************************************************
 *	HACK: had to redefine what a UnitRec is here so that
 *	this doesn't need all the X include files as well
 **********************************************************************/
#ifndef _Network_h
typedef struct _UnitDisplayRec {
  int	row ;
  int	column ;
  float value ;
  void	*userData ;
} UnitDisplayRec ;
#endif

#define ACTIVATION_WIDTH	((int)0x0001)
#define ACTIVATION_HEIGHT	((int)0x0002)
#define ACTIVATION_MARGIN	((int)0x0003)
#define MINOR_WIDTH		((int)0x0004)
#define MINOR_HEIGHT		((int)0x0005)
#define MINOR_MARGIN		((int)0x0006)
#define MAJOR_WIDTH		((int)0x0007)
#define MAJOR_HEIGHT		((int)0x0008)
#define MAJOR_MARGIN		((int)0x0009)
#define CURRENT_TIME		((int)0x000a)
#define TIME_SLICES		((int)0x000b)
#define NAME			((int)0x000c)
#define SELF			((int)0x000d)
#define BATCH_SIZE		((int)0x000e)

extern char	**listExamples     ARGS((int	idx)) ;
extern char	**listExampleSets  ARGS((void)) ;
extern String	*(*listLinkFields) ARGS((void)) ;

extern char	**listNetParams      ARGS((void)) ;
extern char	**listNetParamsShort ARGS((void)) ;
extern char	*netParamLongName    ARGS((char	*shortName)) ;

extern char	**listMinimizeParams      ARGS((void)) ;
extern char	**listMinimizeParamsShort ARGS((void)) ;
extern char	*minimizeParamLongName    ARGS((char	*shortName)) ;

extern int	doExample       ARGS((int setIndex, int	exampleIndex)) ;
extern int	getExampleIndex ARGS((int setIdx)) ;
extern void	changeUnitValue ARGS((UnitDisplayRec *, int fieldIdx)) ;
extern void	changeTarget    ARGS((UnitDisplayRec *)) ;
extern void	moveUnit        ARGS((UnitDisplayRec *)) ;
extern int	updateNetActivities ARGS(()) ;

extern int	netExists   ARGS((void)) ;
extern Boolean	getNetValue ARGS((int, void *)) ;
extern Boolean	setNetValue ARGS((int, void *)) ;

extern int	getWeightParams    ARGS((int, double *, double *, double *)) ;
extern void	changeLinkField    ARGS((UnitDisplayRec *, int)) ;
extern int	getNumberOfUnits   ARGS((void)) ;
extern void	displayForAllUnits ARGS((void  (*proc)(), void  *data)) ;
extern int	getUnitMajorRow    ARGS(()) ;
extern int	getUnitMajorColumn ARGS(()) ;
extern UnitDisplayRec	*getFanIn  ARGS((int mask, UnitDisplayRec **, int *)) ;


extern String		*(*listUnitFields) ARGS((void)) ;
extern UnitDisplayRec	*getUnitValues ARGS((int fieldIdx, 
					     UnitDisplayRec *arrayPtr,
					     int	    *numPtr,
					     int	    *maxPtr)) ;
extern UnitDisplayRec	*getNetworkTargets ARGS((UnitDisplayRec	*arrayPtr,
						 int		*numPtr,
						 int		*maxPtr)) ;

extern int	setNetTime ARGS((int newTime)) ;
extern int	incrementNetTime ARGS(()) ;
extern void	displayFiddleLayout ARGS((int, int)) ;

#endif				/* DISPLAY2SIM_H */
