
/**********************************************************************
 * $Id: display.h,v 1.6 93/01/11 11:19:41 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef DISPLAY_INCLUDED
#define DISPLAY_INCLUDED

#include <xerion/config.h>

#include <stdio.h>
#include <assert.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

/**********************************************************************
 * Useful definitions
 **********************************************************************/
#define private	static
#define import	extern
#define export

#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define MIN(x, y)	((x) < (y) ? (x) : (y))
/**********************************************************************/


/**********************************************************************
 * Macros for settting widget Arguments.
 * If MAX_WIDGET_ARGS isn't enough to hold all the arguments you pass any Xt
 * procedure, the program asserts
 **********************************************************************/
#ifdef XERION_BC
#define MAX_WIDGET_ARGS 32

static Cardinal	NumWidgetArgs ;
static Arg	WidgetArgs[MAX_WIDGET_ARGS] ;

#define startArgs()		NumWidgetArgs = 0

#define setArg(name, value)	{   	\
  assert(NumWidgetArgs < MAX_WIDGET_ARGS) ; \
  XtSetArg(WidgetArgs[NumWidgetArgs], name, value),  NumWidgetArgs++ ; }

#define setValues(widget)      XtSetValues((widget), WidgetArgs, NumWidgetArgs)
#define getValues(widget)      XtGetValues((widget), WidgetArgs, NumWidgetArgs)

#define createManagedWidget(name, class, parent)	\
  XtCreateManagedWidget((name), (class), (parent), WidgetArgs, NumWidgetArgs)

#define createWidget(name, class, parent)	\
  XtCreateWidget((name), (class), (parent), WidgetArgs, NumWidgetArgs)

#define createPopupShell(name, class, parent)	\
  XtCreatePopupShell((name), (class), (parent), WidgetArgs, NumWidgetArgs)

#define createAppShell(name, className, class, display)	\
  XtAppCreateShell((name), (className), (class), (display), \
		   WidgetArgs, NumWidgetArgs)

#endif /* XERION_BC */
/**********************************************************************/


/**********************************************************************
 * Macros for accessing event fields
 **********************************************************************/
#define E_x(e)		((e)->x)
#define E_y(e)		((e)->y)
#define E_width(e)	((e)->width)
#define E_height(e)	((e)->height)
/**********************************************************************/


/**********************************************************************
 * Top level widget for the graphics application. 
 * Defined in display.c
 **********************************************************************/
extern Atom	wm_delete_window;
extern Widget	topLevel ;
extern Widget	controller ;

typedef enum DisplayNotification { 
  DNStructureChange, DNStateChange, DNDisplayChange, DNNoChange
} DisplayNotification ;

extern int	dispatchExposures() ;
extern int	addUserDisplay  ARGS((String name, 
				      void (*createProc) ARGS((Widget)))) ;

extern void	blockDeviceEvents   ARGS(()) ;
extern void	unblockDeviceEvents ARGS(()) ;
extern void	blockShellDeviceEvents   ARGS((Widget)) ;
extern void	unblockShellDeviceEvents ARGS((Widget)) ;
/**********************************************************************/

#endif				/* DISPLAYXXX_INCLUDED */
