
/**********************************************************************
 * $Id: TraceP.h,v 1.2 92/11/30 11:28:29 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _TraceP_h
#define _TraceP_h

#include <X11/ShellP.h>
#include <xerion/config.h>
#include <xerion/Trace.h>

typedef struct {
  void	*extension;
} TraceClassPart;

typedef struct _TraceClassRec {
  CoreClassPart		core_class;
  CompositeClassPart	composite_class;
  ShellClassPart	shell_class;
  WMShellClassPart	wm_shell_class;
  VendorShellClassPart	vendor_shell_class;
  TransientShellClassPart transient_shell_class;
  TraceClassPart	trace_class;
} TraceClassRec;

extern TraceClassRec traceClassRec;

typedef struct _TracePart {
  /* resources */
  XtCallbackList	callback ;	/* the callback for trace */

  /* private data */
  int			numTraces ;
  String		commandString ;
  String		*traceName ;
  Widget		*toggle ;
} TracePart;

typedef struct _TraceRec {
  CorePart 		core ;
  CompositePart 	composite ;
  ShellPart 		shell ;
  WMShellPart		wm;
  VendorShellPart	vendor;
  TransientShellPart	transient;	
  TracePart		trace ;
} TraceRec;

#endif /* _TraceP_h */
