
/**********************************************************************
 * $Id: Trace.c,v 1.3 92/11/30 11:28:26 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/


/* NOTE: THIS IS NOT A WIDGET!  Rather, this is an interface to a widget.
   It implements policy, and gives a (hopefully) easier-to-use interface
   than just directly making your own form. */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>	
#include <X11/Xaw/Box.h>	
#include <X11/Xaw/Toggle.h>	
#include <X11/Xaw/Command.h>	
#include <X11/Xaw/Label.h>

#include "TraceP.h"

#include "display.h"
#include "displayUtils.h"
#include "display2Itf.h"
#include <xerion/useful.h>

static XtResource resources[] = {
  { XtNcallback,     XtCCallback,      XtRCallback,  sizeof(XtCallbackList),
      XtOffset(TraceWidget, trace.callback),     XtRCallback, NULL}
};

static void	Initialize ARGS((Widget, Widget, ArgList, Cardinal *)) ;
static void	Destroy	   ARGS((Widget)) ;

static void	resetTogglesCB  ARGS((Widget, XtPointer, XtPointer)) ;
static void	unsetTogglesCB  ARGS((Widget, XtPointer, XtPointer)) ;
static void	setTracesCB	ARGS((Widget, XtPointer, XtPointer)) ;

static void	setTraces	ARGS((TraceWidget)) ;
static void	setToggle	ARGS((Widget, int)) ;

static void	registerTraceWidget	ARGS((TraceWidget)) ;
static void	deregisterTraceWidget	ARGS((TraceWidget)) ;
static TraceWidget nameToTraceWidget	ARGS((String)) ;

TraceClassRec traceClassRec = {
  {
    /* superclass	  */	(WidgetClass) &transientShellClassRec,
    /* class_name	  */	"Trace",
    /* size		  */	sizeof(TraceRec),
    /* Class Initializer  */	NULL,
    /* class_part_initialize*/	NULL,
    /* Class init'ed ?	  */	FALSE,
    /* initialize	  */	Initialize,
    /* initialize_notify  */	NULL,		
    /* realize		  */	XtInheritRealize,
    /* actions		  */	NULL,
    /* num_actions	  */	0,
    /* resources	  */	resources,
    /* resource_count	  */	XtNumber(resources),
    /* xrm_class	  */	NULLQUARK,
    /* compress_motion	  */	FALSE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	FALSE,
    /* visible_interest	  */	FALSE,
    /* destroy		  */	Destroy,
    /* resize		  */	XtInheritResize,
    /* expose		  */	NULL,
    /* set_values	  */	NULL,
    /* set_values_hook	  */	NULL,			
    /* set_values_almost  */	XtInheritSetValuesAlmost,  
    /* get_values_hook	  */	NULL,			
    /* accept_focus	  */	NULL,
    /* intrinsics version */	XtVersion,
    /* callback offsets	  */	NULL,
    /* tm_table		  */	XtInheritTranslations,
    /* query_geometry	  */	NULL,
    /* display_accelerator*/	NULL,
    /* extension	  */	NULL
  },{
    /* geometry_manager	  */	XtInheritGeometryManager,
    /* change_managed	  */	XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension	  */	NULL
  },{
    /* extension	  */	NULL
  },{
    /* extension	  */	NULL
  },{
    /* extension	  */	NULL
  },{
    /* extension	  */	NULL
  },{
    /* extension	  */	NULL
  }
} ;

WidgetClass traceWidgetClass = (WidgetClass)&traceClassRec ;

/*********************************************************************
 *	Name:		Initialize
 *	Description:	initialize procedure for the Trace widget
 *	Parameters:
 *	  Widget	request - the requested format
 *	  Widget	new	 - the accepted format
 *	  ArgList	args	 - the args passed at creation
 *	  Cardinal	*numArgs - the number of args
 *	Return Value:
 *	  static void	Initialize - NONE
 *********************************************************************/
static void	Initialize(request, new, args, numArgs)
  Widget	request ;
  Widget	new;
  ArgList	args ;
  Cardinal	*numArgs ;
{
  Widget	w  = (Widget)new ;
  TraceWidget	tw = (TraceWidget)new ;
  Widget	form, box, label, button ;
  char		commandString[256] ;
  String	*list ;
  int		idx ;

  form  = XtVaCreateManagedWidget("form",  formWidgetClass,   w,    NULL) ;
  box   = XtVaCreateManagedWidget("box",   boxWidgetClass,   form, NULL) ;
  label = XtVaCreateManagedWidget("label", labelWidgetClass, box,  NULL) ;

  /* allocate the arrays for the update list */
  list = listTraces() ;
  for (idx = 0 ; list[idx] != NULL ; ++idx)
    ;
  tw->trace.numTraces	= idx ;
  tw->trace.traceName	= (String *)XtCalloc(idx, sizeof(String)) ;
  tw->trace.toggle	= (Widget *)XtCalloc(idx, sizeof(Widget)) ;
  for (idx = 0 ; idx < tw->trace.numTraces ; ++idx) {
    String	name = list[idx] ;
    tw->trace.traceName[idx] = XtNewString(name) ;
    tw->trace.toggle[idx] 
      = XtVaCreateManagedWidget(name, toggleWidgetClass, box, NULL) ;
  }

  /* Buttons */
  button = XtVaCreateManagedWidget("ok", commandWidgetClass, form, 
				   XtNfromVert,		box,
				   NULL) ;
  XtAddCallback(button, XtNcallback, popdownWidgetCB, (XtPointer)tw) ;
  XtAddCallback(button, XtNcallback, setTracesCB,     (XtPointer)tw) ;

  button = XtVaCreateManagedWidget("clear", commandWidgetClass, form, 
				   XtNfromVert,		box,
				   XtNfromHoriz,	button,
				   NULL) ;
  XtAddCallback(button, XtNcallback, unsetTogglesCB, (XtPointer)tw) ;

  button = XtVaCreateManagedWidget("cancel", commandWidgetClass, form, 
				   XtNfromVert,		box,
				   XtNfromHoriz,	button,
				   NULL) ;
  XtAddCallback(button, XtNcallback, popdownWidgetCB, (XtPointer)tw) ;

  XtAddCallback(w, XtNpopupCallback, resetTogglesCB, (XtPointer)tw) ;

  XtInstallAllAccelerators(form, form) ;

  /* set the command string that will trigger the callback */
  sprintf(commandString, "triggerCallbacks \"%s\"", XtName(w)) ;
  tw->trace.commandString = strdup(commandString) ;

  /* set the traces the first time */
  setTraces(tw) ;
  registerTraceWidget(tw) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		Destroy
 *	Description:	destroy procedure for the trace widget
 *	Parameters:
 *	  Widget	w - the widget
 *	Return Value:
 *	  static void	Destroy - NONE
 *********************************************************************/
static void	Destroy(w)
  Widget	w ;
{
  TraceWidget	tw = (TraceWidget)w ;
  int		idx ;

  deregisterTraceWidget(tw) ;

  for (idx = 0 ; idx < tw->trace.numTraces ; ++idx)
    deleteTrace(tw->trace.traceName[idx], tw->trace.commandString) ;

  if (tw->trace.traceName) {
    for (idx = 0 ; idx < tw->trace.numTraces ; ++idx)
      XtFree((void *)tw->trace.traceName[idx]) ;
    XtFree((void *)tw->trace.traceName) ;
  }

  if (tw->trace.toggle)
    XtFree((void *)tw->trace.toggle) ;

  if (tw->trace.commandString)
    XtFree((void *)tw->trace.commandString) ;
}
/********************************************************************/


/***********************************************************************
 *	Name:		setToggle
 *	Description:	changes the state of a toggle button if necessary
 *	Parameters:	
 *	  Widget	toggle  - the toggle button
 *	  int		desired - the desired state of the button (True/False)
 *	Return Value:	NONE
 ***********************************************************************/
static void	setToggle(toggle, desired)
  Widget	toggle ;
  int		desired ;
{
  Boolean	actual ;
  
  XtVaGetValues(toggle, XtNstate, &actual, NULL) ;
  if (actual != (Boolean)desired)
    XtVaSetValues(toggle, XtNstate, desired, NULL) ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		resetTogglesCB
 *	Description:	resets all the toggles in an update display
 *			to either set or unset, depending on whether
 *			the display update is on that trace
 *	  Widget	widget 	   - the widget the callback is attached to
 *	  XtPointer	clientData - the client data (TraceWidget)
 *	  XtPointer	callData   - the call data (unused)
 *	Return Value:
 *		NONE
 ***********************************************************************/
static void	resetTogglesCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  TraceWidget	tw = (TraceWidget)clientData ;
  int		idx ;

  for (idx = 0 ; idx < tw->trace.numTraces ; ++idx)
    setToggle(tw->trace.toggle[idx], 
	      traceOn(tw->trace.traceName[idx], tw->trace.commandString)) ;
}
/**********************************************************************/


/***********************************************************************
 *	Name:		unsetTogglesCB
 *	Description:	unsets all the toggles in a traceWidget
 *	  Widget	widget 	   - the widget the callback is attached to
 *	  XtPointer	clientData - the clientData (TraceWidget)
 *	  XtPointer	callData   - the call data (unused)
 *	Return Value:
 *		NONE
 ***********************************************************************/
static void	unsetTogglesCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  TraceWidget	tw = (TraceWidget)clientData ;
  int		idx ;

  for (idx = 0 ; idx < tw->trace.numTraces ; ++idx)
    setToggle(tw->trace.toggle[idx], False) ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		setTraces(CB)
 *	Description:	either adds or deletes traces (depending on the
 *			state of the toggles in the traceWidget
 *	Parameters:
 *	  Widget	widget     - a toggle widget
 *	  XtPointer	clientData - the clientData (TraceWidget)
 *	  XtPointer	callData   - UNUSED
 *	  TraceWidget	tw         - the TraceWidget
 *	Return Value:
 *	  static void	setTraceCB - NONE
 *********************************************************************/
static void	setTracesCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  setTraces((TraceWidget)clientData) ;
}
/********************************************************************/
static void	setTraces(tw)
  TraceWidget	tw ;
{
  int		idx ;
  Boolean	set ;

  for (idx = 0 ; idx < tw->trace.numTraces ; ++idx) {

    XtVaGetValues(tw->trace.toggle[idx], XtNstate, &set, NULL) ;
    if (set)	
      addTrace   (tw->trace.traceName[idx], tw->trace.commandString) ;
    else
      deleteTrace(tw->trace.traceName[idx], tw->trace.commandString) ;
  }
}
/********************************************************************/


/*******************************************************************
 *	Name:		triggerCallbacks
 *	Description:	triggers the callbacks for a traceWidget
 *	Parameters:
 *	  int	tokc - the number of command line tokens
 *	  char	*tokv[] - the command line tokens
 *	Return Value:
 *	  int	command_triggerCallbacks - 1 on success, 0 otherwise
 *******************************************************************/
int	command_triggerCallbacks(tokc, tokv)
  int	tokc ;
  char	*tokv[] ;
{
  TraceWidget	tw ;

  IUsage("<name>");
  if (GiveHelp(tokc)) {
    ISynopsis("trigger callbacks associated with <name>.");
    IHelp
      (IHelpArgs,
       "This is an internal command used by the \"Updates\" window. It is used",
       "to trigger the display updates using different traces.",
       "",
       "It may be saved in  a file, and then read in  to trigger the display",
       "updates the way you want it.",
       "",
       "SEE ALSO",
       "popup, addTrace",
       NULL);
    return 0;
  }

  if (tokc != 2)
    IErrorAbort(IPrintUsage(tokv[0], usage)) ;

  tw = nameToTraceWidget(tokv[1]) ;
  if (tw == NULL)
    IErrorAbort("Cannot find \"%s\"", tokv[1]) ;
    
  setSignalHandler() ;

  XtCallCallbacks((Widget)tw, XtNcallback, NULL) ;

  if (resetSignalHandler())
    return 0 ;

  return 1 ;
}
/******************************************************************/


/*******************************************************************
 *	Name:		registerTraceWidget
 *	Description:	registers a trace widget for later retrieval
 *			by name
 *	Parameters:
 *	  TraceWidget	tw - the trace widget
 *	Return Value:
 *	  static void	registerTraceWidget - NONE 
 *******************************************************************/
static TraceWidget	*widgetList ;
static Cardinal		listSize ;
/******************************************************************/
static void	registerTraceWidget(tw)
  TraceWidget	tw ;
{
  widgetList = (TraceWidget *)XtRealloc((XtPointer)widgetList, 
					(listSize + 1)*sizeof(*widgetList)) ;
  widgetList[listSize++] = tw ;
}
/******************************************************************/


/*******************************************************************
 *	Name:		deregisterTraceWidget
 *	Description:	removes a trace widget from the registered list
 *	Parameters:
 *	  TraceWidget	tw - the TraceWidget
 *	Return Value:
 *	  static void	deregisterTraceWidget - NONE
 *******************************************************************/
static void	deregisterTraceWidget(tw)
  TraceWidget	tw ;
{
  int	idx ;
  for (idx = 0 ; idx < listSize && tw != widgetList[idx] ; ++idx)
    ;
  if (idx < listSize) {
    for ( ; idx < listSize ; ++idx)
      widgetList[idx] = widgetList[idx + 1] ;
    widgetList = (TraceWidget *)XtRealloc((XtPointer)widgetList,
					  (--listSize)*sizeof(*widgetList)) ;
  }
}
/******************************************************************/


/*******************************************************************
 *	Name:		nameToTraceWidget
 *	Description:	looks up a trace widget given its name
 *	Parameters:
 *	  String	name - the name to look for
 *	Return Value:
 *	  static TraceWidget	nameToTraceWidget - the TraceWidget
 *******************************************************************/
static TraceWidget	nameToTraceWidget(name)
  String		name ;
{
  int	idx ;

  for (idx = 0 ; 
       idx < listSize && strcmp(name, XtName((Widget)widgetList[idx])) ; ++idx)
    ;

  if (idx < listSize)
    return widgetList[idx] ;
  else
    return NULL ;
}
/******************************************************************/

