
/**********************************************************************
 * $Id: ControllerP.h,v 1.3 92/11/30 11:28:25 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef _ControllerP_h
#define _ControllerP_h

#include <X11/Xaw/BoxP.h>
#include <xerion/config.h>
#include <xerion/Controller.h>

typedef struct {
  void	*extension;
} ControllerClassPart;

typedef struct _ControllerClassRec {
  CoreClassPart		core_class;
  CompositeClassPart	composite_class;
  BoxClassPart		box_class;
  ControllerClassPart	controller_class;
} ControllerClassRec;

extern ControllerClassRec controllerClassRec;

typedef struct _ControllerPart {
  /* resources */
  XtCallbackList	callback ;	/* the callback state change */
  XtCallbackList	quitCallback ;	/* the quit callback */

  /* private data */
  int			numShells ;
  Widget		*button ;
  Widget		*shell ;
  Window		selfBlocker ;
  Window		*blocker ;
  Widget		quitButton ;
} ControllerPart;

typedef struct _ControllerRec {
  CorePart		core;
  CompositePart		composite;
  BoxPart 		box;
  ControllerPart	controller ;
} ControllerRec;

#endif /* _ControllerP_h */
