
/**********************************************************************
 * $Id: Controller.c,v 1.3 92/11/30 11:28:22 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/


/* NOTE: THIS IS NOT A WIDGET!  Rather, this is an interface to a widget.
   It implements policy, and gives a (hopefully) easier-to-use interface
   than just directly making your own form. */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/ShellP.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Box.h>	
#include <X11/Xaw/Command.h>	
#include <X11/Xaw/Label.h>

#include "ControllerP.h"

#include "display.h"
#include "displayUtils.h"

#define offset(f)	XtOffset(ControllerWidget, f)

static XtResource resources[] = {
  { XtNquitCallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
      offset(controller.quitCallback), XtRCallback, NULL},
  { XtNcallback, XtCCallback, XtRCallback, sizeof(XtCallbackList),
      offset(controller.callback), XtRCallback, NULL}
};

static void	popupCenteredAction ARGS((Widget, XEvent *, 
					  String *, Cardinal *));
static void	popupRaiseAction    ARGS((Widget, XEvent *, 
					  String *, Cardinal *));
static void	popdownAction	    ARGS((Widget, XEvent *, 
					  String *, Cardinal *));

static XtActionsRec actions[] = {
  {"popupCentered",	popupCenteredAction},
  {"popupRaise",	popupRaiseAction},
  {"popdown",		popdownAction}
};

static void	Initialize ARGS((Widget, Widget, ArgList, Cardinal *)) ;
static void	Destroy	   ARGS((Widget)) ;

static void	recreateQuitButton  ARGS((ControllerWidget));
static void	callQuitCallbacksCB ARGS((Widget, XtPointer, XtPointer)) ;

static void	popupRaiseWidgetCB ARGS((Widget, XtPointer, XtPointer)) ;
static Boolean	createPopupChild   ARGS((XtPointer)) ;
static void	blockInput	   ARGS((Widget, Window)) ;
static void	unblockInput	   ARGS((Widget, Window)) ;

static Window	createBusyWindow   ARGS((Widget)) ;

ControllerClassRec controllerClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &boxClassRec,
    /* class_name         */    "Controller",
    /* widget_size        */    sizeof(ControllerRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    actions,
    /* num_actions	  */	XtNumber(actions),
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    NULL,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },{
/* Box class fields */
    /* empty		  */	0,
  },{
/* Controller class fields */
    /* empty		  */	0,
  }
} ;

WidgetClass controllerWidgetClass = (WidgetClass)&controllerClassRec ;

/*********************************************************************
 *	Name:		Initialize
 *	Description:	initialize procedure for the Controller widget
 *	Parameters:
 *	  Widget	request - the requested format
 *	  Widget	new	 - the accepted format
 *	  ArgList	args	 - the args passed at creation
 *	  Cardinal	*numArgs - the number of args
 *	Return Value:
 *	  static void	Initialize - NONE
 *********************************************************************/
static void	Initialize(request, new, args, numArgs)
  Widget	request ;
  Widget	new;
  ArgList	args ;
  Cardinal	*numArgs ;
{
  Widget		w  = (Widget)new ;
  ControllerWidget	cw = (ControllerWidget)new ;

  redirectKeyboardInput(w) ;

  cw->controller.numShells  = 0 ;
  cw->controller.button	    = NULL ;
  cw->controller.shell	    = NULL ;
  cw->controller.blocker    = NULL ;

  cw->controller.selfBlocker = createBusyWindow(w) ;
  
  /* The label */
  XtVaCreateManagedWidget("displays", labelWidgetClass, w, NULL) ;

  /* The quit button */
  cw->controller.quitButton = NULL ;
  recreateQuitButton(cw) ;

  XtInstallAllAccelerators(w, w) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		Destroy
 *	Description:	destroy procedure for the trace widget
 *	Parameters:
 *	  Widget	w - the widget
 *	Return Value:
 *	  static void	Destroy - NONE
 *********************************************************************/
static void	Destroy(w)
  Widget	w ;
{
  ControllerWidget	cw = (ControllerWidget)w ;

  if (cw->controller.button)
    XtFree((XtPointer)cw->controller.button) ;
  if (cw->controller.shell)
    XtFree((XtPointer)cw->controller.shell) ;
  if (cw->controller.blocker)
    XtFree((XtPointer)cw->controller.blocker) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		recreateQuitButton
 *	Description:	(destroys) and creates the quit button (adding
 *			appropriate callbacsk
 *	Parameters:
 *	  ControllerWidget	cw - the controllerWidget
 *	Return Value:
 *	  static void		recreateQuitButton - NONE
 *********************************************************************/
static void		recreateQuitButton(cw)
  ControllerWidget	cw ;
{
  if (cw->controller.quitButton)
    XtDestroyWidget(cw->controller.quitButton) ;
  
  cw->controller.quitButton 
    = XtVaCreateManagedWidget("quit", commandWidgetClass, (Widget)cw, NULL) ;
  XtAddCallback(cw->controller.quitButton, 
		XtNcallback, callQuitCallbacksCB, (XtPointer)cw) ;
#if 0
  XtSetKeyboardFocus(cw->controller.quitButton, (Widget)cw);
#endif
}
/********************************************************************/


/*********************************************************************
 *	Name:		callQuitCallbacksCB
 *	Description:	
 *	Parameters:
 *	  Widget	widget - 
 *	  XtPointer	clientData - 
 *	  XtPointer	callData - 
 *	Return Value:
 *	  static void	callQuitCallbacksCB - 
 *********************************************************************/
static void	callQuitCallbacksCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  XtCallCallbacks((Widget)clientData, XtNquitCallback, NULL) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		controllerAddDisplay
 *	Description:	adds a display to the controller
 *	Parameters:
 *	  Widget		w - the controller widget
 *	  String		name - that *base* name for the display
 *	  WidgetClass		shellClass - transient or toplevel
 *	  DisplayCreateProc	proc - the create proc for the display
 *	Return Value:
 *	  Widget		controllerAddDisplay - the shell around
 *					the display.
 *********************************************************************/
Widget			controllerAddDisplay(w, name, shellClass, proc)
  Widget		w ;
  String		name ;
  WidgetClass		shellClass ;
  DisplayCreateProc	proc ;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  XtAppContext		appContext = XtWidgetToApplicationContext(w) ;
  char			displayName[BUFSIZ] ;
  Widget		shell, button ;
  Cardinal		oldSize ;

  if (!XtIsSubclass(w, controllerWidgetClass))
    return NULL ;

  oldSize = cw->controller.numShells++ ;
  cw->controller.button
    = (Widget *)XtRealloc((XtPointer)cw->controller.button,  
			  (oldSize + 1)*sizeof(Widget));
  cw->controller.shell
    = (Widget *)XtRealloc((XtPointer)cw->controller.shell,  
			  (oldSize + 1)*sizeof(Widget));
  cw->controller.blocker 
    = (Window *)XtRealloc((XtPointer)cw->controller.blocker,
			  (oldSize + 1)*sizeof(Window));

  button = XtVaCreateManagedWidget(name, commandWidgetClass, w, NULL) ;

  sprintf(displayName, "%sDisplay", name) ;

  for (shell = w ;
       !XtIsSubclass(shell, shellWidgetClass) ; shell = XtParent(shell)) 
    ;

  if (shell == NULL)
    shell = w ;

  shell = XtVaCreatePopupShell(displayName, shellClass, shell,
			       XtNcreatePopupChildProc, proc,
			       NULL) ;

  XtAppAddWorkProc(appContext, createPopupChild, (XtPointer)shell) ;

  if (shellClass == transientShellWidgetClass)
    XtAddCallback(button, XtNcallback,  popupCenteredCB,    (XtPointer)shell) ;
  else
    XtAddCallback(button, XtNcallback,  popupRaiseWidgetCB, (XtPointer)shell) ;

  cw->controller.button[oldSize]  = button ;
  cw->controller.shell[oldSize]   = shell ;
  cw->controller.blocker[oldSize] = createBusyWindow(shell) ;

#if 0
  XtSetKeyboardFocus(button, parent);
#endif

  recreateQuitButton(cw) ;

  return shell ;
}
/********************************************************************/

/*********************************************************************
 *	Name:		controllerRemoveDisplay
 *	Description:	removes a display (destroys shell, button, 
 *			and blocking window) ;
 *	Parameters:
 *	  Widget	w - the controller window
 *	  Widget	shell - the display to destroy (from 
 *				controllerAddDisplay)
 *	Return Value:
 *	  void		controllerRemoveDisplay - NONE
 *********************************************************************/
void		controllerRemoveDisplay(w, shell)
  Widget	w ;
  Widget	shell ;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  Cardinal		idx ;

  if (!XtIsSubclass(w, controllerWidgetClass))
    return ;

  for (idx = 0 ; idx < cw->controller.numShells ; ++idx) {
    if (shell == cw->controller.shell[idx])
      break ;
  }

  if (idx == cw->controller.numShells)
    return ;

  XtDestroyWidget(cw->controller.shell[idx]) ;
  XtDestroyWidget(cw->controller.button[idx]) ;
  if (cw->controller.blocker[idx])
    XDestroyWindow(XtDisplay(shell), cw->controller.blocker[idx]) ;

  for (++idx ; idx < cw->controller.numShells ; ++idx) {
    cw->controller.button[idx - 1]  = cw->controller.button[idx] ;
    cw->controller.shell[idx - 1]   = cw->controller.shell[idx] ;
    cw->controller.blocker[idx - 1] = cw->controller.blocker[idx] ;
  }

  --cw->controller.numShells ;
  cw->controller.button
    = (Widget *)XtRealloc((XtPointer)cw->controller.button,  
			  (cw->controller.numShells)*sizeof(Widget));
  cw->controller.shell
    = (Widget *)XtRealloc((XtPointer)cw->controller.shell,  
			  (cw->controller.numShells)*sizeof(Widget));
  cw->controller.blocker 
    = (Window *)XtRealloc((XtPointer)cw->controller.blocker,
			  (cw->controller.numShells)*sizeof(Window));

}
/********************************************************************/

/**********************************************************************
 *	Name:		popupRaiseWidgetCB
 *	Description:	pops up a popup shell which is passed in as
 *			the client data
 *	Parameters:
 *		Widget	widget 	   - the widget the callback is attached to
 *		XtPointer	clientData - the shell to pop up
 *		XtPointer	callData   - the call data (unused)
 *	Return Value:
 *		NONE
 **********************************************************************/
static void	popupRaiseWidgetCB(widget, clientData, callData)
  Widget	widget ;
  XtPointer	clientData ;
  XtPointer	callData ;
{
  Widget	popup = (Widget)clientData ;

  if (((ShellWidget)popup)->shell.popped_up == TRUE) {
    XBell(XtDisplay(popup), (int)0) ;
    XRaiseWindow(XtDisplay(popup), XtWindow(popup)) ;
  } else {
    XtPopup(popup, XtGrabNone) ;
    XSetWMProtocols(XtDisplay(popup), XtWindow(popup), &wm_delete_window, 1);
  }
}
/**********************************************************************/


/*********************************************************************
 *	Name:		controllerBlockInput
 *	Description:	blocks all input to the shells controlled
 *	Parameters:
 *	  Widget	w - the controller widget
 *	  Widget	shell - the shell to block, (NULL if all)
 *	Return Value:
 *	  void		controllerBlockInput - NONE
 *********************************************************************/
void		controllerBlockInput(w, shell)
  Widget	w ;
  Widget	shell ;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  int			idx ;

  if (!XtIsSubclass(w, controllerWidgetClass))
    return ;

  /* block yourself */
  if (shell == NULL) {
    if (cw->controller.selfBlocker == NULL)
      cw->controller.selfBlocker = createBusyWindow(w) ;
    blockInput(w, cw->controller.selfBlocker) ;
  }
  
  /* block all the children */
  for (idx = 0 ; idx < cw->controller.numShells ; ++idx) {
    if (shell == NULL || shell == cw->controller.shell[idx]) {
      if (cw->controller.blocker[idx] == NULL)
	cw->controller.blocker[idx] 
	  = createBusyWindow(cw->controller.shell[idx]) ;
      blockInput(cw->controller.shell[idx], cw->controller.blocker[idx]) ;
    }
  }
}
/********************************************************************/


/*********************************************************************
 *	Name:		controllerUnblockInput
 *	Description:	unblocks any blocked input to the controlled
 *			shells ;
 *	Parameters:
 *	  Widget	w - the controller widget
 *	  Widget	shell - the shell to unblock, (NULL if all)
 *	Return Value:
 *	  void		controllerUnblockInput - NONE
 *********************************************************************/
void		controllerUnblockInput(w, shell)
  Widget	w ;
  Widget	shell ;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  int			idx ;

  if (!XtIsSubclass(w, controllerWidgetClass))
    return ;

  if (shell == NULL)
    unblockInput(w, cw->controller.selfBlocker) ;

  for (idx = 0 ; idx < cw->controller.numShells ; ++idx)
    if (shell == NULL || shell == cw->controller.shell[idx])
      unblockInput(cw->controller.shell[idx], cw->controller.blocker[idx]) ;
}
/********************************************************************/


/**********************************************************************/
static void	blockInput(shell, window)
  Widget	shell ;
  Window	window ;
{
  if (shell && XtIsRealized(shell) && window) {
    XMapWindow  (XtDisplay(shell), window) ;
    XRaiseWindow(XtDisplay(shell), window) ;
    XFlush(XtDisplay(shell)) ;
  }
}
/**********************************************************************/
static void	unblockInput(shell, window)
  Widget	shell ;
  Window	window ;
{
  if (shell && XtIsRealized(shell) && window)
    XUnmapWindow(XtDisplay(shell), window) ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		controllerTriggerCallbacks
 *	Description:	triggers the callbacks on the controller. 
 *	Parameters:
 *	  Widget	w - the controller widget
 *	  XtPointer	callData - the calldata to pass
 *	Return Value:
 *	  void		controllerTriggerCallbacks - NONE
 *********************************************************************/
void		controllerTriggerCallbacks(w, callData)
  Widget	w ;
  XtPointer	callData ;
{
  if (!XtIsSubclass(w, controllerWidgetClass))
    return ;

  XtCallCallbacks(w, XtNcallback, callData) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		createPopupChild
 *	Description:	work procedure to call the createPopup proc for
 *			a popup shell
 *	Parameters:
 *	  XtPointer	clientData - the popup shell
 *	Return Value:
 *	  static Boolean	CreatePopupChild - TRUE
 *********************************************************************/
static Boolean	createPopupChild(clientData)
  XtPointer	clientData ;
{
  Widget		shell = (Widget)clientData ;
  DisplayCreateProc	proc ;

  XtVaGetValues(shell, XtNcreatePopupChildProc, &proc, NULL) ;
  if (proc)
    proc(shell) ;
  return TRUE ;
}
/********************************************************************/


/**********************************************************************/
static void	popupRaiseAction(w, event, params, numParams)
  Widget	w;
  XEvent 	*event;
  String 	*params;
  Cardinal 	*numParams;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  String		name, geometry ;
  int			idx ;

  if (!XtIsSubclass(w, controllerWidgetClass)
      || *numParams < 1 || *numParams > 2)
    return ;

  name     = params[0] ;
  geometry = *numParams == 2 ? params[1] : NULL ;

  for (idx = 0 ; 
       idx < cw->controller.numShells
       && strcmp(name, XtName(cw->controller.shell[idx])) ; ++idx) 
    ;
  if (idx >= cw->controller.numShells)
    return ;

  if (geometry)
    XtVaSetValues(cw->controller.shell[idx], XtNgeometry, geometry, NULL) ;
  XtPopup(cw->controller.shell[idx], XtGrabNone);
}
/**********************************************************************/
static void	popupCenteredAction(w, event, params, numParams)
  Widget	w;
  XEvent 	*event;
  String 	*params;
  Cardinal 	*numParams;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  String		name, geometry ;
  int			idx ;

  if (!XtIsSubclass(w, controllerWidgetClass)
      || *numParams < 1 || *numParams > 2)
    return ;

  name     = params[0] ;
  geometry = *numParams == 2 ? params[1] : NULL ;

  for (idx = 0 ; 
       idx < cw->controller.numShells
       && strcmp(name, XtName(cw->controller.shell[idx])) ; ++idx) 
    ;
  if (idx >= cw->controller.numShells)
    return ;

  if (geometry)
    XtVaSetValues(cw->controller.shell[idx], XtNgeometry, geometry, NULL) ;
  popupCentered(cw->controller.shell[idx], XtGrabExclusive);
}
/**********************************************************************/
static void	popdownAction(w, event, params, numParams)
  Widget	w;
  XEvent 	*event;
  String 	*params;
  Cardinal 	*numParams;
{
  ControllerWidget	cw = (ControllerWidget)w ;
  String		name, geometry ;
  int			idx ;

  if (!XtIsSubclass(w, controllerWidgetClass)
      || *numParams < 1 || *numParams > 2)
    return ;

  name     = params[0] ;
  geometry = *numParams == 2 ? params[1] : NULL ;

  for (idx = 0 ; 
       idx < cw->controller.numShells
       && strcmp(name, XtName(cw->controller.shell[idx])) ; ++idx) 
    ;

  if (idx >= cw->controller.numShells)
    return ;

  XtPopdown(cw->controller.shell[idx]);
}
/**********************************************************************/


/***********************************************************************
 *	Name:		createBusyWindow
 *	Description:	creates a window as large as the screen which
 *			should stop all deviceEvents to the given shell
 *			while it is mapped and raised
 *	Parameters:	
 *		Widget	shell - the shell to be busy for
 *	Return Value:	
 *		Window	createBusyWindow - the newly created window
 ***********************************************************************/
static Window	createBusyWindow(w)
  Widget	w ;
{
  unsigned long 	valuemask ;
  XSetWindowAttributes	attributes ;
  Widget		shell ;
  Window		window ;

  for (shell = w ; 
       !XtIsSubclass(shell, shellWidgetClass) ; shell = XtParent(shell))
    ;

  if (!XtIsRealized(shell))
    return NULL ;

  /* Ignore device events while the busy cursor is displayed. */
  valuemask = CWDontPropagate | CWCursor ;
  attributes.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
				       ButtonPressMask | ButtonReleaseMask |
				       PointerMotionMask) ;
  attributes.cursor = XCreateFontCursor(XtDisplay(shell), XC_watch) ;

  /* The window will be as big as the display screen, and clipped by
     its own parent window, so we never have to worry about resizing */
  window = XCreateWindow(XtDisplay(shell), XtWindow(shell), 0, 0,
			 WidthOfScreen(XtScreen(shell)), 
			 HeightOfScreen(XtScreen(shell)),
			 (unsigned int) 0, CopyFromParent, InputOnly,
			 CopyFromParent, valuemask, &attributes) ;
  return window ;
}
/**********************************************************************/
