
/**********************************************************************
 * $Id: simulatorHelp.h,v 1.2 92/11/30 11:27:45 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/**********************************************************************
 * These help strings will be automatically registered 
 * and made available to the "whatis" command and "Help"
 * buttons on the GUI
 *
 * THIS FILE SHOULD ONLY BE INCLUDED BY THE FILE "minimize.c"
 * ANY OTHER FILE INCLUDING IT WILL CAUSE NAME CONFLICTS
 *
 **********************************************************************/

#ifndef __simulator_help_h
#define __simulator_help_h

/**********************************************************************/
char	*helpString_name[] = {
  "The name of the object, as passed to its creation function.",
  NULL } ;
/**********************************************************************/
char	*helpString_extension[] = {
  "This is an empty  field that can be  used  for extensions to avoid the",
  "need  to recompile all the libraries.  It (initially) contains  a NULL",
  "pointer  which  may  be assigned  the address  of  a  user-defined and",
  "allocated data structure.",
  NULL } ;
/**********************************************************************/
char	*helpString_type[] = {
  "This is a  bitmask describing the type of the object.  It is passed in",
  "to  the  creation  function and  should  contain  some  combination of",
  "user-defined masks. It should not  be changed once the object has been",
  "created.",
  NULL } ;
/**********************************************************************/
char	*helpString_error[] = {
  "The network error on the current example (or set of examples).",
  NULL } ;
/**********************************************************************/
char	*helpString_cost[] = {
  "The cost  of the  network, usually  due  to  magnitude  of the network",
  "weights.",
  NULL } ;
/**********************************************************************/
char	*helpString_currentEpoch[] = {
  "The  number of training iterations  (weight  updates) the  network has",
  "been through since the weights were initialized.",
  NULL } ;
/**********************************************************************/
char	*helpString_batchSize[] = {
  "The number of examples to process during each batch of training. If",
  "this value is set to 1, the net will be training online. If set to",
  "0, all the examples in the training set will be processed before",
  "updating the weights, and the net will be doing batch training.  Any",
  "other positive number can be used for \"semi-batch\" learning.",
  NULL } ;
/**********************************************************************/
char	*helpString_variables[] = {
  "An array of values associated  with  the weights of  the links in  the",
  "net. There is one value for each unconstrained link.",
  NULL } ;
/**********************************************************************/

/**********************************************************************/
/**********************************************************************/
#endif /* __simulator_help_h */
