
/**********************************************************************
 * $Id: minimizeHelp.h,v 1.2 92/11/30 11:27:41 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/**********************************************************************
 * These help strings will be automatically registered 
 * and made available to the "whatis" command and "Help"
 * buttons on the GUI
 *
 * THIS FILE SHOULD ONLY BE INCLUDED BY THE FILE "minimize.c"
 * ANY OTHER FILE INCLUDING IT WILL CAUSE NAME CONFLICTS
 *
 **********************************************************************/

#ifndef minimize_help_h
#define minimize_help_h


/**********************************************************************/
char	*helpString_acceptableFuncMin[] = {
  "The acceptable function minimum.  Minimize terminates if the",
  "function value becomes less than or equal to this value.",
  NULL } ;
/**********************************************************************/
char	*helpString_alpha[] = {
  "The rate of decay form momentum and deltaBarDelta descent. The",
  "default value is 0.9.",
  NULL } ;
/**********************************************************************/
char	*helpString_askStep[] = {
  "If non-zero Minimize prints out the information that is used by",
  "various line searches to choose an initial step and then asks the",
  "user to type an initial step. If the user does not enter a positive",
  "number the slope ratio initial step is used.",
  NULL } ;
/**********************************************************************/
char	*helpString_backUpFactor[] = {
  "The factor by which to back up on a line search when it is obvious",
  "that too large a step has been taken.  The default value is 3.",
  NULL } ;
/**********************************************************************/
char	*helpString_continueDirection[] = {
  "All direction methods (except steepest descent) use information",
  "about previous gradients in calculating the next direction to move",
  "in.  This information is saved by the Minimize command when it",
  "terminates.  If Minimize is called again without changing any",
  "network values and with the same methods, then this information is",
  "restored and Minimize continues as though it had never stopped. If",
  "continueDirection is set to zero this feature will be disabled.",
  NULL } ;
/**********************************************************************/
char	*helpString_doNotCheckFunctions[] = {
  "By default, Minimize runs some consistency checks on the supplied",
  "functions the first time it sees a network.  These checks can be",
  "skipped by giving the setting doNotCheckFunctions to a non-zero",
  "value.",
  NULL } ;
/**********************************************************************/
char	*helpString_epsilon[] = {
  "The fixed step line search (-fixedStep) moves a distance of epsilon",
  "along the direction vector.",
  NULL } ;
/**********************************************************************/
char	*helpString_expectedFuncMin[] = {
  "The expected minimum value of the function.  The default value is 0.",
  NULL } ;
/**********************************************************************/
char	*helpString_extensor[] = {
  "Used in line search to make an extrapolation guess when the cubic",
  "fit fails.  Its value should be greater than 1.  The default value",
  "is 2.  A conservative value is 1.3.",
  NULL } ;
/**********************************************************************/
char	*helpString_extrapLimits[] = {
  "Controls how close a new point can be to the ends of the",
  "extrapolation interval.  Its value should be between 0 and 0.5.  A",
  "low value allows the new point to be close to the edges",
  "(conservative), a value near 0.5 forces the new point to be in the",
  "center of the interval. The default is 0.35.",
  NULL } ;
/**********************************************************************/
char	*helpString_funcPrecision[] = {
  "Used by the wobble test. See the sman page for minimize.",
  NULL } ;
/**********************************************************************/
char	*helpString_funcValueScale[] = {
  "Used by the wobble test. See the sman page for minimize.",
  NULL } ;
/**********************************************************************/
char	*helpString_gainDecrement[] = {
  "The multiplicative gain decrement for deltaBarDelta, which should be",
  "a positive value less than one.  The default value is 0.9.",
  NULL } ;
/**********************************************************************/
char	*helpString_gainIncrement[] = {
  "The additive gain increment for deltaBarDelta, which should be a",
  "small positive value.  The default value is 0.1.",
  NULL } ;
/**********************************************************************/
char	*helpString_initialStepFactor[] = {
  "Used by the line searches. The initial step factor in a shooting",
  "initial step.  The default value is 2.",
  NULL } ;
/**********************************************************************/
char	*helpString_interpLimits[] = {
  "Controls how close a new point can be to the ends of the",
  "iterpolation interval.  Its value should be between 0 and 0.5.  A",
  "low value allows the new point to be close to the edges, a value",
  "near 0.5 forces the new point to be in the center of the interval.",
  "The default is 0.05.",
  NULL } ;
/**********************************************************************/
char	*helpString_lsFlexFuncEvals[] = {
  "The number of function evaluations by which a line search is allowed",
  "to exceed maxFuncEvals.  This is designed to allow Minimize to stop",
  "neatly at the proper end of a line search.  By default this is set",
  "to the value of lsMaxFuncEvals.",
  NULL } ;
/**********************************************************************/
char	*helpString_lsLogFile[] = {
  "The name of a file for Minimize to write summaries of the line",
  "search, along with information relevant to the initial step size",
  "guess to.",
  NULL } ;
/**********************************************************************/
char	*helpString_maxExtrapol[] = {
  "Used by line searches to set new bounds for extrapolation under the",
  "no-bracket condition.  Its value should be greater than 1.  The",
  "default value is 9.",
  NULL } ;
/**********************************************************************/
char	*helpString_lsMaxFuncEvals[] = {
  "The maximum number of function evaluations that are allowed to be",
  "computed in any single line search.  If the line search does not",
  "find any lower function value within this number of function",
  "evaluations, Minimize will stop.  The default value is 10.",
  NULL } ;
/**********************************************************************/
char	*helpString_lsSummarize[] = {
  "If non-zero, Minimize will print line search summaries, which give",
  "the step-size, function value and slope at each point investigated",
  "by the line search.",
  NULL } ;
/**********************************************************************/
char	*helpString_lsVerbosity[] = {
  "Controls the amount of statistics printed by the line searches as",
  "they run.  Higher numbers mean more messages. It can be set to",
  "numbers between 0 and 3 (default 0).",
  NULL } ;
/**********************************************************************/
char	*helpString_maxFuncEvals[] = {
  "The maximum number of function evaluations that minimize can perform.",
  NULL } ;
/**********************************************************************/
char	*helpString_maxGrowthFactor[] = {
  "The maximum permissible increase in the step taken on a particular",
  "component for quickProp. 1.75 is the default value.  Sensible values",
  "are positive.",
  NULL } ;
/**********************************************************************/
char	*helpString_maxIterations[] = {
  "The maximum number of iterations that minimize can perform.",
  NULL } ;
/**********************************************************************/
char	*helpString_maxSlopeRatio[] = {
  "Used by the line searches. The maximum (absolute) ratio of new and old",
  "slopes that is acceptable. The maximum slope ratio should be between the",
  "minimum function reduction parameter and 1.  Low values (e.g., 0.1) result",
  "in a strict line search and high values (e.g., 0.9) result in a weak",
  "line search.  The default value is 0.5.",
  NULL } ;
/**********************************************************************/
char	*helpString_minFuncReduction[] = {
  "Used by the line searches. The fraction of the expected change in",
  "the function value that must be seen for the new position to be",
  "accepted. Should be between 0 and 0.5.  The default value is 1.0e-6.",
  NULL } ;
/**********************************************************************/
char	*helpString_mzVerbosity[] = {
  "Controls the amount of statistics printed by minimize as it runs.",
  "Higher numbers mean more messages. It can be set to numbers between",
  "0 and 3 (default 1).",
  NULL } ;
/**********************************************************************/
char	*helpString_qpEpsilon[] = {
  "The steepest descent component to the direction for quickProp. This",
  "kick-starts the method and prevents stalling. Sensible values are",
  "small positive numbers.",
  NULL } ;

/**********************************************************************/
char	*helpString_repetitionCount[] = {
  "Controls when the trace minimizeEndRepetition is run and when the",
  "level 1 verbosity messages of Minimize are output (every",
  "<repetitionCount> iterations).",
  NULL } ;
/**********************************************************************/
char	*helpString_stepBound[] = {
  "Controls the bounds on the allowable step sizes in line searches.",
  "Low values give narrow bounds, and high values give wide bounds.",
  "Its value should be greater than or equal to 2.  The default value",
  "is 10.",
  NULL } ;
/**********************************************************************/
char	*helpString_tolerance[] = {
  "The termination tolerance.",
  NULL } ;
/**********************************************************************/

#endif				/* minimize_help_h */
